/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.licensechange.Check;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangePlugin;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.plugins.licensechange.Severity;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLicenseCheck
extends Check {
    private LicenseChangePlugin plugin;

    public BasicLicenseCheck(LicenseChangePlugin p) {
        super(I18n.tr((String)"Basic License Check."), I18n.tr((String)"Checks if all contributors have agreed to the new CT/License."));
        this.plugin = p;
    }

    @Override
    public void visit(Node n) {
        List<User> users = this.plugin.getUsers(n);
        this.doCheck((OsmPrimitive)n, users);
    }

    @Override
    public void visit(Way w) {
        List<User> users = this.plugin.getUsers(w);
        this.doCheck((OsmPrimitive)w, users);
    }

    @Override
    public void visit(Relation r) {
        List<User> users = this.plugin.getUsers(r);
        this.doCheck((OsmPrimitive)r, users);
    }

    private void doCheck(OsmPrimitive n, List<User> users) {
        Severity sev = null;
        if (users != null && n.getUser() != null) {
            int u0 = users.get(0).getRelicensingStatus();
            String msg = null;
            if (u0 == 2 || u0 == 4) {
                sev = Severity.DATA_LOSS;
                msg = u0 == 2 ? I18n.tr((String)"Creator has rejected CT") : I18n.tr((String)"Creator unknown");
            } else if (u0 == 0) {
                sev = Severity.POSSIBLE_DATA_LOSS;
                msg = I18n.tr((String)"Creator has not (yet) accepted CT");
            } else {
                for (int i = 1; i < users.size(); ++i) {
                    int ux = users.get(i).getRelicensingStatus();
                    if (ux != 2 && ux != 4 && ux != 0) continue;
                    sev = Severity.DATA_REDUCTION;
                    msg = I18n.tr((String)"Object modified by user(s) who have rejected, or not agreed to, CT");
                    break;
                }
            }
            if (sev != null) {
                List<OsmPrimitive> x = Arrays.asList(n);
                this.errors.add(new LicenseProblem(this, sev, msg, x, x));
            }
        }
    }
}

