/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.licensechange;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.AggregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.licensechange.BasicLicenseCheck;
import org.openstreetmap.josm.plugins.licensechange.Check;
import org.openstreetmap.josm.plugins.licensechange.LicenseChangePlugin;
import org.openstreetmap.josm.plugins.licensechange.LicenseProblem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class CheckAction
extends JosmAction {
    private LicenseChangePlugin plugin;
    private Collection<OsmPrimitive> lastSelection;

    public CheckAction(LicenseChangePlugin plugin) {
        super(I18n.tr((String)"License Check"), "licensechange", I18n.tr((String)"Performs the license check"), Shortcut.registerShortcut((String)"tools:licensechange", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"License Check")}), (int)67, (int)3, (int)1), true);
        this.plugin = plugin;
    }

    public void actionPerformed(ActionEvent ev) {
        this.doCheck(ev);
    }

    public void doCheck(ActionEvent ev) {
        if (this.plugin.checkAction == null || Main.map == null || !Main.map.isVisible()) {
            return;
        }
        this.plugin.initializeProblemLayer();
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        if (selection.isEmpty()) {
            selection = Main.main.getCurrentDataSet().allNonDeletedPrimitives();
            this.lastSelection = null;
        } else {
            AggregatePrimitivesVisitor v = new AggregatePrimitivesVisitor();
            this.lastSelection = selection = v.visit(selection);
        }
        CheckTask task = new CheckTask(selection, this.lastSelection);
        Main.worker.submit((Runnable)((Object)task));
    }

    public void updateEnabledState() {
        this.setEnabled(CheckAction.getEditLayer() != null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckTask
    extends PleaseWaitRunnable {
        private Check licenseCheck;
        private Collection<OsmPrimitive> validatedPrimitives;
        private Collection<OsmPrimitive> formerValidatedPrimitives;
        private boolean canceled;
        private List<LicenseProblem> problems;

        public CheckTask(Collection<OsmPrimitive> validatedPrimitives, Collection<OsmPrimitive> formerValidatedPrimitives) {
            super(I18n.tr((String)"Loading"), false);
            this.validatedPrimitives = validatedPrimitives;
            this.formerValidatedPrimitives = formerValidatedPrimitives;
            this.licenseCheck = new BasicLicenseCheck(CheckAction.this.plugin);
        }

        protected void cancel() {
            this.canceled = true;
        }

        protected void finish() {
            if (this.canceled) {
                return;
            }
            Runnable r = new Runnable(){

                public void run() {
                    ((CheckAction)CheckAction.this).plugin.problemDialog.tree.setErrors(CheckTask.this.problems);
                    ((CheckAction)CheckAction.this).plugin.problemDialog.setVisible(true);
                    Main.main.getCurrentDataSet().fireSelectionChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            this.getProgressMonitor().indeterminateSubTask(I18n.tr((String)"Loading from Quick History Service..."));
            CheckAction.this.plugin.loadDataFromQuickHistoryService(this.validatedPrimitives);
            this.problems = new ArrayList<LicenseProblem>(200);
            boolean testCounter = false;
            this.getProgressMonitor().indeterminateSubTask(I18n.tr((String)"Analyzing..."));
            this.licenseCheck.startCheck(this.getProgressMonitor());
            this.licenseCheck.visit(this.validatedPrimitives);
            this.licenseCheck.endCheck();
            this.problems.addAll(this.licenseCheck.getProblems());
        }
    }
}

