/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.fastdraw.DrawnPolyLine;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.plugins.fastdraw.FastDrawConfigDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

class FastDrawingMode
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private static final String SIMPLIFYMODE_MESSAGE = I18n.tr((String)"Q=Options, Enter=save, Ctrl-Enter=save with tags, Up/Down=tune");
    private static final String DRAWINGMODE_MESSAGE = I18n.tr((String)"Click or Click&drag to continue, Ctrl-Click to add fixed node, Shift-Click to delete, Enter to simplify or save, Ctrl-Shift-Click to start new line");
    private FDSettings settings;
    private DrawnPolyLine line;
    private MapView mv;
    private String statusText;
    private boolean drawing;
    private boolean ctrl;
    private boolean shift;
    private double eps;
    private Stroke strokeForSimplified;
    private Stroke strokeForOriginal;
    private final Cursor cursorDraw;
    private final Cursor cursorCtrl;
    private final Cursor cursorShift;
    private final Cursor cursorReady;
    private final Cursor cursorNode;
    private final Cursor cursorDrawing;
    private boolean nearSomeNode;
    private LatLon highlighted;
    private int nearestIdx;
    private Stroke strokeForDelete;
    private int dragNode = -1;
    private SequenceCommand delCmd;
    private List<Node> oldNodes;
    private final TreeSet<Integer> set = new TreeSet();
    private Timer timer;
    private KeyEvent releaseEvent;
    private boolean lineWasSaved;
    private boolean deltaChanged;

    FastDrawingMode(MapFrame mapFrame) {
        super(I18n.tr((String)"FastDrawing"), "turbopen.png", I18n.tr((String)"Fast drawing mode"), Shortcut.registerShortcut((String)"mapmode/building", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Fast drawing mode")}), (int)84, (int)3), mapFrame, Cursor.getPredefinedCursor(0));
        this.line = new DrawnPolyLine();
        this.cursorDraw = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorCtrl = ImageProvider.getCursor((String)"crosshair", (String)"fixed");
        this.cursorShift = ImageProvider.getCursor((String)"crosshair", (String)"new");
        this.cursorReady = ImageProvider.getCursor((String)"crosshair", (String)"ready");
        this.cursorNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.cursorDrawing = ImageProvider.getCursor((String)"crosshair", (String)"mode");
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.lineWasSaved = false;
        this.settings = new FDSettings();
        this.settings.loadPrefs();
        this.settings.savePrefs();
        this.strokeForOriginal = new BasicStroke(this.settings.lineWidth);
        this.strokeForDelete = new BasicStroke(3.0f);
        this.strokeForSimplified = this.strokeForOriginal;
        this.eps = this.settings.startingEps;
        this.mv = Main.map.mapView;
        this.line.setMv(this.mv);
        if (FastDrawingMode.getCurrentDataSet() == null) {
            return;
        }
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FastDrawingMode.this.timer.stop();
                if (FastDrawingMode.this.set.remove(FastDrawingMode.this.releaseEvent.getKeyCode())) {
                    FastDrawingMode.this.doKeyReleaseEvent(FastDrawingMode.this.releaseEvent);
                }
            }
        });
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        if (this.line.wasSimplified() && !this.lineWasSaved) {
            this.saveAsWay(false);
        }
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.settings.savePrefs();
        Main.map.mapView.setCursor(this.cursorDraw);
        this.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(FastDrawingMode.getEditLayer() != null);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        Point lp;
        Color initLineColor;
        LinkedList<LatLon> pts = this.line.getPoints();
        if (pts.isEmpty()) {
            return;
        }
        if (this.line.wasSimplified()) {
            g.setStroke(this.strokeForSimplified);
        } else {
            g.setStroke(this.strokeForOriginal);
        }
        Point p1 = this.line.getPoint(pts.get(0));
        g.setColor(this.settings.COLOR_FIXED);
        g.fillOval(p1.x - 3, p1.y - 3, 7, 7);
        Color lineColor = initLineColor = this.line.wasSimplified() ? this.settings.COLOR_SIMPLIFIED : this.settings.COLOR_NORMAL;
        int dp = this.line.wasSimplified() ? 7 : 3 + (int)this.settings.lineWidth / 2 * 2;
        int rp = dp / 2;
        if (pts.size() > 1) {
            ListIterator<LatLon> it1 = pts.listIterator(0);
            ListIterator<LatLon> it2 = pts.listIterator(1);
            for (int i = 0; i < pts.size() - 1; ++i) {
                LatLon pp1 = (LatLon)it1.next();
                p1 = this.line.getPoint(pp1);
                LatLon pp2 = (LatLon)it2.next();
                Point p2 = this.line.getPoint(pp2);
                if (this.shift && this.highlighted == pp1 && this.nearestIdx < 0) {
                    lineColor = this.settings.COLOR_SELECTEDFRAGMENT;
                }
                if (!this.shift && this.line.isLastPoint(i)) {
                    lineColor = this.settings.COLOR_EDITEDFRAGMENT;
                }
                g.setColor(lineColor);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                if (this.line.isFixed(pp2)) {
                    lineColor = initLineColor;
                    g.setColor(this.settings.COLOR_FIXED);
                    g.fillOval(p2.x - 3, p2.y - 3, 7, 7);
                } else {
                    g.fillRect(p2.x - rp, p2.y - rp, dp, dp);
                }
                if (this.drawing || this.line.wasSimplified() || this.nearestIdx != i + 1) continue;
                if (this.shift) {
                    g.setStroke(this.strokeForDelete);
                    g.setColor(this.settings.COLOR_DELETE);
                    g.drawLine(p2.x - 5, p2.y - 5, p2.x + 5, p2.y + 5);
                    g.drawLine(p2.x - 5, p2.y + 5, p2.x + 5, p2.y - 5);
                    g.setStroke(this.strokeForOriginal);
                    continue;
                }
                if (!this.ctrl) continue;
                g.setStroke(this.strokeForDelete);
                g.setColor(this.line.isFixed(pp2) ? this.settings.COLOR_NORMAL : this.settings.COLOR_FIXED);
                g.drawOval(p2.x - 5, p2.y - 5, 11, 11);
                g.setStroke(this.strokeForOriginal);
            }
        }
        if (this.settings.drawLastSegment && !this.drawing && this.dragNode < 0 && !this.shift && this.nearestIdx <= 0 && !this.line.wasSimplified()) {
            g.setColor(lineColor);
            lp = this.line.getLastPoint();
            Point mp = Main.map.mapView.getMousePosition();
            if (lp != null && mp != null) {
                g.drawLine(lp.x, lp.y, mp.x, mp.y);
            }
        }
        if (this.deltaChanged) {
            g.setColor(lineColor);
            lp = this.line.getLastPoint();
            int r = (int)this.settings.minPixelsBetweenPoints;
            if (lp != null) {
                g.drawOval(lp.x - r, lp.y - r, 2 * r, 2 * r);
            }
        }
    }

    public void eventDispatched(AWTEvent event) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)event);
        if (event instanceof KeyEvent) {
            KeyEvent e = (KeyEvent)event;
            if (event.getID() == 401) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                } else {
                    this.set.add(e.getKeyCode());
                }
                this.doKeyEvent((KeyEvent)event);
            }
            if (event.getID() == 402) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                    if (this.set.remove(e.getKeyCode())) {
                        this.doKeyReleaseEvent(e);
                    }
                } else {
                    this.releaseEvent = e;
                    this.timer.restart();
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        int idx = this.line.findClosestPoint(e.getPoint(), this.settings.maxDist);
        if (idx == 0 && !this.line.isClosed()) {
            this.line.closeLine();
            this.drawing = false;
            this.dragNode = 0;
            this.updateCursor();
            return;
        }
        if (this.ctrl && this.shift) {
            this.newDrawing();
            this.repaint();
            return;
        }
        if (!this.ctrl && this.shift) {
            if (idx >= 0) {
                this.line.deleteNode(idx);
                this.nearestIdx = -1;
            } else {
                this.line.tryToDeleteSegment(e.getPoint());
            }
            return;
        }
        if (idx >= 0) {
            if (this.ctrl) {
                this.line.toggleFixed(idx);
            }
            this.dragNode = idx;
            return;
        }
        this.startDrawing(e.getPoint(), this.settings.fixedClick);
    }

    private void startDrawing(Point point, boolean fixFlag) {
        Node nd1;
        this.drawing = true;
        if (this.line.wasSimplified()) {
            this.saveAsWay(false);
            this.newDrawing();
        }
        LatLon p = this.mv.getLatLon(point.x, point.y);
        if (this.settings.snapNodes && (nd1 = this.getNearestNode(point, this.settings.maxDist)) != null) {
            p = nd1.getCoor();
            this.line.fixPoint(p);
        }
        this.line.addLast(p);
        if (this.ctrl || fixFlag) {
            this.line.fixPoint(p);
        }
        this.setStatusLine(I18n.tr((String)"Please move the mouse to draw new way"));
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.stopDrawing();
    }

    private void stopDrawing() {
        if (!this.isEnabled()) {
            return;
        }
        this.dragNode = -1;
        this.drawing = false;
        this.highlighted = null;
        if (!this.line.isClosed()) {
            this.setStatusLine(DRAWINGMODE_MESSAGE);
        }
        this.updateCursor();
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        int nearestIdx2;
        if (!this.isEnabled()) {
            return;
        }
        this.deltaChanged = false;
        Node nd1 = this.getNearestNode(e.getPoint(), this.settings.maxDist);
        boolean nearSomeNode2 = nd1 != null;
        boolean needRepaint = false;
        if (this.nearSomeNode != nearSomeNode2) {
            this.nearSomeNode = nearSomeNode2;
            this.updateCursor();
            needRepaint = true;
        }
        if (this.nearestIdx != (nearestIdx2 = this.line.findClosestPoint(e.getPoint(), this.settings.maxDist))) {
            this.nearestIdx = nearestIdx2;
            this.updateCursor();
            needRepaint = true;
        }
        if (this.settings.drawLastSegment) {
            needRepaint = true;
        }
        if (!this.drawing) {
            if (this.dragNode >= 0) {
                this.line.moveNode(this.dragNode, this.getLatLon(e));
                this.repaint();
                return;
            }
            if (this.shift) {
                LatLon h2 = this.line.findBigSegment(e.getPoint());
                if (this.highlighted != h2) {
                    this.highlighted = h2;
                    this.repaint();
                }
            } else if (needRepaint) {
                this.repaint();
            }
            return;
        }
        if (this.line.isClosed()) {
            this.setStatusLine(SIMPLIFYMODE_MESSAGE);
        }
        if (this.nearestIdx >= 0) {
            return;
        }
        Point lastP = this.line.getLastPoint();
        if (this.nearSomeNode) {
            if (this.settings.snapNodes && Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > 0.01) {
                this.line.addFixed(nd1.getCoor());
                this.repaint();
                return;
            }
        } else if (Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > this.settings.minPixelsBetweenPoints) {
            this.line.addLast(this.getLatLon(e));
            this.repaint();
            return;
        }
    }

    private void doKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 8: {
                if (this.line.wasSimplified()) {
                    this.line.clearSimplifiedVersion();
                    this.repaint();
                    this.eps = this.settings.startingEps;
                }
                this.back();
                break;
            }
            case 10: {
                e.consume();
                if (!this.line.wasSimplified()) {
                    switch (this.settings.simplifyMode) {
                        case 0: {
                            this.eps = this.line.autoSimplify(this.settings.startingEps, this.settings.epsilonMult, this.settings.pkmBlockSize, this.settings.maxPointsPerKm);
                            break;
                        }
                        case 1: {
                            this.line.simplify(this.eps);
                        }
                    }
                    if (this.settings.simplifyMode == 2) {
                        this.saveAsWay(true);
                        break;
                    }
                    this.repaint();
                    this.showSimplifyHint();
                    break;
                }
                this.saveAsWay(true);
                break;
            }
            case 40: {
                e.consume();
                if (this.line.wasSimplified()) {
                    this.changeEpsilon(this.settings.epsilonMult);
                    break;
                }
                this.changeDelta(0.9090909090909091);
                break;
            }
            case 38: {
                e.consume();
                if (this.line.wasSimplified()) {
                    this.changeEpsilon(1.0 / this.settings.epsilonMult);
                    break;
                }
                this.changeDelta(1.1);
                break;
            }
            case 27: {
                boolean answer;
                e.consume();
                Point lastPoint = this.line.getLastPoint();
                if (!this.line.isClosed()) {
                    this.line.moveToTheEnd();
                }
                if (lastPoint != null && !lastPoint.equals(this.line.getLastPoint()) || this.line.getPoints().size() > 5 && !(answer = ConditionalOptionPaneUtil.showConfirmationDialog((String)"delete_drawn_line", (Component)Main.parent, (Object)I18n.tr((String)"Are you sure you do not want to save the line containing {0} points?", (Object[])new Object[]{this.line.getPoints().size()}), (String)I18n.tr((String)"Delete confirmation"), (int)0, (int)3, (int)0))) break;
                this.newDrawing();
                this.exitMode();
                Main.map.selectSelectTool(false);
                break;
            }
            case 84: {
                this.tryToLoadWay();
                break;
            }
            case 73: {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"{0} m - length of the line\n{1} nodes\n{2} points per km (maximum)\n{3} points per km (average)", (Object[])new Object[]{this.line.getLength(), this.line.getPoints().size(), this.line.getNodesPerKm(this.settings.pkmBlockSize), this.line.getNodesPerKm(1000000)}), I18n.tr((String)"Line information"), 1);
                break;
            }
            case 81: {
                e.consume();
                try {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                    new FastDrawConfigDialog(this.settings);
                    if (this.line.wasSimplified()) {
                        this.eps = this.line.autoSimplify(this.settings.startingEps, this.settings.epsilonMult, this.settings.pkmBlockSize, this.settings.maxPointsPerKm);
                        this.showSimplifyHint();
                    }
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
                }
                catch (SecurityException ex) {
                    // empty catch block
                }
                this.repaint();
                break;
            }
            case 32: {
                Point p;
                e.consume();
                if (this.drawing || (p = Main.map.mapView.getMousePosition()) == null) break;
                this.startDrawing(p, this.settings.fixedSpacebar);
            }
        }
    }

    private void doKeyReleaseEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.stopDrawing();
        }
        this.updateCursor();
    }

    private void updateKeyModifiers(InputEvent e) {
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
        this.updateCursor();
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.statusText);
        Main.map.statusLine.repaint();
    }

    public void newDrawing() {
        this.delCmd = null;
        this.oldNodes = null;
        this.eps = this.settings.startingEps;
        this.line.clear();
    }

    private void saveAsWay(boolean autoExit) {
        LinkedList<LatLon> pts = this.line.getPoints();
        int n = pts.size();
        if (n < 2) {
            return;
        }
        if (this.line.isClosed() && n == 2) {
            return;
        }
        if (this.line.isClosed() && n == 3) {
            pts.remove(2);
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        int i = 0;
        Way w = new Way();
        LatLon first = (LatLon)pts.get(0);
        Node firstNode = null;
        for (LatLon p : pts) {
            Node nd = null;
            nd = Main.map.mapView.getNearestNode(this.line.getPoint(p), OsmPrimitive.isSelectablePredicate);
            if (nd != null && p.greatCircleDistance(nd.getCoor()) > 0.01) {
                nd = null;
            }
            if (nd == null) {
                if (i > 0 && p.equals((Object)first)) {
                    nd = firstNode;
                } else {
                    nd = new Node(p);
                    cmds.add(new AddCommand((OsmPrimitive)nd));
                }
            }
            if (nd.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place node outside of the world."));
                return;
            }
            if (i == 0) {
                firstNode = nd;
            }
            w.addNode(nd);
            ++i;
        }
        if (this.ctrl) {
            HashSet<Way> ts = new HashSet<Way>();
            ts.add(w);
            PasteTagsAction.TagPaster tp = new PasteTagsAction.TagPaster((Collection)Main.pasteBuffer.getDirectlyAdded(), ts);
            List execute = tp.execute();
            HashMap tgs = new HashMap();
            for (Tag t : execute) {
                w.put(t.getKey(), t.getValue());
            }
        }
        if (this.delCmd != null) {
            List nodes = w.getNodes();
            for (Node nd : this.oldNodes) {
                List refs;
                if (nodes.contains(nd) || !(refs = nd.getReferrers()).isEmpty() || nd.isDeleted() || !nd.isUsable()) continue;
                cmds.add(new DeleteCommand((OsmPrimitive)nd));
            }
            cmds.add(new AddCommand((OsmPrimitive)w));
        } else {
            cmds.add(new AddCommand((OsmPrimitive)w));
        }
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Draw the way by mouse"), cmds);
        if (!Main.main.hasEditLayer()) {
            return;
        }
        Main.main.undoRedo.add((Command)c);
        this.lineWasSaved = true;
        this.newDrawing();
        if (autoExit) {
            this.exitMode();
            FastDrawingMode.getCurrentDataSet().setSelected(new PrimitiveId[]{w});
            Main.map.selectSelectTool(false);
        }
    }

    public void back() {
        this.line.undo();
        this.repaint();
    }

    void changeEpsilon(double k) {
        this.eps *= k;
        this.line.simplify(this.eps);
        this.showSimplifyHint();
        this.repaint();
    }

    void changeDelta(double k) {
        this.settings.minPixelsBetweenPoints *= k;
        this.deltaChanged = true;
        this.setStatusLine(I18n.tr((String)"min distance={0} px ({1} m)", (Object[])new Object[]{(int)this.settings.minPixelsBetweenPoints, this.mv.getDist100Pixel() / 100.0 * this.settings.minPixelsBetweenPoints}));
        this.repaint();
    }

    private void loadFromWay(Way w) {
        LinkedList<LatLon> pts = this.line.getPoints();
        LinkedList<Command> cmds = new LinkedList<Command>();
        Object firstNode = null;
        Object[] nodes = w.getNodes().toArray();
        int n = nodes.length;
        if (w.isClosed()) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            Node nd = (Node)nodes[i];
            this.line.addLast(nd.getCoor());
        }
        if (w.isClosed()) {
            this.line.closeLine();
        }
        this.oldNodes = w.getNodes();
        ArrayList<Way> wl = new ArrayList<Way>();
        wl.add(w);
        Command c = DeleteCommand.delete((OsmDataLayer)FastDrawingMode.getEditLayer(), wl, (boolean)false);
        if (c != null) {
            cmds.add(c);
        }
        this.delCmd = new SequenceCommand(I18n.tr((String)"Convert way to FastDraw line"), cmds);
        Main.main.undoRedo.add((Command)this.delCmd);
    }

    private void setStatusLine(String tr) {
        this.statusText = tr;
        this.updateStatusLine();
    }

    private void showSimplifyHint() {
        this.setStatusLine(I18n.tr((String)"Eps={0}, {1} points, {2} p/km", (Object[])new Object[]{this.eps, this.line.getSimplePointsCount(), this.line.getNodesPerKm(this.settings.pkmBlockSize)}) + " " + SIMPLIFYMODE_MESSAGE);
    }

    private void updateCursor() {
        if (this.shift) {
            Main.map.mapView.setCursor(this.cursorShift);
        } else if (this.line.isClosed() || this.nearestIdx == 0) {
            Main.map.mapView.setCursor(this.cursorReady);
        } else if (this.ctrl) {
            Main.map.mapView.setCursor(this.cursorCtrl);
        } else if (this.nearSomeNode && this.settings.snapNodes) {
            Main.map.mapView.setCursor(this.cursorCtrl);
        } else if (this.drawing) {
            Main.map.mapView.setCursor(this.cursorDrawing);
        } else {
            Main.map.mapView.setCursor(this.cursorDraw);
        }
    }

    private void repaint() {
        Main.map.mapView.repaint();
    }

    private Node getNearestNode(Point point, double maxDist) {
        Node nd = Main.map.mapView.getNearestNode(point, OsmPrimitive.isSelectablePredicate);
        if (nd != null && this.line.getPoint(nd.getCoor()).distance(point) <= maxDist) {
            return nd;
        }
        return null;
    }

    LatLon getLatLon(MouseEvent e) {
        return this.mv.getLatLon(e.getX(), e.getY());
    }

    private void tryToLoadWay() {
        Way w;
        this.updateCursor();
        Collection selectedWays = Main.main.getCurrentDataSet().getSelectedWays();
        if (selectedWays != null && selectedWays.size() == 1 && this.line.getPoints().size() == 0 && (w = (Way)selectedWays.iterator().next()).isNew()) {
            this.loadFromWay(w);
        }
    }
}

