/*
 * Decompiled with CFR 0.152.
 */
package gpxfilter;

import gpxfilter.GpxGrabber;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.JpgImporter;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGpxLayer
extends Layer {
    private static final String PREF_DOWNLOAD_ALONG_TRACK_DISTANCE = "gpxLayer.downloadAlongTrack.distance";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_AREA = "gpxLayer.downloadAlongTrack.area";
    private static final String PREF_DOWNLOAD_ALONG_TRACK_NEAR = "gpxLayer.downloadAlongTrack.near";
    public final GpxData data = new GpxData();
    protected static final double PHI = Math.toRadians(15.0);
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private colorModes computeCacheColored;
    private int computeCacheColorTracksTune;
    private boolean isLocalFile;
    private final List<GpxTrack> lastTracks = new ArrayList<GpxTrack>();
    private int lastUpdateCount;
    private final Bounds bounds;
    private volatile boolean painting;
    private static Color[] colors = new Color[256];
    private static int ll0;
    private static int sl4;
    private static int sl9;
    private static int[][] dir;

    public EGpxLayer(Bounds b) {
        super("GPX Data");
        this.bounds = b;
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GpxGrabber grabber = new GpxGrabber(EGpxLayer.this.bounds);
                while (true) {
                    GpxData newData;
                    try {
                        newData = grabber.parseRawGps();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    if (newData == null || !newData.hasTrackPoints()) break;
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        EGpxLayer.this.data.mergeFrom(newData);
                    }
                    if (EGpxLayer.this.painting) continue;
                    Main.map.repaint();
                }
                grabber.cancel();
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"layer", (String)"gpx_small");
    }

    public synchronized Object getInfoComponent() {
        StringBuilder info = new StringBuilder();
        if (this.data.attr.containsKey("name")) {
            info.append(I18n.tr((String)"Name: {0}", (Object[])new Object[]{this.data.attr.get("meta.name")})).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            info.append(I18n.tr((String)"Description: {0}", (Object[])new Object[]{this.data.attr.get("meta.desc")})).append("<br>");
        }
        if (this.data.tracks.size() > 0) {
            info.append("<table><thead align='center'><tr><td colspan='5'>" + I18n.trn((String)"{0} track", (String)"{0} tracks", (long)this.data.tracks.size(), (Object[])new Object[]{this.data.tracks.size()}) + "</td></tr><tr align='center'><td>" + I18n.tr((String)"Name") + "</td><td>" + I18n.tr((String)"Description") + "</td><td>" + I18n.tr((String)"Timespan") + "</td><td>" + I18n.tr((String)"Length") + "</td><td>" + I18n.tr((String)"URL") + "</td></tr></thead>");
            for (GpxTrack trk : this.data.tracks) {
                WayPoint earliest = null;
                WayPoint latest = null;
                info.append("<tr><td>");
                if (trk.getAttributes().containsKey("name")) {
                    info.append(trk.getAttributes().get("name"));
                }
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("desc")) {
                    info.append(" ").append(trk.getAttributes().get("desc"));
                }
                info.append("</td><td>");
                for (GpxTrackSegment seg : trk.getSegments()) {
                    for (WayPoint pnt : seg.getWayPoints()) {
                        if (latest == null) {
                            latest = earliest = pnt;
                            continue;
                        }
                        if (pnt.compareTo(earliest) < 0) {
                            earliest = pnt;
                            continue;
                        }
                        latest = pnt;
                    }
                }
                if (earliest != null && latest != null) {
                    String latestDate;
                    DateFormat df = DateFormat.getDateInstance(3);
                    String earliestDate = df.format(earliest.getTime());
                    if (earliestDate.equals(latestDate = df.format(latest.getTime()))) {
                        DateFormat tf = DateFormat.getTimeInstance(3);
                        info.append(earliestDate).append(" ");
                        info.append(tf.format(earliest.getTime())).append(" - ").append(tf.format(latest.getTime()));
                    } else {
                        DateFormat dtf = DateFormat.getDateTimeInstance(3, 3);
                        info.append(dtf.format(earliest.getTime())).append(" - ").append(dtf.format(latest.getTime()));
                    }
                    int diff = (int)(latest.time - earliest.time);
                    info.append(String.format(" (%d:%02d)", diff / 3600, diff % 3600 / 60));
                }
                info.append("</td><td>");
                info.append(NavigatableComponent.getSystemOfMeasurement().getDistText(trk.length()));
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("url")) {
                    info.append(trk.getAttributes().get("url"));
                }
                info.append("</td></tr>");
            }
            info.append("</table><br><br>");
        }
        info.append(I18n.tr((String)"Length: {0}", (Object[])new Object[]{NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length())})).append("<br>");
        info.append(I18n.trn((String)"{0} route, ", (String)"{0} routes, ", (long)this.data.routes.size(), (Object[])new Object[]{this.data.routes.size()})).append(I18n.trn((String)"{0} waypoint", (String)"{0} waypoints", (long)this.data.waypoints.size(), (Object[])new Object[]{this.data.waypoints.size()})).append("<br>");
        final JScrollPane sp = new JScrollPane((Component)new HtmlPanel(info.toString()), 20, 30);
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width, 350));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                sp.getVerticalScrollBar().setValue(0);
            }
        });
        return sp;
    }

    public static Color getColor(String name) {
        return Main.pref.getColor(I18n.marktr((String)"gps point"), name != null ? "layer " + name : null, Color.gray);
    }

    public Action[] getMenuEntries() {
        if (Main.applet) {
            return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new CustomizeColor(), new CustomizeLineDrawing(), new ConvertToDataLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
        }
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction((Layer)this), new Layer.LayerSaveAsAction((Layer)this), new CustomizeColor(), new CustomizeLineDrawing(), new ImportImages(), new ImportAudio(), new MarkersFromNamedPoins(), new ConvertToDataLayerAction(), new DownloadAlongTrackAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public synchronized String getToolTipText() {
        StringBuilder info = new StringBuilder().append("<html>");
        if (this.data.attr.containsKey("name")) {
            info.append(I18n.tr((String)"Name: {0}", (Object[])new Object[]{this.data.attr.get("meta.name")})).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            info.append(I18n.tr((String)"Description: {0}", (Object[])new Object[]{this.data.attr.get("meta.desc")})).append("<br>");
        }
        info.append(I18n.trn((String)"{0} track, ", (String)"{0} tracks, ", (long)this.data.tracks.size(), (Object[])new Object[]{this.data.tracks.size()}));
        info.append(I18n.trn((String)"{0} route, ", (String)"{0} routes, ", (long)this.data.routes.size(), (Object[])new Object[]{this.data.routes.size()}));
        info.append(I18n.trn((String)"{0} waypoint", (String)"{0} waypoints", (long)this.data.waypoints.size(), (Object[])new Object[]{this.data.waypoints.size()})).append("<br>");
        info.append(I18n.tr((String)"Length: {0}", (Object[])new Object[]{NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length())}));
        info.append("<br>");
        return info.append("</html>").toString();
    }

    public boolean isMergable(Layer other) {
        return other instanceof EGpxLayer;
    }

    private synchronized int sumUpdateCount() {
        int updateCount = 0;
        for (GpxTrack track : this.data.tracks) {
            updateCount += track.getUpdateCount();
        }
        return updateCount;
    }

    public synchronized boolean isChanged() {
        if (((Object)this.data.tracks).equals(this.lastTracks)) {
            return this.sumUpdateCount() != this.lastUpdateCount;
        }
        return true;
    }

    public synchronized void mergeFrom(Layer from) {
        this.data.mergeFrom(((EGpxLayer)from).data);
        this.computeCacheInSync = false;
    }

    public synchronized void paint(Graphics2D g, MapView mv, Bounds box) {
        Point screen;
        LatLon c;
        LatLon c2;
        Point oldA;
        Point old;
        this.painting = true;
        this.lastUpdateCount = this.sumUpdateCount();
        this.lastTracks.clear();
        this.lastTracks.addAll(this.data.tracks);
        Color neutralColor = EGpxLayer.getColor(this.getName());
        boolean forceLines = Main.pref.getBoolean("draw.rawgps.lines.force");
        boolean direction = Main.pref.getBoolean("draw.rawgps.direction");
        int lineWidth = Main.pref.getInteger("draw.rawgps.linewidth", 0);
        int maxLineLength = this.isLocalFile ? Main.pref.getInteger("draw.rawgps.max-line-length.local", -1) : Main.pref.getInteger("draw.rawgps.max-line-length", 200);
        boolean lines = Main.pref.getBoolean("draw.rawgps.lines", true) || Main.pref.getBoolean("draw.rawgps.lines.localfiles") && this.isLocalFile;
        String linesKey = "draw.rawgps.lines.layer " + this.getName();
        if (Main.pref.hasKey(linesKey)) {
            lines = Main.pref.getBoolean(linesKey);
        }
        boolean large = Main.pref.getBoolean("draw.rawgps.large");
        boolean hdopcircle = Main.pref.getBoolean("draw.rawgps.hdopcircle", true);
        colorModes colored = colorModes.none;
        try {
            colored = colorModes.values()[Main.pref.getInteger("draw.rawgps.colors", 0)];
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean alternatedirection = Main.pref.getBoolean("draw.rawgps.alternatedirection");
        int delta = Main.pref.getInteger("draw.rawgps.min-arrow-distance", 0);
        int colorTracksTune = Main.pref.getInteger("draw.rawgps.colorTracksTune", 45);
        if (lineWidth != 0) {
            g.setStroke(new BasicStroke(lineWidth, 1, 1));
        }
        if (this.computeCacheMaxLineLengthUsed != maxLineLength || !neutralColor.equals(this.computeCacheColorUsed) || this.computeCacheColored != colored || this.computeCacheColorTracksTune != colorTracksTune) {
            this.computeCacheMaxLineLengthUsed = maxLineLength;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = neutralColor;
            this.computeCacheColored = colored;
            this.computeCacheColorTracksTune = colorTracksTune;
        }
        if (!this.computeCacheInSync) {
            WayPoint oldWp = null;
            for (GpxTrack trk : this.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : trk.getSegments()) {
                    if (!forceLines) {
                        oldWp = null;
                    }
                    for (WayPoint trkPnt2 : gpxTrackSegment.getWayPoints()) {
                        LatLon c22 = trkPnt2.getCoor();
                        if (Double.isNaN(c22.lat()) || Double.isNaN(c22.lon())) continue;
                        trkPnt2.customColoring = neutralColor;
                        if (oldWp != null) {
                            double dist = c22.greatCircleDistance(oldWp.getCoor());
                            switch (colored) {
                                case velocity: {
                                    double dtime = trkPnt2.time - oldWp.time;
                                    double vel = dist / dtime;
                                    double velColor = vel / (double)colorTracksTune * 255.0;
                                    if (dtime <= 0.0 || vel < 0.0 || velColor > 255.0) {
                                        trkPnt2.customColoring = colors[255];
                                        break;
                                    }
                                    trkPnt2.customColoring = colors[(int)velColor];
                                    break;
                                }
                                case dilution: {
                                    int hdoplvl;
                                    if (trkPnt2.attr.get("hdop") == null) break;
                                    float hdop = ((Float)trkPnt2.attr.get("hdop")).floatValue();
                                    if (hdop < 0.0f) {
                                        hdop = 0.0f;
                                    }
                                    int hdopcolor = 255 - ((hdoplvl = Math.round(hdop * (float)Main.pref.getInteger("hdop.factor", 25))) > 255 ? 255 : hdoplvl);
                                    trkPnt2.customColoring = colors[hdopcolor];
                                }
                            }
                            if (maxLineLength == -1 || dist <= (double)maxLineLength) {
                                trkPnt2.drawLine = true;
                                trkPnt2.dir = (int)oldWp.getCoor().heading(trkPnt2.getCoor());
                            } else {
                                trkPnt2.drawLine = false;
                            }
                        } else {
                            trkPnt2.drawLine = false;
                        }
                        oldWp = trkPnt2;
                    }
                }
            }
            this.computeCacheInSync = true;
        }
        ArrayList<Collection> visibleSegments = new ArrayList<Collection>();
        for (GpxTrack trk : this.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : trk.getSegments()) {
                if (gpxTrackSegment.getBounds() == null || !gpxTrackSegment.getBounds().intersects(box)) continue;
                visibleSegments.add(gpxTrackSegment.getWayPoints());
            }
        }
        if (lines) {
            old = null;
            for (Collection segment : visibleSegments) {
                for (WayPoint trkPnt3 : segment) {
                    LatLon c3 = trkPnt3.getCoor();
                    if (Double.isNaN(c3.lat()) || Double.isNaN(c3.lon())) continue;
                    Point screen2 = mv.getPoint(trkPnt3.getEastNorth());
                    if (trkPnt3.drawLine && old != null && (old.x != screen2.x || old.y != screen2.y)) {
                        g.setColor(trkPnt3.customColoring);
                        g.drawLine(old.x, old.y, screen2.x, screen2.y);
                    }
                    old = screen2;
                }
            }
        }
        if (lines && direction && !alternatedirection) {
            old = null;
            oldA = null;
            for (Collection collection : visibleSegments) {
                for (WayPoint trkPnt : collection) {
                    c2 = trkPnt.getCoor();
                    if (Double.isNaN(c2.lat()) || Double.isNaN(c2.lon()) || !trkPnt.drawLine) continue;
                    Point screen3 = mv.getPoint(trkPnt.getEastNorth());
                    if (old != null && (oldA == null || screen3.x < oldA.x - delta || screen3.x > oldA.x + delta || screen3.y < oldA.y - delta || screen3.y > oldA.y + delta)) {
                        g.setColor(trkPnt.customColoring);
                        double t = Math.atan2(screen3.y - old.y, screen3.x - old.x) + Math.PI;
                        g.drawLine(screen3.x, screen3.y, (int)((double)screen3.x + 10.0 * Math.cos(t - PHI)), (int)((double)screen3.y + 10.0 * Math.sin(t - PHI)));
                        g.drawLine(screen3.x, screen3.y, (int)((double)screen3.x + 10.0 * Math.cos(t + PHI)), (int)((double)screen3.y + 10.0 * Math.sin(t + PHI)));
                        oldA = screen3;
                    }
                    old = screen3;
                }
            }
        }
        if (lines && direction && alternatedirection) {
            old = null;
            oldA = null;
            for (Collection collection : visibleSegments) {
                for (WayPoint trkPnt : collection) {
                    c2 = trkPnt.getCoor();
                    if (Double.isNaN(c2.lat()) || Double.isNaN(c2.lon()) || !trkPnt.drawLine) continue;
                    Point screen4 = mv.getPoint(trkPnt.getEastNorth());
                    if (old != null && (oldA == null || screen4.x < oldA.x - delta || screen4.x > oldA.x + delta || screen4.y < oldA.y - delta || screen4.y > oldA.y + delta)) {
                        g.setColor(trkPnt.customColoring);
                        g.drawLine(screen4.x, screen4.y, screen4.x + dir[trkPnt.dir][0], screen4.y + dir[trkPnt.dir][1]);
                        g.drawLine(screen4.x, screen4.y, screen4.x + dir[trkPnt.dir][2], screen4.y + dir[trkPnt.dir][3]);
                        oldA = screen4;
                    }
                    old = screen4;
                }
            }
        }
        if (large || hdopcircle) {
            g.setColor(neutralColor);
            for (Collection segment : visibleSegments) {
                for (WayPoint wayPoint : segment) {
                    c = wayPoint.getCoor();
                    if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                    screen = mv.getPoint(wayPoint.getEastNorth());
                    g.setColor(wayPoint.customColoring);
                    if (hdopcircle && wayPoint.attr.get("hdop") != null) {
                        float hdop = ((Float)wayPoint.attr.get("hdop")).floatValue();
                        if (hdop < 0.0f) {
                            hdop = 0.0f;
                        }
                        int hdopp = mv.getPoint((LatLon)new LatLon((double)wayPoint.getCoor().lat(), (double)(wayPoint.getCoor().lon() + (double)(12.0f * hdop * 360.0f / 4.0E7f)))).x - screen.x;
                        g.drawArc(screen.x - hdopp / 2, screen.y - hdopp / 2, hdopp, hdopp, 0, 360);
                    }
                    if (!large) continue;
                    g.fillRect(screen.x - 1, screen.y - 1, 3, 3);
                }
            }
        }
        if (!large && lines) {
            g.setColor(neutralColor);
            for (Collection segment : visibleSegments) {
                for (WayPoint wayPoint : segment) {
                    c = wayPoint.getCoor();
                    if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || wayPoint.drawLine) continue;
                    screen = mv.getPoint(wayPoint.getEastNorth());
                    g.drawRect(screen.x, screen.y, 0, 0);
                }
            }
        }
        if (!large && !lines) {
            g.setColor(neutralColor);
            for (Collection segment : visibleSegments) {
                for (WayPoint wayPoint : segment) {
                    c = wayPoint.getCoor();
                    if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                    screen = mv.getPoint(wayPoint.getEastNorth());
                    g.setColor(wayPoint.customColoring);
                    g.drawRect(screen.x, screen.y, 0, 0);
                }
            }
        }
        this.painting = false;
    }

    public synchronized void visitBoundingBox(BoundingXYVisitor v) {
        v.visit(this.data.recalculateBounds());
    }

    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    private static void addToDownload(Area a, Rectangle2D r, Collection<Rectangle2D> results, double max_area) {
        Area tmp = new Area(r);
        tmp.intersect(a);
        if (tmp.isEmpty()) {
            return;
        }
        Rectangle2D bounds = tmp.getBounds2D();
        if (bounds.getWidth() * bounds.getHeight() > max_area) {
            Rectangle2D.Double r2;
            Rectangle2D.Double r1;
            if (bounds.getWidth() > bounds.getHeight()) {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
                r2 = new Rectangle2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
            } else {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() / 2.0);
                r2 = new Rectangle2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight() / 2.0);
            }
            EGpxLayer.addToDownload(a, r1, results, max_area);
            EGpxLayer.addToDownload(a, r2, results, max_area);
        } else {
            results.add(bounds);
        }
    }

    private void importAudio(File wavFile, MarkerLayer ml, double firstStartTime, Markers markers) {
        URL url = null;
        try {
            url = wavFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Unable to convert filename " + wavFile.getAbsolutePath() + " to URL");
        }
        ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
        boolean timedMarkersOmitted = false;
        boolean untimedMarkersOmitted = false;
        double snapDistance = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPointFromTimeStamp = null;
        double firstTime = -1.0;
        if (this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack track : this.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    Iterator i$ = seg.getWayPoints().iterator();
                    if (i$.hasNext()) {
                        WayPoint w = (WayPoint)i$.next();
                        firstTime = w.time;
                    }
                    if (!(firstTime >= 0.0)) continue;
                    break;
                }
                if (!(firstTime >= 0.0)) continue;
                break;
            }
        }
        if (firstTime < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No GPX track available in layer to associate audio with."), I18n.tr((String)"Error"), 0);
            return;
        }
        if (Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint w : this.data.waypoints) {
                if (w.time > firstTime) {
                    waypoints.add(w);
                    continue;
                }
                if (!(w.time > 0.0)) continue;
                timedMarkersOmitted = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true) && this.data.waypoints != null && !this.data.waypoints.isEmpty()) {
            for (WayPoint w : this.data.waypoints) {
                if (waypoints.contains(w)) continue;
                WayPoint wNear = this.nearestPointOnTrack(w.getEastNorth(), snapDistance);
                if (wNear != null) {
                    WayPoint wc = new WayPoint(w.getCoor());
                    wc.time = wNear.time;
                    if (w.attr.containsKey("name")) {
                        wc.attr.put("name", w.getString("name"));
                    }
                    waypoints.add(wc);
                    continue;
                }
                untimedMarkersOmitted = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            for (GpxTrack track : this.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint w : seg.getWayPoints()) {
                        if (!w.attr.containsKey("name") && !w.attr.containsKey("desc")) continue;
                        waypoints.add(w);
                    }
                }
            }
        }
        if (Main.pref.getBoolean("marker.audiofromwavtimestamps", false) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            double lastModified = (double)wavFile.lastModified() / 1000.0;
            double duration = AudioUtil.getCalibratedDuration((File)wavFile);
            double startTime = lastModified - duration;
            startTime = firstStartTime + (startTime - firstStartTime) / Main.pref.getDouble("audio.calibration", "1.0");
            WayPoint w1 = null;
            WayPoint w2 = null;
            block9: for (GpxTrack track : this.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint w : seg.getWayPoints()) {
                        if (startTime < w.time) {
                            w2 = w;
                            break;
                        }
                        w1 = w;
                    }
                    if (w2 == null) continue;
                    continue block9;
                }
            }
            if (w1 == null || w2 == null) {
                timedMarkersOmitted = true;
            } else {
                wayPointFromTimeStamp = new WayPoint(w1.getCoor().interpolate(w2.getCoor(), (startTime - w1.time) / (w2.time - w1.time)));
                wayPointFromTimeStamp.time = startTime;
                String name = wavFile.getName();
                int dot = name.lastIndexOf(".");
                if (dot > 0) {
                    name = name.substring(0, dot);
                }
                wayPointFromTimeStamp.attr.put("name", name);
                waypoints.add(wayPointFromTimeStamp);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || waypoints.isEmpty()) && this.data.tracks != null && !this.data.tracks.isEmpty()) {
            boolean gotOne = false;
            for (GpxTrack track : this.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    Iterator i$ = seg.getWayPoints().iterator();
                    if (i$.hasNext()) {
                        WayPoint w = (WayPoint)i$.next();
                        WayPoint wStart = new WayPoint(w.getCoor());
                        wStart.attr.put("name", "start");
                        wStart.time = w.time;
                        waypoints.add(wStart);
                        gotOne = true;
                    }
                    if (!gotOne) continue;
                    break;
                }
                if (!gotOne) continue;
                break;
            }
        }
        Collections.sort(waypoints, new Comparator<WayPoint>(){

            @Override
            public int compare(WayPoint a, WayPoint b) {
                return a.time <= b.time ? -1 : 1;
            }
        });
        firstTime = -1.0;
        for (WayPoint w : waypoints) {
            if (firstTime < 0.0) {
                firstTime = w.time;
            }
            double offset = w.time - firstTime;
            AudioMarker am = new AudioMarker(w.getCoor(), (TemplateEngineDataProvider)w, url, ml, w.time, offset);
            if (w == wayPointFromTimeStamp) {
                am.timeFromAudio = true;
            }
            ml.data.add(am);
        }
        if (timedMarkersOmitted && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start."));
            markers.timedMarkersOmitted = timedMarkersOmitted;
        }
        if (untimedMarkersOmitted && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Some waypoints which were too far from the track to sensibly estimate their time were omitted."));
            markers.untimedMarkersOmitted = untimedMarkersOmitted;
        }
    }

    public WayPoint nearestPointOnTrack(EastNorth P, double tolerance) {
        double PNminsq = tolerance * tolerance;
        EastNorth bestEN = null;
        double bestTime = 0.0;
        double px = P.east();
        double py = P.north();
        double rx = 0.0;
        double ry = 0.0;
        if (this.data.tracks == null) {
            return null;
        }
        for (GpxTrack track : this.data.tracks) {
            for (GpxTrackSegment seg : track.getSegments()) {
                EastNorth c;
                double PRsq;
                double y;
                double x;
                WayPoint R = null;
                for (WayPoint S : seg.getWayPoints()) {
                    EastNorth c2 = S.getEastNorth();
                    if (R == null) {
                        R = S;
                        rx = c2.east();
                        x = px - rx;
                        double PRsq2 = x * x + (y = py - (ry = c2.north())) * y;
                        if (!(PRsq2 < PNminsq)) continue;
                        PNminsq = PRsq2;
                        bestEN = c2;
                        bestTime = R.time;
                        continue;
                    }
                    double sx = c2.east();
                    double sy = c2.north();
                    double A = sy - ry;
                    double B = rx - sx;
                    double C = -A * rx - B * ry;
                    double RSsq = A * A + B * B;
                    if (RSsq == 0.0) continue;
                    double PNsq = A * px + B * py + C;
                    if ((PNsq = PNsq * PNsq / RSsq) < PNminsq) {
                        x = px - rx;
                        y = py - ry;
                        double PRsq3 = x * x + y * y;
                        x = px - sx;
                        y = py - sy;
                        double PSsq = x * x + y * y;
                        if (PRsq3 - PNsq <= RSsq && PSsq - PNsq <= RSsq) {
                            double RNoverRS = Math.sqrt((PRsq3 - PNsq) / RSsq);
                            double nx = rx - RNoverRS * B;
                            double ny = ry + RNoverRS * A;
                            bestEN = new EastNorth(nx, ny);
                            bestTime = R.time + RNoverRS * (S.time - R.time);
                            PNminsq = PNsq;
                        }
                    }
                    R = S;
                    rx = sx;
                    ry = sy;
                }
                if (R == null || !((PRsq = (x = px - (rx = (c = R.getEastNorth()).east())) * x + (y = py - (ry = c.north())) * y) < PNminsq)) continue;
                PNminsq = PRsq;
                bestEN = c;
                bestTime = R.time;
            }
        }
        if (bestEN == null) {
            return null;
        }
        WayPoint best = new WayPoint(Main.getProjection().eastNorth2latlon(bestEN));
        best.time = bestTime;
        return best;
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            EGpxLayer.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        ll0 = 9;
        sl4 = 5;
        sl9 = 3;
        dir = new int[][]{{sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}, {-sl4, -ll0, -ll0, -sl4}, {sl9, -ll0, -sl9, -ll0}, {ll0, -sl4, sl4, -ll0}, {ll0, sl9, ll0, -sl9}, {sl4, ll0, ll0, sl4}, {-sl9, ll0, sl9, ll0}, {-ll0, sl4, -sl4, ll0}, {-ll0, -sl9, -ll0, sl9}};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportImages
    extends AbstractAction {
        public ImportImages() {
            super(I18n.tr((String)"Import images"), ImageProvider.get((String)"dialogs/geoimage"));
            this.putValue("help", HelpUtil.ht((String)"/Action/ImportImages"));
        }

        private void warnCantImportIntoServerLayer(EGpxLayer layer) {
            String msg = I18n.tr((String)"<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with images.</html>", (Object[])new Object[]{layer.getName()});
            HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)msg, (String)I18n.tr((String)"Import not possible"), (int)2, (String)HelpUtil.ht((String)"/Action/ImportImages#CantImportIntoGpxLayerFromServer"));
        }

        private void addRecursiveFiles(LinkedList<File> files, File[] sel) {
            for (File f : sel) {
                if (f.isDirectory()) {
                    this.addRecursiveFiles(files, f.listFiles());
                    continue;
                }
                if (!f.getName().toLowerCase().endsWith(".jpg")) continue;
                files.add(f);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EGpxLayer.this.data.fromServer) {
                this.warnCantImportIntoServerLayer(EGpxLayer.this);
                return;
            }
            String curDir = Main.pref.get("geoimage.lastdirectory", Main.pref.get("lastDirectory"));
            if (curDir.equals("")) {
                curDir = ".";
            }
            JFileChooser fc = new JFileChooser(new File(curDir));
            fc.setFileSelectionMode(2);
            fc.setMultiSelectionEnabled(true);
            fc.setAcceptAllFileFilterUsed(false);
            JpgImporter importer = new JpgImporter();
            fc.setFileFilter((FileFilter)importer.filter);
            fc.showOpenDialog(Main.parent);
            LinkedList<File> files = new LinkedList<File>();
            File[] sel = fc.getSelectedFiles();
            if (sel == null || sel.length == 0) {
                return;
            }
            if (!fc.getCurrentDirectory().getAbsolutePath().equals(curDir)) {
                Main.pref.put("geoimage.lastdirectory", fc.getCurrentDirectory().getAbsolutePath());
            }
            this.addRecursiveFiles(files, sel);
            importer.importDataHandleExceptions(files, NullProgressMonitor.INSTANCE);
        }
    }

    private class ImportAudio
    extends AbstractAction {
        public ImportAudio() {
            super(I18n.tr((String)"Import Audio"), ImageProvider.get((String)"importaudio"));
            this.putValue("help", "ImportAudio");
        }

        private void warnCantImportIntoServerLayer(EGpxLayer layer) {
            String msg = I18n.tr((String)"<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with audio data.</html>", (Object[])new Object[]{layer.getName()});
            HelpAwareOptionPane.showOptionDialog((Component)Main.parent, (Object)msg, (String)I18n.tr((String)"Import not possible"), (int)2, (String)HelpUtil.ht((String)"/Action/ImportImages#CantImportIntoGpxLayerFromServer"));
        }

        public void actionPerformed(ActionEvent e) {
            if (EGpxLayer.this.data.fromServer) {
                this.warnCantImportIntoServerLayer(EGpxLayer.this);
                return;
            }
            String dir = Main.pref.get("markers.lastaudiodirectory");
            JFileChooser fc = new JFileChooser(dir);
            fc.setFileSelectionMode(0);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".wav");
                }

                public String getDescription() {
                    return I18n.tr((String)"Wave Audio files (*.wav)");
                }
            });
            fc.setMultiSelectionEnabled(true);
            if (fc.showOpenDialog(Main.parent) == 0) {
                File[] sel;
                if (!fc.getCurrentDirectory().getAbsolutePath().equals(dir)) {
                    Main.pref.put("markers.lastaudiodirectory", fc.getCurrentDirectory().getAbsolutePath());
                }
                if ((sel = fc.getSelectedFiles()).length > 1) {
                    Arrays.sort(sel, new Comparator<File>(){

                        @Override
                        public int compare(File a, File b) {
                            return a.lastModified() <= b.lastModified() ? -1 : 1;
                        }
                    });
                }
                String names = null;
                for (int i = 0; i < sel.length; ++i) {
                    names = names == null ? " (" : names + ", ";
                    names = names + sel[i].getName();
                }
                names = names != null ? names + ")" : "";
                MarkerLayer ml = new MarkerLayer(new GpxData(), I18n.tr((String)"Audio markers from {0}", (Object[])new Object[]{EGpxLayer.this.getName()}) + names, EGpxLayer.this.getAssociatedFile(), null);
                double firstStartTime = (double)sel[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration((File)sel[0]);
                Markers m = new Markers();
                for (int i = 0; i < sel.length; ++i) {
                    EGpxLayer.this.importAudio(sel[i], ml, firstStartTime, m);
                }
                Main.main.addLayer((Layer)ml);
                Main.map.repaint();
            }
        }
    }

    private class MarkersFromNamedPoins
    extends AbstractAction {
        public MarkersFromNamedPoins() {
            super(I18n.tr((String)"Markers From Named Points"), ImageProvider.get((String)"addmarkers"));
            this.putValue("help", "Action/MarkersFromNamedPoints");
        }

        public void actionPerformed(ActionEvent e) {
            GpxData namedTrackPoints = new GpxData();
            for (GpxTrack track : EGpxLayer.this.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint point : seg.getWayPoints()) {
                        if (!point.attr.containsKey("name") && !point.attr.containsKey("desc")) continue;
                        namedTrackPoints.waypoints.add(point);
                    }
                }
            }
            MarkerLayer ml = new MarkerLayer(namedTrackPoints, I18n.tr((String)"Named Trackpoints from {0}", (Object[])new Object[]{EGpxLayer.this.getName()}), EGpxLayer.this.getAssociatedFile(), null);
            if (ml.data.size() > 0) {
                Main.main.addLayer((Layer)ml);
            }
        }
    }

    private class CustomizeColor
    extends AbstractAction {
        public CustomizeColor() {
            super(I18n.tr((String)"Customize Color"), ImageProvider.get((String)"colorchooser"));
            this.putValue("help", "Action/LayerCustomizeColor");
        }

        public void actionPerformed(ActionEvent e) {
            JColorChooser c = new JColorChooser(EGpxLayer.getColor(EGpxLayer.this.getName()));
            Object[] options = new Object[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel"), I18n.tr((String)"Default")};
            int answer = JOptionPane.showOptionDialog(Main.parent, c, I18n.tr((String)"Choose a color"), 2, -1, null, options, options[0]);
            switch (answer) {
                case 0: {
                    Main.pref.putColor("layer " + EGpxLayer.this.getName(), c.getColor());
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    Main.pref.putColor("layer " + EGpxLayer.this.getName(), null);
                }
            }
            Main.map.repaint();
        }
    }

    private class CustomizeLineDrawing
    extends AbstractAction {
        CustomizeLineDrawing() {
            super(I18n.tr((String)"Customize line drawing"), ImageProvider.get((String)"mapmode/addsegment"));
        }

        public void actionPerformed(ActionEvent e) {
            JRadioButton[] r = new JRadioButton[]{new JRadioButton(I18n.tr((String)"Use global settings.")), new JRadioButton(I18n.tr((String)"Draw lines between points for this layer.")), new JRadioButton(I18n.tr((String)"Do not draw lines between points for this layer."))};
            ButtonGroup group = new ButtonGroup();
            Box panel = Box.createVerticalBox();
            for (JRadioButton b : r) {
                group.add(b);
                panel.add(b);
            }
            String propName = "draw.rawgps.lines.layer " + EGpxLayer.this.getName();
            if (Main.pref.hasKey(propName)) {
                group.setSelected(r[Main.pref.getBoolean(propName) ? 1 : 2].getModel(), true);
            } else {
                group.setSelected(r[0].getModel(), true);
            }
            int answer = JOptionPane.showConfirmDialog(Main.parent, panel, I18n.tr((String)"Select line drawing options"), 2, 3);
            switch (answer) {
                case -1: 
                case 2: {
                    return;
                }
            }
            if (group.getSelection() == r[0].getModel()) {
                Main.pref.put(propName, null);
            } else {
                Main.pref.put(propName, group.getSelection() == r[1].getModel());
            }
            Main.map.repaint();
        }
    }

    public class DownloadAlongTrackAction
    extends AbstractAction {
        public DownloadAlongTrackAction() {
            super(I18n.tr((String)"Download from OSM along this track"), ImageProvider.get((String)"downloadalongtrack"));
        }

        public void actionPerformed(ActionEvent e) {
            JPanel msg = new JPanel(new GridBagLayout());
            Integer[] dist = new Integer[]{5000, 500, 50};
            Integer[] area = new Integer[]{20, 10, 5, 1};
            msg.add((Component)new JLabel(I18n.tr((String)"Download everything within:")), GBC.eol());
            String[] s = new String[dist.length];
            for (int i = 0; i < dist.length; ++i) {
                s[i] = I18n.tr((String)"{0} meters", (Object[])new Object[]{dist[i]});
            }
            JList<String> buffer = new JList<String>(s);
            buffer.setSelectedIndex(Main.pref.getInteger(EGpxLayer.PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, 0));
            msg.add(buffer, GBC.eol());
            msg.add((Component)new JLabel(I18n.tr((String)"Maximum area per request:")), GBC.eol());
            s = new String[area.length];
            for (int i = 0; i < area.length; ++i) {
                s[i] = I18n.tr((String)"{0} sq km", (Object[])new Object[]{area[i]});
            }
            JList<String> maxRect = new JList<String>(s);
            maxRect.setSelectedIndex(Main.pref.getInteger(EGpxLayer.PREF_DOWNLOAD_ALONG_TRACK_AREA, 0));
            msg.add(maxRect, GBC.eol());
            msg.add((Component)new JLabel(I18n.tr((String)"Download near:")), GBC.eol());
            JList<String> downloadNear = new JList<String>(new String[]{I18n.tr((String)"track only"), I18n.tr((String)"waypoints only"), I18n.tr((String)"track and waypoints")});
            int NEAR_TRACK = 0;
            int NEAR_WAYPOINTS = 1;
            int NEAR_BOTH = 2;
            downloadNear.setSelectedIndex(Main.pref.getInteger(EGpxLayer.PREF_DOWNLOAD_ALONG_TRACK_NEAR, 0));
            msg.add(downloadNear, GBC.eol());
            int ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr((String)"Download from OSM along this track"), 2, 3);
            switch (ret) {
                case -1: 
                case 2: {
                    return;
                }
            }
            Main.pref.putInteger(EGpxLayer.PREF_DOWNLOAD_ALONG_TRACK_DISTANCE, Integer.valueOf(buffer.getSelectedIndex()));
            Main.pref.putInteger(EGpxLayer.PREF_DOWNLOAD_ALONG_TRACK_AREA, Integer.valueOf(maxRect.getSelectedIndex()));
            int near = downloadNear.getSelectedIndex();
            Main.pref.putInteger(EGpxLayer.PREF_DOWNLOAD_ALONG_TRACK_NEAR, Integer.valueOf(near));
            double latsum = 0.0;
            int latcnt = 0;
            if (near == NEAR_TRACK || near == NEAR_BOTH) {
                for (GpxTrack trk : EGpxLayer.this.data.tracks) {
                    for (GpxTrackSegment segment : trk.getSegments()) {
                        for (WayPoint p : segment.getWayPoints()) {
                            latsum += p.getCoor().lat();
                            ++latcnt;
                        }
                    }
                }
            }
            if (near == NEAR_WAYPOINTS || near == NEAR_BOTH) {
                for (WayPoint p : EGpxLayer.this.data.waypoints) {
                    latsum += p.getCoor().lat();
                    ++latcnt;
                }
            }
            double avglat = latsum / (double)latcnt;
            double scale = Math.cos(Math.toRadians(avglat));
            Integer i = buffer.getSelectedIndex();
            int buffer_dist = dist[i < 0 ? 0 : i];
            double buffer_y = (double)buffer_dist / 100000.0;
            double buffer_x = buffer_y / scale;
            i = maxRect.getSelectedIndex();
            double max_area = (double)area[i < 0 ? 0 : i].intValue() / 10000.0 / scale;
            Area a = new Area();
            Rectangle2D.Double r = new Rectangle2D.Double();
            LatLon previous = null;
            if (near == NEAR_TRACK || near == NEAR_BOTH) {
                for (GpxTrack trk : EGpxLayer.this.data.tracks) {
                    for (GpxTrackSegment segment : trk.getSegments()) {
                        for (WayPoint p : segment.getWayPoints()) {
                            LatLon c = p.getCoor();
                            if (previous != null && !(c.greatCircleDistance(previous) > (double)buffer_dist)) continue;
                            ((Rectangle2D)r).setRect(c.lon() - buffer_x, c.lat() - buffer_y, 2.0 * buffer_x, 2.0 * buffer_y);
                            a.add(new Area(r));
                            previous = c;
                        }
                    }
                }
            }
            if (near == NEAR_WAYPOINTS || near == NEAR_BOTH) {
                for (WayPoint p : EGpxLayer.this.data.waypoints) {
                    LatLon c = p.getCoor();
                    if (previous != null && !(c.greatCircleDistance(previous) > (double)buffer_dist)) continue;
                    ((Rectangle2D)r).setRect(c.lon() - buffer_x, c.lat() - buffer_y, 2.0 * buffer_x, 2.0 * buffer_y);
                    a.add(new Area(r));
                    previous = c;
                }
            }
            ArrayList toDownload = new ArrayList();
            EGpxLayer.addToDownload(a, a.getBounds(), toDownload, max_area);
            msg = new JPanel(new GridBagLayout());
            msg.add((Component)new JLabel(I18n.tr((String)"<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", (Object[])new Object[]{toDownload.size()})), GBC.eol());
            if (toDownload.size() > 1) {
                ret = JOptionPane.showConfirmDialog(Main.parent, msg, I18n.tr((String)"Download from OSM along this track"), 2, -1);
                switch (ret) {
                    case -1: 
                    case 2: {
                        return;
                    }
                }
            }
            final PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr((String)"Download data"));
            final Future future = new DownloadOsmTaskList().download(false, toDownload, (ProgressMonitor)monitor);
            Main.worker.submit(new Runnable(){

                public void run() {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    monitor.close();
                }
            });
        }
    }

    public class ConvertToDataLayerAction
    extends AbstractAction {
        public ConvertToDataLayerAction() {
            super(I18n.tr((String)"Convert to data layer"), ImageProvider.get((String)"converttoosm"));
        }

        public void actionPerformed(ActionEvent e) {
            JPanel msg = new JPanel(new GridBagLayout());
            msg.add((Component)new JLabel(I18n.tr((String)"<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:")), GBC.eol());
            msg.add((Component)new UrlLabel(I18n.tr((String)"http://www.openstreetmap.org/traces")), GBC.eop());
            if (!ConditionalOptionPaneUtil.showConfirmationDialog((String)"convert_to_data", (Component)Main.parent, (Object)msg, (String)I18n.tr((String)"Warning"), (int)2, (int)2, (int)0)) {
                return;
            }
            DataSet ds = new DataSet();
            for (GpxTrack trk : EGpxLayer.this.data.tracks) {
                for (GpxTrackSegment segment : trk.getSegments()) {
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (WayPoint p : segment.getWayPoints()) {
                        Node n = new Node(p.getCoor());
                        String timestr = p.getString("time");
                        if (timestr != null) {
                            n.setTimestamp(DateUtils.fromString((String)timestr));
                        }
                        ds.addPrimitive((OsmPrimitive)n);
                        nodes.add(n);
                    }
                    Way w = new Way();
                    w.setNodes(nodes);
                    ds.addPrimitive((OsmPrimitive)w);
                }
            }
            Main.main.addLayer((Layer)new OsmDataLayer(ds, I18n.tr((String)"Converted from: {0}", (Object[])new Object[]{EGpxLayer.this.getName()}), EGpxLayer.this.getAssociatedFile()));
            Main.main.removeLayer((Layer)EGpxLayer.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum colorModes {
        none,
        velocity,
        dilution;

    }

    private static class Markers {
        public boolean timedMarkersOmitted = false;
        public boolean untimedMarkersOmitted = false;

        private Markers() {
        }
    }
}

