/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.osb.OsbObserver;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.OsbBugListCellRenderer;
import org.openstreetmap.josm.plugins.osb.gui.OsbListItem;
import org.openstreetmap.josm.plugins.osb.gui.OsbQueueListCellRenderer;
import org.openstreetmap.josm.plugins.osb.gui.action.ActionQueue;
import org.openstreetmap.josm.plugins.osb.gui.action.AddCommentAction;
import org.openstreetmap.josm.plugins.osb.gui.action.CloseIssueAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbActionObserver;
import org.openstreetmap.josm.plugins.osb.gui.action.PointToNewIssueAction;
import org.openstreetmap.josm.plugins.osb.gui.action.PopupFactory;
import org.openstreetmap.josm.plugins.osb.gui.action.ToggleConnectionModeAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsbDialog
extends ToggleDialog
implements OsbObserver,
ListSelectionListener,
MapView.LayerChangeListener,
DataSetListener,
SelectionChangedListener,
MouseListener,
OsbActionObserver {
    private static final long serialVersionUID = 1L;
    private JPanel bugListPanel;
    private JPanel queuePanel;
    private DefaultListModel bugListModel;
    private JList bugList;
    private JList queueList;
    private OsbPlugin osbPlugin;
    private boolean fireSelectionChanged = true;
    private JButton refresh;
    private JButton addComment;
    private JButton closeIssue;
    private JButton processQueue = new JButton(I18n.tr((String)"Process queue"));
    private JToggleButton newIssue = new JToggleButton();
    private JToggleButton toggleConnectionMode;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private boolean queuePanelVisible = false;
    private final ActionQueue actionQueue = new ActionQueue();
    private boolean buttonLabels = Main.pref.getBoolean("osb.button_labels");
    private boolean downloaded = false;

    public OsbDialog(final OsbPlugin plugin) {
        super(I18n.tr((String)"Open OpenStreetBugs"), "icon_error24", I18n.tr((String)"Opens the OpenStreetBugs window and activates the automatic download"), Shortcut.registerShortcut((String)"view:openstreetbugs", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Open OpenStreetBugs")}), (int)66, (int)4, (int)1), 150);
        this.osbPlugin = plugin;
        this.bugListPanel = new JPanel(new BorderLayout());
        this.bugListPanel.setName(I18n.tr((String)"Bug list"));
        this.add(this.bugListPanel, "Center");
        this.bugListModel = new DefaultListModel();
        this.bugList = new JList(this.bugListModel);
        this.bugList.setSelectionMode(0);
        this.bugList.addListSelectionListener(this);
        this.bugList.addMouseListener(this);
        this.bugList.setCellRenderer(new OsbBugListCellRenderer());
        this.bugListPanel.add((Component)new JScrollPane(this.bugList), "Center");
        GridLayout layout = this.buttonLabels ? new GridLayout(3, 2) : new GridLayout(1, 5);
        JPanel buttonPanel = new JPanel(layout);
        this.refresh = new JButton(I18n.tr((String)"Refresh"));
        this.refresh.setToolTipText(I18n.tr((String)"Refresh"));
        this.refresh.setIcon(OsbPlugin.loadIcon("view-refresh22.png"));
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int zoom = OsmUrlToBounds.getZoom((Bounds)Main.map.mapView.getRealBounds());
                if (zoom > 15 || zoom < 9) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The visible area is either too small or too big to download data from OpenStreetBugs"), I18n.tr((String)"Warning"), 1);
                    return;
                }
                plugin.updateData();
            }
        });
        this.bugListPanel.add((Component)buttonPanel, "South");
        ToggleConnectionModeAction toggleConnectionModeAction = new ToggleConnectionModeAction(this, this.osbPlugin);
        this.toggleConnectionMode = new JToggleButton(toggleConnectionModeAction);
        this.toggleConnectionMode.setToolTipText(ToggleConnectionModeAction.MSG_OFFLINE);
        boolean offline = Main.pref.getBoolean("osb.api.offline");
        this.toggleConnectionMode.setIcon(OsbPlugin.loadIcon("online22.png"));
        this.toggleConnectionMode.setSelectedIcon(OsbPlugin.loadIcon("offline22.png"));
        if (offline) {
            Main.pref.put("osb.api.offline", false);
            this.toggleConnectionMode.doClick();
        }
        AddCommentAction addCommentAction = new AddCommentAction(this);
        this.addComment = new JButton(addCommentAction);
        this.addComment.setEnabled(false);
        this.addComment.setToolTipText((String)this.addComment.getAction().getValue("Name"));
        this.addComment.setIcon(OsbPlugin.loadIcon("add_comment22.png"));
        CloseIssueAction closeIssueAction = new CloseIssueAction(this);
        this.closeIssue = new JButton(closeIssueAction);
        this.closeIssue.setEnabled(false);
        this.closeIssue.setToolTipText((String)this.closeIssue.getAction().getValue("Name"));
        this.closeIssue.setIcon(OsbPlugin.loadIcon("icon_valid22.png"));
        PointToNewIssueAction nia = new PointToNewIssueAction(this.newIssue, this.osbPlugin);
        this.newIssue.setAction(nia);
        this.newIssue.setToolTipText((String)this.newIssue.getAction().getValue("Name"));
        this.newIssue.setIcon(OsbPlugin.loadIcon("icon_error_add22.png"));
        buttonPanel.add(this.toggleConnectionMode);
        buttonPanel.add(this.refresh);
        buttonPanel.add(this.newIssue);
        buttonPanel.add(this.addComment);
        buttonPanel.add(this.closeIssue);
        this.queuePanel = new JPanel(new BorderLayout());
        this.queuePanel.setName(I18n.tr((String)"Queue"));
        this.queueList = new JList(this.getActionQueue());
        this.queueList.setCellRenderer(new OsbQueueListCellRenderer());
        this.queuePanel.add((Component)new JScrollPane(this.queueList), "Center");
        this.queuePanel.add((Component)this.processQueue, "South");
        this.processQueue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.pref.put("osb.api.offline", "false");
                OsbDialog.this.setConnectionMode(false);
                try {
                    OsbDialog.this.getActionQueue().processQueue();
                    if (!Main.pref.getBoolean("osb.api.disabled")) {
                        plugin.updateData();
                    }
                }
                catch (Exception e1) {
                    System.err.println("Couldn't process action queue");
                    e1.printStackTrace();
                }
            }
        });
        this.tabbedPane.add(this.queuePanel);
        if (this.buttonLabels) {
            this.toggleConnectionMode.setHorizontalAlignment(2);
            this.refresh.setHorizontalAlignment(2);
            this.addComment.setHorizontalAlignment(2);
            this.closeIssue.setHorizontalAlignment(2);
            this.newIssue.setHorizontalAlignment(2);
        } else {
            this.toggleConnectionMode.setText(null);
            this.refresh.setText(null);
            this.addComment.setText(null);
            this.closeIssue.setText(null);
            this.newIssue.setText(null);
        }
        addCommentAction.addActionObserver(this);
        closeIssueAction.addActionObserver(this);
        this.setConnectionMode(offline);
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public void showNotify() {
        DataSet.addSelectionListener((SelectionChangedListener)this);
    }

    public void hideNotify() {
        DataSet.removeSelectionListener((SelectionChangedListener)this);
    }

    public void destroy() {
        super.destroy();
        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
    }

    @Override
    public synchronized void update(DataSet dataset) {
        this.bugListModel = new DefaultListModel();
        ArrayList sortedList = new ArrayList(dataset.getNodes());
        Collections.sort(sortedList, new BugComparator());
        for (Node node : sortedList) {
            if (!node.isUsable()) continue;
            this.bugListModel.addElement(new OsbListItem(node));
        }
        this.bugList.setModel(this.bugListModel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.bugList.getSelectedValues().length == 0) {
            this.addComment.setEnabled(false);
            this.closeIssue.setEnabled(false);
            return;
        }
        ArrayList<Node> selected = new ArrayList<Node>();
        for (Object listItem : this.bugList.getSelectedValues()) {
            Node node = ((OsbListItem)listItem).getNode();
            selected.add(node);
            if ("1".equals(node.get("state"))) {
                this.addComment.setEnabled(false);
                this.closeIssue.setEnabled(false);
            } else {
                this.addComment.setEnabled(true);
                this.closeIssue.setEnabled(true);
            }
            this.scrollToSelected(node);
        }
        DataSet ds = this.osbPlugin.getLayer().getDataSet();
        if (this.fireSelectionChanged) {
            if (ds == null) {
                ds = new DataSet();
            }
            ds.setSelected(selected);
        }
    }

    private void scrollToSelected(Node node) {
        for (int i = 0; i < this.bugListModel.getSize(); ++i) {
            Node current = ((OsbListItem)this.bugListModel.get(i)).getNode();
            if (current.getId() != node.getId()) continue;
            this.bugList.scrollRectToVisible(this.bugList.getCellBounds(i, i));
            this.bugList.setSelectedIndex(i);
            return;
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer == this.osbPlugin.getLayer()) {
            this.update(this.osbPlugin.getDataSet());
            Main.map.mapView.moveLayer(newLayer, 0);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this.osbPlugin.getLayer()) {
            this.bugListModel.removeAllElements();
        }
    }

    public void zoomToNode(Node node) {
        Main.map.mapView.zoomTo(node.getEastNorth());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Node selectedNode;
        if (e.getButton() == 1 && e.getClickCount() == 2 && (selectedNode = this.getSelectedNode()) != null) {
            this.zoomToNode(selectedNode);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    private void mayTriggerPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int selectedRow = this.bugList.locationToIndex(e.getPoint());
            this.bugList.setSelectedIndex(selectedRow);
            Node selectedNode = this.getSelectedNode();
            if (selectedNode != null) {
                PopupFactory.createPopup(selectedNode, this).show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(OsbAction action) {
        if (action instanceof AddCommentAction || action instanceof CloseIssueAction) {
            this.update(this.osbPlugin.getDataSet());
        }
    }

    protected void initialDownload() {
        Main.worker.execute(new Runnable(){

            public void run() {
                OsbDialog.this.osbPlugin.updateData();
            }
        });
    }

    public void showDialog() {
        if (!this.downloaded) {
            this.initialDownload();
            this.downloaded = true;
        }
        super.showDialog();
    }

    public void showQueuePanel() {
        if (!this.queuePanelVisible) {
            this.remove(this.bugListPanel);
            this.tabbedPane.add((Component)this.bugListPanel, 0);
            this.add(this.tabbedPane, "Center");
            this.tabbedPane.setSelectedIndex(0);
            this.queuePanelVisible = true;
            this.invalidate();
            this.repaint();
        }
    }

    public void hideQueuePanel() {
        if (this.queuePanelVisible) {
            this.tabbedPane.remove(this.bugListPanel);
            this.remove(this.tabbedPane);
            this.add(this.bugListPanel, "Center");
            this.queuePanelVisible = false;
            this.invalidate();
            this.repaint();
        }
    }

    public Node getSelectedNode() {
        if (this.bugList.getSelectedValue() != null) {
            return ((OsbListItem)this.bugList.getSelectedValue()).getNode();
        }
        return null;
    }

    public void setSelectedNode(Node node) {
        if (node == null) {
            this.bugList.clearSelection();
        } else {
            this.bugList.setSelectedValue(new OsbListItem(node), true);
        }
    }

    public void setConnectionMode(boolean offline) {
        this.refresh.setEnabled(!offline);
        this.setTitle(I18n.tr((String)"OpenStreetBugs ({0})", (Object[])new Object[]{offline ? I18n.tr((String)"offline") : I18n.tr((String)"online")}));
        this.toggleConnectionMode.setSelected(offline);
    }

    public void dataChanged(DataChangedEvent event) {
        this.update(event.getDataset());
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (newSelection.size() == 1 && newSelection.iterator().next() instanceof Node) {
            Node selectedNode = (Node)newSelection.iterator().next();
            if (this.osbPlugin.getLayer() != null && this.osbPlugin.getLayer().getDataSet() != null && this.osbPlugin.getLayer().getDataSet().getNodes() != null && this.osbPlugin.getLayer().getDataSet().getNodes().contains(selectedNode)) {
                this.setSelectedNode(selectedNode);
            } else {
                this.bugList.clearSelection();
            }
        } else {
            this.bugList.clearSelection();
        }
    }

    public ActionQueue getActionQueue() {
        return this.actionQueue;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.bugList.setEnabled(enabled);
        this.queueList.setEnabled(enabled);
        this.addComment.setEnabled(enabled);
        this.closeIssue.setEnabled(enabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugComparator
    implements Comparator<Node> {
        private BugComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            String state2;
            String state1 = o1.get("state");
            if (state1.equals(state2 = o2.get("state"))) {
                return o1.get("note").compareTo(o2.get("note"));
            }
            return state1.compareTo(state2);
        }
    }
}

