/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.dumbutils;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitOnIntersectionsAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Split adjacent ways");

    public SplitOnIntersectionsAction() {
        super(TITLE, "dumbutils/splitonintersections", I18n.tr((String)"Split adjacent ways on T-intersections"), Shortcut.registerShortcut((String)"tools:splitonintersections", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{TITLE}), (int)80, (int)3, (int)640), true);
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<Command> list = new ArrayList<Command>();
        List selectedWays = OsmPrimitive.getFilteredList((Collection)SplitOnIntersectionsAction.getCurrentDataSet().getSelected(), Way.class);
        HashMap splitWays = new HashMap();
        for (Way way : selectedWays) {
            if (way.getNodesCount() <= 1 || way.hasIncompleteNodes() || way.isClosed()) continue;
            for (Node node : new Node[]{way.getNode(0), way.getNode(way.getNodesCount() - 1)}) {
                Iterator it;
                List refs = OsmPrimitive.getFilteredList((Collection)node.getReferrers(), Way.class);
                refs.remove(way);
                if (selectedWays.size() > 1) {
                    it = refs.iterator();
                    while (it.hasNext()) {
                        if (selectedWays.contains(it.next())) continue;
                        it.remove();
                    }
                }
                it = refs.iterator();
                while (it.hasNext()) {
                    Way w = (Way)it.next();
                    if (!w.isDeleted() && !w.isIncomplete() && w.isInnerNode(node)) continue;
                    it.remove();
                }
                if (refs.size() == 1) {
                    if (splitWays.containsKey(refs.get(0))) {
                        ((List)splitWays.get(refs.get(0))).add(node);
                        continue;
                    }
                    ArrayList<Node> nodes = new ArrayList<Node>(1);
                    nodes.add(node);
                    splitWays.put(refs.get(0), nodes);
                    continue;
                }
                if (refs.size() <= 1) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"There are several ways containing one of the splitting nodes. Select ways participating in this operation."), I18n.tr((String)"Warning"), 2);
                return;
            }
        }
        for (Way splitWay : splitWays.keySet()) {
            List wayChunks = SplitWayAction.buildSplitChunks((Way)splitWay, (List)((List)splitWays.get(splitWay)));
            if (wayChunks == null) continue;
            ArrayList sel = new ArrayList(selectedWays.size());
            sel.addAll(selectedWays);
            SplitWayAction.SplitWayResult result = SplitWayAction.splitWay((OsmDataLayer)SplitOnIntersectionsAction.getEditLayer(), (Way)splitWay, (List)wayChunks, sel);
            list.add(result.getCommand());
        }
        if (!list.isEmpty()) {
            Main.main.undoRedo.add((Command)(list.size() == 1 ? (Command)list.get(0) : new SequenceCommand(TITLE, list)));
            SplitOnIntersectionsAction.getCurrentDataSet().clearSelection();
        }
    }

    private void filterInnerNodes(Node n, List<Way> ways) {
        Iterator<Way> it = ways.iterator();
        while (it.hasNext()) {
            Way w = it.next();
            if (w.isInnerNode(n)) continue;
            it.remove();
        }
    }

    protected void updateEnabledState() {
        if (SplitOnIntersectionsAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SplitOnIntersectionsAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean ok = false;
        if (selection != null) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive instanceof Way) {
                    ok = true;
                    continue;
                }
                ok = false;
                break;
            }
        }
        this.setEnabled(ok);
    }
}

