/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.videomapping.video;

import com.sun.jna.NativeLibrary;
import java.awt.Dimension;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.videomapping.video.Video;
import org.openstreetmap.josm.plugins.videomapping.video.VideoObserversEvents;
import org.openstreetmap.josm.plugins.videomapping.video.VideosObserver;
import org.openstreetmap.josm.tools.I18n;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.VideoMetaData;
import uk.co.caprica.vlcj.player.embedded.DefaultFullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.runtime.windows.WindowsRuntimeUtil;

public class VideoEngine
implements MediaPlayerEventListener {
    private FullScreenStrategy fullScreenStrategy;
    private MediaPlayerFactory mediaPlayerFactory;
    private List<Video> videos;
    private List<VideosObserver> observers;
    private final String[] libvlcArgs = new String[]{""};
    private final String[] standardMediaOptions = new String[]{""};
    private static final String[] deinterlacers = new String[]{"bob", "linear"};
    private final float initialCanvasFactor = 0.5f;
    private boolean singleVideoMode;
    private Video lastAddedVideo;

    public static void setupPlayer() {
        NativeLibrary.addSearchPath("libvlc", WindowsRuntimeUtil.getVlcInstallDir());
    }

    public VideoEngine(Window parent) {
        System.setProperty("logj4.configuration", "file:log4j.xml");
        this.videos = new LinkedList<Video>();
        this.observers = new LinkedList<VideosObserver>();
        try {
            this.mediaPlayerFactory = new MediaPlayerFactory(this.libvlcArgs);
            this.fullScreenStrategy = new DefaultFullScreenStrategy(parent);
        }
        catch (NoClassDefFoundError e) {
            System.err.println(I18n.tr((String)"Unable to find JNA Java library!"));
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(I18n.tr((String)"Unable to find native libvlc library!"));
        }
    }

    public void add(Video video) {
        try {
            EmbeddedMediaPlayer mp = this.mediaPlayerFactory.newMediaPlayer(this.fullScreenStrategy);
            video.player = mp;
            mp.setStandardMediaOptions(this.standardMediaOptions);
            this.videos.add(video);
            this.lastAddedVideo = video;
            mp.setVideoSurface(video.canvas);
            mp.addMediaPlayerEventListener(this);
            String mediaPath = video.filename.getAbsoluteFile().toString();
            mp.playMedia(mediaPath);
        }
        catch (NoClassDefFoundError e) {
            System.err.println(I18n.tr((String)"Unable to find JNA Java library!"));
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(I18n.tr((String)"Unable to find native libvlc library!"));
        }
    }

    private Video getVideo(MediaPlayer mp) {
        for (Video video : this.videos) {
            if (video.player != mp) continue;
            return video;
        }
        return null;
    }

    public List<Video> getVideos() {
        return this.videos;
    }

    public void play() {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.play();
        } else {
            for (Video video : this.videos) {
                video.player.play();
            }
        }
        System.out.println("abspielen");
    }

    public void pause() {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.pause();
        } else {
            for (Video video : this.videos) {
                video.player.pause();
            }
        }
    }

    public void pauseAll() {
        for (Video video : this.videos) {
            if (!video.player.isPlaying()) continue;
            video.player.pause();
        }
    }

    public void jumpFor(long ms) {
        if (this.singleVideoMode) {
            long start = this.lastAddedVideo.player.getTime();
            this.lastAddedVideo.player.setTime(start + ms);
        } else {
            for (Video video : this.videos) {
                long start = video.player.getTime();
                video.player.setTime(start + ms);
            }
        }
        this.notifyObservers(VideoObserversEvents.jumping);
    }

    public void jumpTo(long msVideo) {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setTime(msVideo);
        } else {
            for (Video video : this.videos) {
                video.player.setTime(msVideo);
            }
        }
        this.notifyObservers(VideoObserversEvents.jumping);
    }

    public long getVideoTime() {
        return this.videos.get((int)0).player.getTime();
    }

    public void jumpToPosition(int percent) {
        float position = (float)percent / 100.0f;
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setPosition(position);
        } else {
            for (Video video : this.videos) {
                video.player.setPosition(position);
            }
        }
        this.notifyObservers(VideoObserversEvents.jumping);
    }

    public int getPosition() {
        return (int)(this.videos.get((int)0).player.getPosition() * 100.0f);
    }

    public void setSpeed(int percent) {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setRate((float)percent / 100.0f);
        }
        for (Video video : this.videos) {
            video.player.setRate((float)percent / 100.0f);
        }
        this.notifyObservers(VideoObserversEvents.speeding);
    }

    public int getSpeed() {
        return (int)(this.videos.get((int)0).player.getRate() * 100.0f);
    }

    public boolean hasSubtitles() {
        for (Video video : this.videos) {
            if (video.player.getSpuCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setSubtitles(boolean enabled) {
        if (enabled) {
            for (Video video : this.videos) {
                video.player.setSpu(0);
            }
        } else {
            for (Video video : this.videos) {
                video.player.setSpu(-1);
            }
        }
    }

    public void setDeinterlacer(String deinterlacer) {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.setDeinterlace(deinterlacer);
        } else {
            for (Video video : this.videos) {
                video.player.setDeinterlace(deinterlacer);
            }
        }
    }

    public static String[] getDeinterlacers() {
        return deinterlacers;
    }

    public void mute() {
        if (this.singleVideoMode) {
            this.lastAddedVideo.player.mute();
        }
        for (Video video : this.videos) {
            video.player.mute();
        }
    }

    public void unload() {
        for (Video video : this.videos) {
            video.player.stop();
            video.player.release();
            video.player = null;
            video.canvas = null;
        }
        this.mediaPlayerFactory.release();
    }

    public void addObserver(VideosObserver observer) {
        this.observers.add(observer);
    }

    private void notifyObservers(VideoObserversEvents event) {
        for (VideosObserver observer : this.observers) {
            observer.update(event);
        }
    }

    @Override
    public void backward(MediaPlayer arg0) {
    }

    @Override
    public void buffering(MediaPlayer arg0) {
    }

    @Override
    public void error(MediaPlayer arg0) {
    }

    @Override
    public void finished(MediaPlayer arg0) {
    }

    @Override
    public void forward(MediaPlayer arg0) {
    }

    @Override
    public void lengthChanged(MediaPlayer arg0, long arg1) {
    }

    @Override
    public void mediaChanged(MediaPlayer arg0) {
    }

    @Override
    public void metaDataAvailable(MediaPlayer mp, VideoMetaData data) {
        Dimension org = data.getVideoDimension();
        this.getVideo((MediaPlayer)mp).canvas.setSize(new Dimension((int)((float)org.width * 0.5f), (int)((float)org.height * 0.5f)));
        this.notifyObservers(VideoObserversEvents.resizing);
    }

    @Override
    public void opening(MediaPlayer arg0) {
    }

    @Override
    public void pausableChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void paused(MediaPlayer arg0) {
    }

    @Override
    public void playing(MediaPlayer arg0) {
    }

    @Override
    public void positionChanged(MediaPlayer arg0, float arg1) {
    }

    @Override
    public void seekableChanged(MediaPlayer arg0, int arg1) {
    }

    @Override
    public void snapshotTaken(MediaPlayer arg0, String arg1) {
    }

    @Override
    public void stopped(MediaPlayer arg0) {
    }

    @Override
    public void timeChanged(MediaPlayer arg0, long arg1) {
    }

    @Override
    public void titleChanged(MediaPlayer arg0, int arg1) {
    }

    public boolean isNoVideoPlaying() {
        for (Video video : this.videos) {
            if (!video.player.isPlaying()) continue;
            return false;
        }
        return true;
    }

    public void enableSingleVideoMode(boolean enabled) {
        this.singleVideoMode = true;
    }
}

