/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class SinusoidalProjection
extends PseudoCylindricalProjection {
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        xy.x = lam * Math.cos(phi);
        xy.y = phi;
        return xy;
    }

    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        lp.x = x / Math.cos(y);
        lp.y = y;
        return lp;
    }

    public double getWidth(double y) {
        return ProjectionMath.normalizeLongitude(Math.PI) * Math.cos(y);
    }

    public boolean hasInverse() {
        return true;
    }

    public boolean isEqualArea() {
        return true;
    }

    public String toString() {
        return "Sinusoidal";
    }
}

