/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.proj4j;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.tools.I18n;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionProj4J
implements Projection,
ProjectionSubPrefs {
    private String crsCode = "EPSG:4326";
    private String filterText = "";
    private CoordinateReferenceSystem proj4jCRS;
    private CoordinateReferenceSystem wgs84CRS;
    private CoordinateTransform transformToWGS84;
    private CoordinateTransform transformFromWGS84;
    private JTable table;
    private JTextField filterTextField;
    private JLabel selectedLabel;
    private CRSTableModel model;
    private TableRowSorter<CRSTableModel> sorter;
    private ActionListener actionListener;

    public ProjectionProj4J() {
        try {
            this.model = new CRSTableModel();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sorter = new TableRowSorter<CRSTableModel>(this.model);
        this.setupTransformations();
    }

    public void setupPreferencePanel(JPanel p, ActionListener actionListener) {
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        JLabel filterLabel = new JLabel(I18n.tr((String)"Filter"), 11);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        p.add((Component)filterLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        this.filterTextField = new JTextField(this.filterText, 20);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ProjectionProj4J.this.newFilter();
            }

            public void removeUpdate(DocumentEvent e) {
                ProjectionProj4J.this.newFilter();
            }

            public void changedUpdate(DocumentEvent e) {
                ProjectionProj4J.this.newFilter();
            }
        });
        p.add((Component)this.filterTextField, c);
        this.selectedLabel = new JLabel(I18n.tr((String)"Selected: {0}", (Object[])new Object[]{this.crsCode}), 11);
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        p.add(this.selectedLabel);
        filterLabel.setLabelFor(this.filterTextField);
        this.table = new JTable(this.model);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.setFillsViewportHeight(true);
        this.table.setRowSorter(this.sorter);
        this.table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.gridwidth = 3;
        p.add((Component)scrollPane, c);
        this.newFilter();
        int index = this.model.findCode(this.crsCode);
        if (index >= 0 && (index = this.table.convertRowIndexToView(index)) >= 0) {
            this.table.addRowSelectionInterval(index, index);
            this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
        }
        this.table.getSelectionModel().addListSelectionListener(new SelectionListener(this.table));
        this.actionListener = actionListener;
    }

    public Collection<String> getPreferences(JPanel p) {
        return Arrays.asList(this.crsCode, this.filterText);
    }

    public Collection<String> getPreferencesFromCode(String code) {
        return Collections.singleton(code);
    }

    public void setPreferences(Collection<String> args) {
        if (args != null) {
            String[] array = args.toArray(new String[0]);
            if (array.length > 0) {
                this.crsCode = array[0];
            }
            if (array.length > 1) {
                this.filterText = array[1];
            }
            this.setupTransformations();
        }
    }

    public double getDefaultZoomInPPD() {
        return 1.01;
    }

    public EastNorth latlon2eastNorth(LatLon p) {
        ProjCoordinate pc1 = new ProjCoordinate(p.lon(), p.lat());
        ProjCoordinate pc2 = new ProjCoordinate();
        this.transformFromWGS84.transform(pc1, pc2);
        return new EastNorth(pc2.x, pc2.y);
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        ProjCoordinate pc1 = new ProjCoordinate(p.east(), p.north());
        ProjCoordinate pc2 = new ProjCoordinate();
        this.transformToWGS84.transform(pc1, pc2);
        return new LatLon(pc2.y, pc2.x);
    }

    public String toString() {
        return I18n.tr((String)("Proj4J: " + this.crsCode));
    }

    public String toCode() {
        return this.crsCode;
    }

    public String getCacheDirectoryName() {
        return "Proj4J";
    }

    public Bounds getWorldBoundsLatLon() {
        org.osgeo.proj4j.proj.Projection proj = this.proj4jCRS.getProjection();
        LatLon min = new LatLon(proj.getMinLatitudeDegrees(), proj.getMinLongitudeDegrees());
        LatLon max = new LatLon(proj.getMaxLatitudeDegrees(), proj.getMaxLongitudeDegrees());
        return new Bounds(min, max);
    }

    public String[] allCodes() {
        return this.model.getAllCodes();
    }

    private void updateSelectedCode() {
        int index = this.table.getSelectedRow();
        if (index >= 0 && (index = this.table.convertRowIndexToModel(index)) >= 0) {
            this.crsCode = this.model.getCRSEntryAt(index).getName();
            this.selectedLabel.setText(I18n.tr((String)"Selected: {0}", (Object[])new Object[]{this.crsCode}));
            this.setupTransformations();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this.selectedLabel, 0, "CRS changed"));
            }
        }
    }

    private void setupTransformations() {
        CRSFactory crsFactory = new CRSFactory();
        CoordinateTransformFactory transFactory = new CoordinateTransformFactory();
        this.proj4jCRS = crsFactory.createFromName(this.crsCode);
        this.wgs84CRS = crsFactory.createFromName("EPSG:4326");
        this.transformToWGS84 = transFactory.createTransform(this.proj4jCRS, this.wgs84CRS);
        this.transformFromWGS84 = transFactory.createTransform(this.wgs84CRS, this.proj4jCRS);
    }

    private void newFilter() {
        RowFilter rf = null;
        this.filterText = this.filterTextField.getText();
        try {
            rf = RowFilter.regexFilter("(?i)" + this.filterText, new int[0]);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.sorter.setRowFilter(rf);
    }

    class CRSTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{I18n.tr((String)"Code"), I18n.tr((String)"Description")};
        private ArrayList<CRSEntry> crsList = new ArrayList();

        public CRSTableModel() throws IOException {
            String s;
            InputStream inStr = this.getClass().getResourceAsStream("/resources/projections.txt");
            BufferedReader fh = new BufferedReader(new InputStreamReader(inStr));
            while ((s = fh.readLine()) != null) {
                String[] f = s.split("\t");
                this.crsList.add(new CRSEntry(f[0], f[1], f[2]));
            }
            fh.close();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.crsList.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (row >= this.crsList.size()) {
                return "Empty";
            }
            if (col == 0) {
                return this.crsList.get(row).getName();
            }
            return this.crsList.get(row).getDescription();
        }

        public CRSEntry getCRSEntryAt(int index) {
            return this.crsList.get(index);
        }

        public String[] getAllCodes() {
            int size = this.crsList.size();
            String[] codes = new String[size];
            for (int i = 0; i < size; ++i) {
                codes[i] = this.crsList.get(i).getName();
            }
            return codes;
        }

        public int findCode(String code) {
            int size = this.crsList.size();
            for (int i = 0; i < size; ++i) {
                if (code.compareTo(this.crsList.get(i).getName()) != 0) continue;
                return i;
            }
            return -1;
        }
    }

    class CRSEntry {
        public String authority;
        public String code;
        public String description;

        public CRSEntry(String authority, String code, String description) {
            this.code = code;
            this.authority = authority;
            this.description = description;
        }

        public String getName() {
            return this.authority + ":" + this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            ProjectionProj4J.this.updateSelectedCode();
        }
    }
}

