/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.actions.AddRouteNodeAction;
import com.innovant.josm.plugin.routing.actions.MoveRouteNodeAction;
import com.innovant.josm.plugin.routing.actions.RemoveRouteNodeAction;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import com.innovant.josm.plugin.routing.gui.RoutingMenu;
import com.innovant.josm.plugin.routing.gui.RoutingPreferenceDialog;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class RoutingPlugin
extends Plugin
implements MapView.LayerChangeListener,
DataSetListenerAdapter.Listener {
    static Logger logger = Logger.getLogger(RoutingPlugin.class);
    private ArrayList<RoutingLayer> layers;
    private RoutingDialog routingDialog;
    private PreferenceSetting preferenceSettings;
    private AddRouteNodeAction addRouteNodeAction;
    private RemoveRouteNodeAction removeRouteNodeAction;
    private MoveRouteNodeAction moveRouteNodeAction;
    private IconToggleButton addRouteNodeButton;
    private IconToggleButton removeRouteNodeButton;
    private IconToggleButton moveRouteNodeButton;
    private RoutingMenu menu;
    private static RoutingPlugin plugin;
    private DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter((DataSetListenerAdapter.Listener)this);

    public RoutingPlugin(PluginInformation info) {
        super(info);
        plugin = this;
        DOMConfigurator.configure("log4j.xml");
        logger.debug("Loading routing plugin...");
        this.preferenceSettings = new RoutingPreferenceDialog();
        this.routingDialog = new RoutingDialog();
        this.layers = new ArrayList();
        this.menu = new RoutingMenu();
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        DatasetEventManager.getInstance().addDatasetListener((DataSetListener)this.datasetAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        logger.debug("Finished loading plugin");
    }

    public static RoutingPlugin getInstance() {
        return plugin;
    }

    public RoutingDialog getRoutingDialog() {
        return this.routingDialog;
    }

    public void addLayer() {
        OsmDataLayer osmLayer = Main.map.mapView.getEditLayer();
        RoutingLayer layer = new RoutingLayer(I18n.tr((String)"Routing") + " [" + osmLayer.getName() + "]", osmLayer);
        this.layers.add(layer);
        Main.main.addLayer((Layer)layer);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.addRouteNodeAction = new AddRouteNodeAction(newFrame);
            this.removeRouteNodeAction = new RemoveRouteNodeAction(newFrame);
            this.moveRouteNodeAction = new MoveRouteNodeAction(newFrame);
            this.addRouteNodeButton = new IconToggleButton((Action)((Object)this.addRouteNodeAction));
            this.removeRouteNodeButton = new IconToggleButton((Action)((Object)this.removeRouteNodeAction));
            this.moveRouteNodeButton = new IconToggleButton((Action)((Object)this.moveRouteNodeAction));
            newFrame.addMapMode(this.addRouteNodeButton);
            newFrame.addMapMode(this.removeRouteNodeButton);
            newFrame.addMapMode(this.moveRouteNodeButton);
            newFrame.toolGroup.add((AbstractButton)this.addRouteNodeButton);
            newFrame.toolGroup.add((AbstractButton)this.removeRouteNodeButton);
            newFrame.toolGroup.add((AbstractButton)this.moveRouteNodeButton);
            this.addRouteNodeButton.setVisible(false);
            this.removeRouteNodeButton.setVisible(false);
            this.moveRouteNodeButton.setVisible(false);
            this.menu.enableStartItem();
            newFrame.addToggleDialog((ToggleDialog)this.routingDialog);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof RoutingLayer) {
            this.addRouteNodeButton.setVisible(true);
            this.removeRouteNodeButton.setVisible(true);
            this.moveRouteNodeButton.setVisible(true);
            this.menu.enableRestOfItems();
            this.routingDialog.showDialog();
            this.routingDialog.refresh();
        } else {
            this.addRouteNodeButton.setVisible(false);
            this.removeRouteNodeButton.setVisible(false);
            this.moveRouteNodeButton.setVisible(false);
            this.menu.disableRestOfItems();
            this.routingDialog.hideDialog();
        }
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof RoutingLayer) {
            this.addRouteNodeButton.setVisible(true);
            this.removeRouteNodeButton.setVisible(true);
            this.moveRouteNodeButton.setVisible(true);
            this.menu.enableRestOfItems();
            Main.map.mapView.moveLayer(newLayer, 0);
            logger.debug("Added routing layer.");
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof RoutingLayer & this.layers.size() == 1) {
            this.addRouteNodeButton.setVisible(false);
            this.removeRouteNodeButton.setVisible(false);
            this.moveRouteNodeButton.setVisible(false);
            this.menu.disableRestOfItems();
            this.layers.remove(oldLayer);
            logger.debug("Removed routing layer.");
        } else if (oldLayer instanceof OsmDataLayer) {
            RoutingLayer[] layersArray = this.layers.toArray(new RoutingLayer[0]);
            for (int i = 0; i < layersArray.length; ++i) {
                if (!layersArray[i].getDataLayer().equals(oldLayer)) continue;
                try {
                    Main.map.mapView.removeLayer((Layer)layersArray[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        this.routingDialog.refresh();
    }

    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
    }

    public PreferenceSetting getPreferenceSetting() {
        return this.preferenceSettings;
    }
}

