/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class FastDrawConfigDialog
extends ExtendedDialog {
    public FastDrawConfigDialog(FDSettings settings) {
        super(Main.parent, I18n.tr((String)"FastDraw configuration"), new String[]{I18n.tr((String)"Ok"), I18n.tr((String)"Cancel")});
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        JLabel label1 = new JLabel(I18n.tr((String)"Epsilon multiplier"));
        JLabel label2 = new JLabel(I18n.tr((String)"Starting Epsilon"));
        JLabel label3 = new JLabel(I18n.tr((String)"Max points count per 1 km"));
        JLabel label4 = new JLabel(I18n.tr((String)"Enter key mode"));
        JFormattedTextField text1 = new JFormattedTextField(NumberFormat.getInstance());
        JFormattedTextField text2 = new JFormattedTextField(NumberFormat.getInstance());
        JFormattedTextField text3 = new JFormattedTextField(NumberFormat.getInstance());
        JComboBox<String> combo1 = new JComboBox<String>(new String[]{I18n.tr((String)"Autosimplify"), I18n.tr((String)"Simplify with initial epsilon"), I18n.tr((String)"Save as is")});
        JCheckBox snapCb = new JCheckBox(I18n.tr((String)"Snap to nodes"));
        JCheckBox fixedClickCb = new JCheckBox(I18n.tr((String)"Add fixed points on click"));
        JCheckBox fixedSpaceCb = new JCheckBox(I18n.tr((String)"Add fixed points on spacebar"));
        all.add((Component)label1, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)text1, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label2, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)text2, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label3, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)text3, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label4, GBC.std().insets(10, 0, 0, 0));
        all.add(combo1, GBC.eop().fill(2).insets(5, 0, 0, 5));
        all.add((Component)snapCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)fixedClickCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)fixedSpaceCb, GBC.eop().insets(20, 0, 0, 0));
        text1.setValue(settings.epsilonMult);
        text2.setValue(settings.startingEps);
        text3.setValue(settings.maxPointsPerKm);
        snapCb.setSelected(settings.snapNodes);
        fixedClickCb.setSelected(settings.fixedClick);
        fixedSpaceCb.setSelected(settings.fixedSpacebar);
        combo1.setSelectedIndex(settings.simplifyMode);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"FastDraw settings"), new String[]{I18n.tr((String)"Ok"), I18n.tr((String)"Cancel")});
        this.setContent(all, false);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setToolTipTexts(new String[]{I18n.tr((String)"Save settings"), I18n.tr((String)"Cancel")});
        this.setDefaultButton(1);
        this.showDialog();
        if (dialog.getValue() == 0) {
            try {
                settings.epsilonMult = NumberFormat.getInstance().parse(text1.getText()).doubleValue();
                settings.startingEps = NumberFormat.getInstance().parse(text2.getText()).doubleValue();
                settings.maxPointsPerKm = NumberFormat.getInstance().parse(text3.getText()).doubleValue();
                settings.snapNodes = snapCb.isSelected();
                settings.fixedClick = fixedClickCb.isSelected();
                settings.fixedSpacebar = fixedSpaceCb.isSelected();
                settings.simplifyMode = combo1.getSelectedIndex();
                settings.savePrefs();
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can not read settings"));
            }
        }
    }
}

