/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.filter;

import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMWay;
import org.openstreetmap.josm.plugins.JunctionChecker.filter.Filter;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.XMLFilterReader;

public class ExecuteFilter {
    private Filter[] filter;
    private XMLFilterReader xmlfilterreader;
    private OSMGraph incominggraph;
    private OSMGraph outgoinggraph;

    public ExecuteFilter(Filter[] filter, OSMGraph incoming) {
        this.filter = filter;
        this.incominggraph = incoming;
        this.outgoinggraph = new OSMGraph();
        this.outgoinggraph.setBbbottom(incoming.getBbbottom());
        this.outgoinggraph.setBbleft(incoming.getBbleft());
        this.outgoinggraph.setBbright(incoming.getBbright());
        this.outgoinggraph.setBbtop(incoming.getBbtop());
        this.outgoinggraph.setRelations(incoming.getRelationsAshashmap());
    }

    public ExecuteFilter() {
    }

    public void filter() {
        OSMWay[] tempWays = this.incominggraph.getWays();
        for (int i = 0; i < this.filter.length; ++i) {
            for (int j = 0; j < tempWays.length; ++j) {
                String key = this.filter[i].getKeyValue();
                if (!tempWays[j].hasKey(key) || !this.filter[i].hasTagValue(tempWays[j].getValue(key))) continue;
                this.outgoinggraph.addWay(tempWays[j]);
                for (int j2 = 0; j2 < tempWays[j].getNodes().length; ++j2) {
                    if (this.outgoinggraph.hasNode(tempWays[j].getNodes()[j2].getId())) continue;
                    this.outgoinggraph.addNode(tempWays[j].getNodes()[j2]);
                }
            }
        }
    }

    public Filter[] getFilter() {
        return this.filter;
    }

    public void setFilter(Filter[] filter) {
        this.filter = filter;
    }

    public XMLFilterReader getXmlfilterreader() {
        return this.xmlfilterreader;
    }

    public void setXmlfilterreader(XMLFilterReader xmlfilterreader) {
        this.xmlfilterreader = xmlfilterreader;
    }

    public OSMGraph getIncominggraph() {
        return this.incominggraph;
    }

    public void setIncominggraph(OSMGraph incominggraph) {
        this.incominggraph = incominggraph;
    }

    public OSMGraph getOutgoinggraph() {
        return this.outgoinggraph;
    }

    public void setOutgoinggraph(OSMGraph outgoinggraph) {
        this.outgoinggraph = outgoinggraph;
    }
}

