/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.Address;
import cadastre_fr.CadastrePreferenceSetting;
import cadastre_fr.CheckSourceUploadHook;
import cadastre_fr.MenuActionGrab;
import cadastre_fr.MenuActionGrabPlanImage;
import cadastre_fr.MenuActionLoadFromCache;
import cadastre_fr.MenuActionNewLocation;
import cadastre_fr.WMSAdjustAction;
import cadastre_fr.WMSLayer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.UTM_France_DOM;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;

public class CadastrePlugin
extends Plugin {
    static String VERSION = "2.1";
    static JMenu cadastreJMenu;
    public static String source;
    public static boolean autoSourcing;
    public static boolean pluginUsed;
    public static String cacheDir;
    public static boolean alterColors;
    public static boolean backgroundTransparent;
    public static float transparency;
    public static boolean drawBoundaries;
    public static int imageWidth;
    public static int imageHeight;
    public static String grabLayers;
    public static String grabStyles;
    private static boolean menuEnabled;
    private static String LAYER_BULDINGS;
    private static String STYLE_BUILDING;
    private static String LAYER_WATER;
    private static String STYLE_WATER;
    private static String LAYER_SYMBOL;
    private static String STYLE_SYMBOL;
    private static String LAYER_PARCELS;
    private static String STYLE_PARCELS;
    private static String LAYER_NUMERO;
    private static String STYLE_NUMERO;
    private static String LAYER_LABEL;
    private static String STYLE_LABEL;
    private static String LAYER_LIEUDIT;
    private static String STYLE_LIEUDIT;
    private static String LAYER_SECTION;
    private static String STYLE_SECTION;
    private static String LAYER_COMMUNE;
    private static String STYLE_COMMUNE;

    public CadastrePlugin(PluginInformation info) throws Exception {
        super(info);
        System.out.println("Pluging cadastre-fr v" + VERSION + " started...");
        if (Main.pref.get("cadastrewms.cacheDir").equals("")) {
            cacheDir = Main.pref.getPreferencesDir() + "plugins" + File.separatorChar + "cadastrewms" + File.separatorChar;
        } else {
            cacheDir = Main.pref.get("cadastrewms.cacheDir");
            if (cacheDir.charAt(cacheDir.length() - 1) != File.separatorChar) {
                cacheDir = cacheDir + File.separatorChar;
            }
        }
        System.out.println("current cache directory: " + cacheDir);
        CadastrePlugin.refreshConfiguration();
        UploadAction.registerUploadHook((UploadHook)new CheckSourceUploadHook());
    }

    public static void refreshMenu() {
        MainMenu menu = Main.main.menu;
        if (cadastreJMenu == null) {
            String string = I18n.marktr((String)"Cadastre");
            menu.getClass();
            cadastreJMenu = menu.addMenu(string, 67, 6, HelpUtil.ht((String)"/Plugin/CadastreFr"));
            MenuActionGrab grab = new MenuActionGrab();
            JMenuItem menuGrab = new JMenuItem((Action)((Object)grab));
            KeyStroke ks = grab.getShortcut().getKeyStroke();
            if (ks != null) {
                menuGrab.setAccelerator(ks);
            }
            JMenuItem menuActionGrabPlanImage = new JMenuItem((Action)((Object)new MenuActionGrabPlanImage()));
            JMenuItem menuSettings = new JMenuItem((Action)((Object)new MenuActionNewLocation()));
            final JCheckBoxMenuItem menuSource = new JCheckBoxMenuItem(I18n.tr((String)"Auto sourcing"));
            menuSource.setSelected(autoSourcing);
            menuSource.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    Main.pref.put("cadastrewms.autosourcing", menuSource.isSelected());
                    autoSourcing = menuSource.isSelected();
                }
            });
            JMenuItem menuLoadFromCache = new JMenuItem((Action)((Object)new MenuActionLoadFromCache()));
            cadastreJMenu.add(menuGrab);
            cadastreJMenu.add(menuActionGrabPlanImage);
            cadastreJMenu.add(menuSettings);
            cadastreJMenu.add(menuSource);
            cadastreJMenu.add(menuLoadFromCache);
        }
        CadastrePlugin.setEnabledAll(menuEnabled);
    }

    public static void refreshConfiguration() {
        source = CadastrePlugin.checkSourceMillesime();
        autoSourcing = Main.pref.getBoolean("cadastrewms.autosourcing", true);
        alterColors = Main.pref.getBoolean("cadastrewms.alterColors");
        drawBoundaries = Main.pref.getBoolean("cadastrewms.drawBoundaries", false);
        if (alterColors) {
            backgroundTransparent = Main.pref.getBoolean("cadastrewms.backgroundTransparent");
            transparency = Float.parseFloat(Main.pref.get("cadastrewms.brightness", "1.0f"));
        } else {
            backgroundTransparent = false;
            transparency = 1.0f;
        }
        String currentResolution = Main.pref.get("cadastrewms.resolution", "high");
        if (currentResolution.equals("high")) {
            imageWidth = 1000;
            imageHeight = 800;
        } else if (currentResolution.equals("medium")) {
            imageWidth = 800;
            imageHeight = 600;
        } else {
            imageWidth = 600;
            imageHeight = 400;
        }
        CadastrePlugin.refreshLayersURL();
        int i = 0;
        String p = Main.pref.get("shortcut.shortcut." + i, null);
        boolean alreadyRedefined = false;
        while (p != null) {
            String[] s = p.split(";");
            alreadyRedefined = alreadyRedefined || s[0].equals("menu:view:fullscreen");
            p = Main.pref.get("shortcut.shortcut." + ++i, null);
        }
        if (!alreadyRedefined) {
            int reply = JOptionPane.showConfirmDialog(null, I18n.tr((String)"Plugin cadastre-fr used traditionally the key shortcut F11 for grabbing,\nwhich is currently allocated for full-screen switch by default.\nWould you like to restore F11 for grab action?"), I18n.tr((String)"Restore grab shortcut F11"), 0);
            if (reply == 0) {
                System.out.println("redefine fullscreen shortcut F11 to shift+F11");
                Main.pref.put("shortcut.shortcut." + i, "menu:view:fullscreen;Toggle Full Screen view;122;5;122;64;false;true");
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"JOSM is stopped for the change to take effect."));
                System.exit(0);
            }
        } else {
            System.out.println("Shortcut F11 already redefined; do not change.");
        }
        CadastrePlugin.refreshMenu();
    }

    private static void refreshLayersURL() {
        grabLayers = "";
        grabStyles = "";
        int countLayers = 0;
        if (Main.pref.getBoolean("cadastrewms.layerWater", true)) {
            grabLayers = grabLayers + LAYER_WATER + ",";
            grabStyles = grabStyles + STYLE_WATER + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerBuilding", true)) {
            grabLayers = grabLayers + LAYER_BULDINGS + ",";
            grabStyles = grabStyles + STYLE_BUILDING + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerSymbol", true)) {
            grabLayers = grabLayers + LAYER_SYMBOL + ",";
            grabStyles = grabStyles + STYLE_SYMBOL + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerParcel", true)) {
            grabLayers = grabLayers + LAYER_PARCELS + ",";
            grabStyles = grabStyles + STYLE_PARCELS + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerNumero", true)) {
            grabLayers = grabLayers + LAYER_NUMERO + ",";
            grabStyles = grabStyles + STYLE_NUMERO + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerLabel", true)) {
            grabLayers = grabLayers + LAYER_LABEL + ",";
            grabStyles = grabStyles + STYLE_LABEL + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerLieudit", true)) {
            grabLayers = grabLayers + LAYER_LIEUDIT + ",";
            grabStyles = grabStyles + STYLE_LIEUDIT + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerSection", true)) {
            grabLayers = grabLayers + LAYER_SECTION + ",";
            grabStyles = grabStyles + STYLE_SECTION + ",";
            ++countLayers;
        }
        if (Main.pref.getBoolean("cadastrewms.layerCommune", true)) {
            grabLayers = grabLayers + LAYER_COMMUNE + ",";
            grabStyles = grabStyles + STYLE_COMMUNE + ",";
            ++countLayers;
        }
        if (countLayers > 2) {
            grabLayers = grabLayers.substring(0, grabLayers.length() - 1);
            grabStyles = grabStyles.substring(0, grabStyles.length() - 1);
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please enable at least two WMS layers in the cadastre-fr plugin configuration.\nLayers ''Building'' and ''Parcel'' added by default."));
            Main.pref.put("cadastrewms.layerBuilding", true);
            Main.pref.put("cadastrewms.layerParcel", true);
            grabLayers = grabLayers + LAYER_BULDINGS + "," + LAYER_PARCELS;
            grabStyles = grabStyles + STYLE_BUILDING + "," + STYLE_PARCELS;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new CadastrePreferenceSetting();
    }

    private static void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < cadastreJMenu.getItemCount(); ++i) {
            JMenuItem item = cadastreJMenu.getItem(i);
            if (item == null || !item.getText().equals(MenuActionGrabPlanImage.name)) continue;
            item.setEnabled(isEnabled);
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (cadastreJMenu != null) {
            if (oldFrame == null && newFrame != null) {
                CadastrePlugin.setEnabledAll(true);
                Main.map.addMapMode(new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
                Main.map.addMapMode(new IconToggleButton((Action)((Object)new Address(Main.map))));
            } else if (oldFrame != null && newFrame == null) {
                CadastrePlugin.setEnabledAll(false);
            }
        }
    }

    public static boolean isCadastreProjection() {
        return Main.getProjection().toString().equals(new Lambert().toString()) || Main.getProjection().toString().equals(new UTM_France_DOM().toString()) || Main.getProjection().toString().equals(new LambertCC9Zones().toString());
    }

    public static void safeSleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void prepareDialog(JDialog dialog) {
        if (Main.pref.getBoolean("window-handling.option-pane-always-on-top", true)) {
            try {
                dialog.setAlwaysOnTop(true);
            }
            catch (SecurityException e) {
                System.out.println(I18n.tr((String)"Warning: failed to put option pane dialog always on top. Exception was: {0}", (Object[])new Object[]{e.toString()}));
            }
        }
        dialog.setModal(true);
        dialog.toFront();
        dialog.setDefaultCloseOperation(2);
    }

    public static void addWMSLayer(WMSLayer wmsLayer) {
        if (Main.map != null && Main.map.mapView != null) {
            int wmsNewLayerPos = Main.map.mapView.getAllLayers().size();
            for (WMSLayer l : Main.map.mapView.getLayersOfType(WMSLayer.class)) {
                int wmsPos = Main.map.mapView.getLayerPos((Layer)l);
                if (wmsPos >= wmsNewLayerPos) continue;
                wmsNewLayerPos = wmsPos;
            }
            Main.main.addLayer((Layer)wmsLayer);
            Main.map.mapView.moveLayer((Layer)wmsLayer, wmsNewLayerPos);
        } else {
            Main.main.addLayer((Layer)wmsLayer);
        }
    }

    private static String checkSourceMillesime() {
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        String src = Main.pref.get("cadastrewms.source", "cadastre-dgi-fr source : Direction G\u00e9n\u00e9rale des Imp\u00f4ts - Cadastre. Mise \u00e0 jour : AAAA");
        String srcYear = src.substring(src.lastIndexOf(" ") + 1);
        Integer year = null;
        try {
            year = Integer.decode(srcYear);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (srcYear.equals("AAAA") || year != null && year < currentYear) {
            System.out.println("Replace source year " + srcYear + " by current year " + currentYear);
            src = src.substring(0, src.lastIndexOf(" ") + 1) + currentYear;
            Main.pref.put("cadastrewms.source", src);
        }
        return src;
    }

    static {
        source = "";
        autoSourcing = false;
        pluginUsed = false;
        cacheDir = null;
        alterColors = false;
        backgroundTransparent = false;
        transparency = 1.0f;
        drawBoundaries = false;
        grabStyles = null;
        menuEnabled = false;
        LAYER_BULDINGS = "CDIF:LS2";
        STYLE_BUILDING = "LS2_90";
        LAYER_WATER = "CDIF:LS3";
        STYLE_WATER = "LS3_90";
        LAYER_SYMBOL = "CDIF:LS1";
        STYLE_SYMBOL = "LS1_90";
        LAYER_PARCELS = "CDIF:PARCELLE";
        STYLE_PARCELS = "PARCELLE_90";
        LAYER_NUMERO = "CDIF:NUMERO";
        STYLE_NUMERO = "NUMERO_90";
        LAYER_LABEL = "CDIF:PT3,CDIF:PT2,CDIF:PT1";
        STYLE_LABEL = "PT3_90,PT2_90,PT1_90";
        LAYER_LIEUDIT = "CDIF:LIEUDIT";
        STYLE_LIEUDIT = "LIEUDIT_90";
        LAYER_SECTION = "CDIF:SUBSECTION,CDIF:SECTION";
        STYLE_SECTION = "SUBSECTION_90,SECTION_90";
        LAYER_COMMUNE = "CDIF:COMMUNE";
        STYLE_COMMUNE = "COMMUNE_90";
    }
}

