/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class PicLayerFromClipboard
extends PicLayerAbstract {
    protected Image createImage() throws IOException {
        Image image = null;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t == null) {
            throw new IOException(I18n.tr((String)"Nothing in clipboard"));
        }
        try {
            if (!t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                throw new IOException(I18n.tr((String)"The clipboard data is not an image"));
            }
            image = (Image)t.getTransferData(DataFlavor.imageFlavor);
        }
        catch (UnsupportedFlavorException e) {
            throw new IOException(e.getMessage());
        }
        return image;
    }

    protected String getPicLayerName() {
        return "Clipboard";
    }

    protected void lookForCalibration() throws IOException {
    }
}

