/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Color;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class FDSettings {
    public Color COLOR_FIXED;
    public Color COLOR_NORMAL;
    public Color COLOR_DELETE;
    public Color COLOR_SELECTEDFRAGMENT;
    public Color COLOR_EDITEDFRAGMENT;
    public double maxDist;
    public double epsilonMult;
    public double minPixelsBetweenPoints;
    public double startingEps;
    public double maxPointsPerKm;
    public int pkmBlockSize;

    public void loadPrefs() {
        this.COLOR_DELETE = Main.pref.getColor("fastdraw.color.delete", Color.red);
        this.COLOR_EDITEDFRAGMENT = Main.pref.getColor("fastdraw.color.edit", Color.orange);
        this.COLOR_FIXED = Main.pref.getColor("fastdraw.color.fixed", Color.green);
        this.COLOR_NORMAL = Main.pref.getColor("fastdraw.color.normal", Color.red);
        this.COLOR_SELECTEDFRAGMENT = Main.pref.getColor("fastdraw.color.select", Color.blue);
        this.maxDist = Main.pref.getDouble("fastdraw.maxdist", 5.0);
        this.epsilonMult = Main.pref.getDouble("fastdraw.epsilonmult", 1.1);
        this.minPixelsBetweenPoints = Main.pref.getDouble("fastdraw.mindelta", 20.0);
        this.startingEps = Main.pref.getDouble("fastdraw.startingEps", 0.1);
        this.maxPointsPerKm = Main.pref.getDouble("fastdraw.maxpkm", 20.0);
        this.pkmBlockSize = Main.pref.getInteger("fastdraw.pkmblocksize", 10);
    }

    public void savePrefs() {
        Main.pref.putColor("fastdraw.color.delete", this.COLOR_DELETE);
        Main.pref.putColor("fastdraw.color.edit", this.COLOR_EDITEDFRAGMENT);
        Main.pref.putColor("fastdraw.color.fixed", this.COLOR_FIXED);
        Main.pref.putColor("fastdraw.color.normal", this.COLOR_NORMAL);
        Main.pref.putColor("fastdraw.color.select", this.COLOR_SELECTEDFRAGMENT);
        Main.pref.putDouble("fastdraw.maxdist", Double.valueOf(this.maxDist));
        Main.pref.putDouble("fastdraw.epsilonmult", Double.valueOf(this.epsilonMult));
        Main.pref.putDouble("fastdraw.mindelta", Double.valueOf(this.minPixelsBetweenPoints));
        Main.pref.putDouble("fastdraw.startingEps", Double.valueOf(this.startingEps));
        Main.pref.putDouble("fastdraw.maxpkm", Double.valueOf(this.maxPointsPerKm));
        Main.pref.putInteger("fastdraw.pkmblocksize", Integer.valueOf(this.pkmBlockSize));
        try {
            Main.pref.save();
        }
        catch (IOException e) {
            System.err.println(I18n.tr((String)"Can not save preferences"));
        }
    }
}

