/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.parser;

import java.util.HashMap;
import java.util.Map;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.InvalidValueException;
import org.osgeo.proj4j.Registry;
import org.osgeo.proj4j.datum.Datum;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.parser.DatumParameters;
import org.osgeo.proj4j.parser.Proj4Keyword;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.proj.TransverseMercatorProjection;
import org.osgeo.proj4j.units.AngleFormat;
import org.osgeo.proj4j.units.Unit;
import org.osgeo.proj4j.units.Units;

public class Proj4Parser {
    private Registry registry;
    private static AngleFormat format = new AngleFormat("DdM", true);

    public Proj4Parser(Registry registry) {
        this.registry = registry;
    }

    public CoordinateReferenceSystem parse(String name, String[] args) {
        if (args == null) {
            return null;
        }
        Map params = this.createParameterMap(args);
        Proj4Keyword.checkUnsupported(params.keySet());
        DatumParameters datumParam = new DatumParameters();
        this.parseDatum(params, datumParam);
        this.parseEllipsoid(params, datumParam);
        Datum datum = datumParam.getDatum();
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Projection proj = this.parseProjection(params, ellipsoid);
        return new CoordinateReferenceSystem(name, args, datum, proj);
    }

    private Projection parseProjection(Map params, Ellipsoid ellipsoid) {
        Unit unit;
        Projection projection = null;
        String s = (String)params.get("proj");
        if (s != null && (projection = this.registry.getProjection(s)) == null) {
            throw new InvalidValueException("Unknown projection: " + s);
        }
        projection.setEllipsoid(ellipsoid);
        s = (String)params.get("alpha");
        if (s != null) {
            projection.setAlphaDegrees(Double.parseDouble(s));
        }
        if ((s = (String)params.get("lonc")) != null) {
            projection.setLonCDegrees(Double.parseDouble(s));
        }
        if ((s = (String)params.get("lat_0")) != null) {
            projection.setProjectionLatitudeDegrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lon_0")) != null) {
            projection.setProjectionLongitudeDegrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lat_1")) != null) {
            projection.setProjectionLatitude1Degrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lat_2")) != null) {
            projection.setProjectionLatitude2Degrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("lat_ts")) != null) {
            projection.setTrueScaleLatitudeDegrees(Proj4Parser.parseAngle(s));
        }
        if ((s = (String)params.get("x_0")) != null) {
            projection.setFalseEasting(Double.parseDouble(s));
        }
        if ((s = (String)params.get("y_0")) != null) {
            projection.setFalseNorthing(Double.parseDouble(s));
        }
        if ((s = (String)params.get("k_0")) == null) {
            s = (String)params.get("k");
        }
        if (s != null) {
            projection.setScaleFactor(Double.parseDouble(s));
        }
        if ((s = (String)params.get("units")) != null && (unit = Units.findUnits(s)) != null) {
            projection.setFromMetres(1.0 / unit.value);
            projection.setUnits(unit);
        }
        if ((s = (String)params.get("to_meter")) != null) {
            projection.setFromMetres(1.0 / Double.parseDouble(s));
        }
        if (params.containsKey("south")) {
            projection.setSouthernHemisphere(true);
        }
        if (projection instanceof TransverseMercatorProjection && (s = (String)params.get("zone")) != null) {
            ((TransverseMercatorProjection)projection).setUTMZone(Integer.parseInt(s));
        }
        projection.initialize();
        return projection;
    }

    private void parseDatum(Map params, DatumParameters datumParam) {
        String code;
        String towgs84 = (String)params.get("towgs84");
        if (towgs84 != null) {
            double[] datumConvParams = this.parseDatumTransform(towgs84);
            datumParam.setDatumTransform(datumConvParams);
        }
        if ((code = (String)params.get("datum")) != null) {
            Datum datum = this.registry.getDatum(code);
            if (datum == null) {
                throw new InvalidValueException("Unknown datum: " + code);
            }
            datumParam.setDatum(datum);
        }
    }

    private double[] parseDatumTransform(String paramList) {
        String[] numStr = paramList.split(",");
        if (numStr.length != 3 && numStr.length != 7) {
            throw new InvalidValueException("Invalid number of values (must be 3 or 7) in +towgs84: " + paramList);
        }
        double[] param = new double[numStr.length];
        for (int i = 0; i < numStr.length; ++i) {
            param[i] = Double.parseDouble(numStr[i]);
        }
        return param;
    }

    private void parseEllipsoid(Map params, DatumParameters datumParam) {
        String s;
        double b = 0.0;
        String code = (String)params.get("ellps");
        if (code != null) {
            Ellipsoid ellipsoid = this.registry.getEllipsoid(code);
            if (ellipsoid == null) {
                throw new InvalidValueException("Unknown ellipsoid: " + code);
            }
            datumParam.setEllipsoid(ellipsoid);
        }
        if ((s = (String)params.get("a")) != null) {
            double a = Double.parseDouble(s);
            datumParam.setA(a);
        }
        if ((s = (String)params.get("es")) != null) {
            double es = Double.parseDouble(s);
            datumParam.setES(es);
        }
        if ((s = (String)params.get("rf")) != null) {
            double rf = Double.parseDouble(s);
            datumParam.setRF(rf);
        }
        if ((s = (String)params.get("f")) != null) {
            double f = Double.parseDouble(s);
            datumParam.setF(f);
        }
        if ((s = (String)params.get("b")) != null) {
            b = Double.parseDouble(s);
            datumParam.setB(b);
        }
        if (b == 0.0) {
            b = datumParam.getA() * Math.sqrt(1.0 - datumParam.getES());
        }
        this.parseEllipsoidModifiers(params, datumParam);
    }

    private void parseEllipsoidModifiers(Map params, DatumParameters datumParam) {
        if (params.containsKey("R_A")) {
            datumParam.setR_A();
            return;
        }
    }

    private Map createParameterMap(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key;
            String arg = args[i];
            if (!arg.startsWith("+")) continue;
            int index = arg.indexOf(61);
            if (index != -1) {
                key = arg.substring(1, index);
                String value = arg.substring(index + 1);
                params.put(key, value);
                continue;
            }
            key = arg.substring(1);
            params.put(key, null);
        }
        return params;
    }

    private static double parseAngle(String s) {
        return format.parse(s, null).doubleValue();
    }
}

