/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class Wagner2Projection
extends Projection {
    private static final double C_x = 0.92483;
    private static final double C_y = 1.38725;
    private static final double C_p1 = 0.88022;
    private static final double C_p2 = 0.8855;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = ProjectionMath.asin(0.88022 * Math.sin(0.8855 * d2));
        projCoordinate.x = 0.92483 * d * Math.cos(d2);
        projCoordinate.y = 1.38725 * d2;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = d2 / 1.38725;
        projCoordinate.x = d / (0.92483 * Math.cos(projCoordinate.y));
        projCoordinate.y = ProjectionMath.asin(Math.sin(projCoordinate.y) / 0.88022) / 0.8855;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Wagner II";
    }
}

