/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class PerspectiveProjection
extends Projection {
    private double height;
    private double psinph0;
    private double pcosph0;
    private double p;
    private double rp;
    private double pn1;
    private double pfact;
    private double h;
    private double cg;
    private double sg;
    private double sw;
    private double cw;
    private int mode;
    private int tilt;
    private static final double EPS10 = 1.0E-10;
    private static final int N_POLE = 0;
    private static final int S_POLE = 1;
    private static final int EQUIT = 2;
    private static final int OBLIQ = 3;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.cos(d);
        switch (this.mode) {
            case 3: {
                projCoordinate.y = this.psinph0 * d3 + this.pcosph0 * d4 * d5;
                break;
            }
            case 2: {
                projCoordinate.y = d4 * d5;
                break;
            }
            case 1: {
                projCoordinate.y = -d3;
                break;
            }
            case 0: {
                projCoordinate.y = d3;
            }
        }
        projCoordinate.y = this.pn1 / (this.p - projCoordinate.y);
        projCoordinate.x = projCoordinate.y * d4 * Math.sin(d);
        switch (this.mode) {
            case 3: {
                projCoordinate.y *= this.pcosph0 * d3 - this.psinph0 * d4 * d5;
                break;
            }
            case 2: {
                projCoordinate.y *= d3;
                break;
            }
            case 0: {
                d5 = -d5;
            }
            case 1: {
                projCoordinate.y *= d4 * d5;
            }
        }
        if (this.tilt != 0) {
            double d6 = projCoordinate.y * this.cg + projCoordinate.x * this.sg;
            double d7 = 1.0 / (d6 * this.sw * this.h + this.cw);
            projCoordinate.x = (projCoordinate.x * this.cg - projCoordinate.y * this.sg) * this.cw * d7;
            projCoordinate.y = d6 * d7;
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mode = 2;
        this.height = this.a;
        this.tilt = 0;
        this.pn1 = this.height / this.a;
        this.p = 1.0 + this.pn1;
        this.rp = 1.0 / this.p;
        this.h = 1.0 / this.pn1;
        this.pfact = (this.p + 1.0) * this.h;
        this.es = 0.0;
    }

    @Override
    public String toString() {
        return "Perspective";
    }
}

