/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.CylindricalProjection;

public class MillerProjection
extends CylindricalProjection {
    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d;
        projCoordinate.y = Math.log(Math.tan(0.7853981633974483 + d2 * 0.4)) * 1.25;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d;
        projCoordinate.y = 2.5 * (Math.atan(Math.exp(0.8 * d2)) - 0.7853981633974483);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Miller Cylindrical";
    }
}

