/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class MercatorProjection
extends CylindricalProjection {
    public MercatorProjection() {
        this.minLatitude = ProjectionMath.degToRad(-85.0);
        this.maxLatitude = ProjectionMath.degToRad(85.0);
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            projCoordinate.x = this.scaleFactor * d;
            projCoordinate.y = this.scaleFactor * Math.log(Math.tan(0.7853981633974483 + 0.5 * d2));
        } else {
            projCoordinate.x = this.scaleFactor * d;
            projCoordinate.y = -this.scaleFactor * Math.log(ProjectionMath.tsfn(d2, Math.sin(d2), this.e));
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            projCoordinate.y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-d2 / this.scaleFactor));
            projCoordinate.x = d / this.scaleFactor;
        } else {
            projCoordinate.y = ProjectionMath.phi2(Math.exp(-d2 / this.scaleFactor), this.e);
            projCoordinate.x = d / this.scaleFactor;
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isRectilinear() {
        return true;
    }

    @Override
    public int getEPSGCode() {
        return 9804;
    }

    @Override
    public String toString() {
        return "Mercator";
    }
}

