/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.cmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.Proj4jException;
import org.osgeo.proj4j.io.MetaCRSTestCase;
import org.osgeo.proj4j.io.MetaCRSTestFileReader;
import org.osgeo.proj4j.util.CRSCache;

public class MetaCRSTestCmd {
    private static final int TESTS_PER_LINE = 50;
    private static CRSFactory csFactory = new CRSFactory();
    private List<String> filenames = new ArrayList<String>();
    private boolean verbose = false;
    int count = 0;
    int failCount = 0;
    int errCount = 0;
    private CRSCache crsCache = new CRSCache();

    public static void main(String[] stringArray) {
        MetaCRSTestCmd metaCRSTestCmd = new MetaCRSTestCmd();
        metaCRSTestCmd.parseArgs(stringArray);
        try {
            metaCRSTestCmd.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String usage() {
        return "Usage: MetaCRSTestCmd [-verbose] { <test-file-name> }";
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.err.println(MetaCRSTestCmd.usage());
            System.exit(1);
        }
        this.parseFlags(stringArray);
        this.parseFiles(stringArray);
    }

    private void parseFlags(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.startsWith("-") || !string.equalsIgnoreCase("-verbose")) continue;
            this.verbose = true;
        }
    }

    private void parseFiles(String[] stringArray) {
        for (String string : stringArray) {
            if (string.startsWith("-")) continue;
            this.filenames.add(string);
        }
    }

    private void execute() throws IOException {
        long l = System.currentTimeMillis();
        for (String string : this.filenames) {
            this.execute(string);
        }
        System.out.println();
        System.out.println("Tests run: " + this.count + ",  Failures: " + this.failCount + ",  Errors: " + this.errCount);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Time: " + (double)l2 / 1000.0 + " s");
    }

    private void execute(String string) throws IOException {
        System.out.println("File: " + string);
        File file = new File(string);
        MetaCRSTestFileReader metaCRSTestFileReader = new MetaCRSTestFileReader(file);
        List<MetaCRSTestCase> list = metaCRSTestFileReader.readTests();
        for (MetaCRSTestCase metaCRSTestCase : list) {
            boolean bl;
            metaCRSTestCase.setCache(this.crsCache);
            ++this.count;
            System.out.print(".");
            try {
                bl = metaCRSTestCase.execute(csFactory);
            }
            catch (Proj4jException proj4jException) {
                System.out.println(proj4jException);
                ++this.errCount;
                continue;
            }
            if (!bl) {
                ++this.failCount;
                System.out.print("F");
            }
            if (this.verbose || !bl) {
                System.out.println();
                metaCRSTestCase.print(System.out);
            }
            if (this.count % 50 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }
}

