/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymmetryAction
extends JosmAction {
    public SymmetryAction() {
        super(I18n.tr((String)"Symmetry"), "symmetry", I18n.tr((String)"Mirror selected nodes and ways."), Shortcut.registerShortcut((String)"tools:symmetry", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Symmetry")}), (int)83, (int)3, (int)576), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/Symmtry"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection sel = SymmetryAction.getCurrentDataSet().getSelected();
        HashSet<Node> nodes = new HashSet<Node>();
        EastNorth p1 = null;
        EastNorth p2 = null;
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Node)) continue;
            if (p1 == null) {
                p1 = ((Node)osm).getEastNorth();
                continue;
            }
            if (p2 == null) {
                p2 = ((Node)osm).getEastNorth();
                continue;
            }
            nodes.add((Node)osm);
        }
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Way)) continue;
            nodes.addAll(((Way)osm).getNodes());
        }
        if (p1 == null || p2 == null || nodes.size() < 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select at least two nodes for symmetry axis and something else to mirror."), I18n.tr((String)"Information"), 1);
            return;
        }
        double e0 = p1.east();
        double n0 = p1.north();
        double ne = -(p2.north() - p1.north());
        double nn = p2.east() - p1.east();
        double l = Math.hypot(ne, nn);
        ne /= l;
        nn /= l;
        LinkedList<MoveCommand> cmds = new LinkedList<MoveCommand>();
        for (Node n : nodes) {
            EastNorth c = n.getEastNorth();
            double pr = (c.east() - e0) * ne + (c.north() - n0) * nn;
            cmds.add(new MoveCommand((OsmPrimitive)n, -2.0 * ne * pr, -2.0 * nn * pr));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Symmetry"), cmds));
        Main.map.repaint();
    }

    protected void updateEnabledState() {
        if (SymmetryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(SymmetryAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

