/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.infomode;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

class InfoMode
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private MapView mv;
    private String statusText;
    private boolean drawing;
    private boolean ctrl;
    private boolean shift;
    private boolean oldCtrl;
    private boolean oldShift;
    private EastNorth pos;
    DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());

    InfoMode(MapFrame mapFrame) {
        super(I18n.tr((String)"InfoMode"), "infomode.png", I18n.tr((String)"GPX info mode"), Shortcut.registerShortcut((String)"mapmode/infomode", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"GPX info mode")}), (int)92, (int)3), mapFrame, Cursor.getPredefinedCursor(0));
    }

    public void enterMode() {
        System.out.println("entering mode");
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        System.out.println("enter mode");
        this.mv = Main.map.mapView;
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        System.out.println("exit mode");
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return true;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        Layer l = Main.main.getActiveLayer();
        if (l instanceof GpxLayer && this.pos != null) {
            GpxLayer gpxL = (GpxLayer)l;
            double minDist = 1.0E9;
            double len = 0.0;
            WayPoint wp = null;
            GpxTrack trk = null;
            for (GpxTrack track : gpxL.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint S : seg.getWayPoints()) {
                        double d = S.getEastNorth().distance(this.pos);
                        if (d < minDist && d < 10.0) {
                            minDist = d;
                            wp = S;
                            trk = track;
                        }
                        if (track != trk) continue;
                        len += seg.length();
                    }
                }
            }
            if (wp != null) {
                Point p = mv.getPoint(wp.getCoor());
                g.setColor(Color.RED);
                g.fillOval(p.x - 10, p.y - 10, 20, 20);
                p.translate(20, 5);
                g.setColor(Color.WHITE);
                g.fillRoundRect(p.x, p.y - 25, 200, 50, 10, 10);
                g.setColor(Color.BLACK);
                g.drawString(this.df.format(wp.getTime()), p.x + 5, p.y - 10);
                String s = (String)trk.getAttributes().get("name");
                if (s != null) {
                    g.drawString(s, p.x + 5, p.y + 5);
                }
                System.out.println(trk.getAttributes().toString());
                System.out.println(wp.attr.toString());
                s = (String)wp.attr.get("ele");
                String s1 = null;
                try {
                    s1 = String.format("%3.1f", Double.parseDouble(s));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (s1 != null) {
                    g.drawString("H=" + s1, p.x + 5, p.y + 20);
                }
            }
        }
    }

    public void eventDispatched(AWTEvent event) {
        this.updateKeyModifiers((InputEvent)event);
        if (event.getID() == 401) {
            this.doKeyEvent((KeyEvent)event);
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.pos = this.mv.getEastNorth(e.getX(), e.getY());
        this.repaint();
    }

    private void doKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            // empty if block
        }
    }

    private void updateKeyModifiers(InputEvent e) {
        this.oldCtrl = this.ctrl;
        this.oldShift = this.shift;
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.statusText);
        Main.map.statusLine.repaint();
    }

    private void repaint() {
        Main.map.mapView.repaint();
    }

    private void setStatusLine(String tr) {
        this.statusText = tr;
        this.updateStatusLine();
    }
}

