/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.tools.I18n;

public class FastDrawConfigDialog
extends ExtendedDialog {
    public FastDrawConfigDialog(FDSettings settings) {
        super(Main.parent, I18n.tr((String)"FastDraw configuration"), new String[]{I18n.tr((String)"Ok"), I18n.tr((String)"Cancel")});
        JPanel all = new JPanel();
        GroupLayout layout = new GroupLayout(all);
        all.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JLabel label1 = new JLabel(I18n.tr((String)"Epsilon multiplier"));
        JLabel label2 = new JLabel(I18n.tr((String)"Starting Epsilon"));
        JLabel label3 = new JLabel(I18n.tr((String)"Max points count per 1 km"));
        JFormattedTextField text1 = new JFormattedTextField(NumberFormat.getInstance());
        JFormattedTextField text2 = new JFormattedTextField(NumberFormat.getInstance());
        JFormattedTextField text3 = new JFormattedTextField(NumberFormat.getInstance());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label1).addComponent(label2).addComponent(label3)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(text1).addComponent(text2).addComponent(text3)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label1).addComponent(text1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label2).addComponent(text2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label3).addComponent(text3)));
        text1.setValue(settings.epsilonMult);
        text2.setValue(settings.startingEps);
        text3.setValue(settings.maxPointsPerKm);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"FastDraw settings"), new String[]{I18n.tr((String)"Ok"), I18n.tr((String)"Cancel")});
        this.setContent(all, false);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setToolTipTexts(new String[]{I18n.tr((String)"Save settings"), I18n.tr((String)"Cancel")});
        this.setDefaultButton(1);
        this.showDialog();
        if (dialog.getValue() == 0) {
            try {
                settings.epsilonMult = NumberFormat.getInstance().parse(text1.getText()).doubleValue();
                settings.startingEps = NumberFormat.getInstance().parse(text2.getText()).doubleValue();
                settings.maxPointsPerKm = NumberFormat.getInstance().parse(text3.getText()).doubleValue();
                settings.savePrefs();
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can not read settings"));
            }
        }
    }
}

