/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.Messages;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoySaw
extends Buoy {
    public BuoySaw(SmpDialogAction dia, Node node) {
        super(dia);
        Map keys = node.getKeys();
        this.setNode(node);
        this.resetMask();
        this.dlg.cbM01TypeOfMark.setSelectedIndex(3);
        this.dlg.cbM01StyleOfMark.removeAllItems();
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.01"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.04"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.08"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.05"));
        this.dlg.cbM01StyleOfMark.addItem(Messages.getString("Buoy.07"));
        this.dlg.cbM01StyleOfMark.setVisible(true);
        this.dlg.lM01StyleOfMark.setVisible(true);
        this.setBuoyIndex(3);
        this.setColour(5);
        this.setLightColour("W");
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:longname")) {
            this.setLongname((String)keys.get("seamark:longname"));
        }
        if (keys.containsKey("seamark:fixme")) {
            this.setFixme((String)keys.get("seamark:fixme"));
        }
        if (keys.containsKey("seamark:buoy_safe_water:name")) {
            this.setName((String)keys.get("seamark:buoy_safe_water:name"));
        } else if (keys.containsKey("seamark:beacon_safe_water:name")) {
            this.setName((String)keys.get("seamark:beacon_safe_water:name"));
        } else if (keys.containsKey("seamark:light_float:name")) {
            this.setName((String)keys.get("seamark:light_float:name"));
        }
        if (keys.containsKey("seamark:buoy_safe_water:shape")) {
            String str = (String)keys.get("seamark:buoy_safe_water:shape");
            if (str.equals("pillar")) {
                this.setStyleIndex(1);
            } else if (str.equals("spar")) {
                this.setStyleIndex(2);
            } else if (str.equals("spherical")) {
                this.setStyleIndex(3);
            }
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("light_float")) {
            this.setStyleIndex(5);
        } else if (keys.containsKey("seamark:type") && ((String)keys.get("seamark:type")).equals("beacon_safe_water")) {
            this.setStyleIndex(4);
        }
        if (this.getStyleIndex() >= this.dlg.cbM01StyleOfMark.getItemCount()) {
            this.setStyleIndex(0);
        }
        if (keys.containsKey("seamark:topmark:shape") || keys.containsKey("seamark:topmark:colour")) {
            this.setTopMark(true);
        }
        this.refreshLights();
        this.parseLights(keys);
        this.parseFogRadar(keys);
        this.dlg.cbM01StyleOfMark.setSelectedIndex(this.getStyleIndex());
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01TopMark.setSelected(this.hasTopMark());
    }

    public void refreshLights() {
        this.dlg.cbM01Kennung.removeAllItems();
        this.dlg.cbM01Kennung.addItem(Messages.getString("SmpDialogAction.212"));
        this.dlg.cbM01Kennung.addItem("Iso");
        this.dlg.cbM01Kennung.addItem("Oc");
        this.dlg.cbM01Kennung.addItem("LFl");
        this.dlg.cbM01Kennung.addItem("Mo");
        this.dlg.cbM01Kennung.setSelectedIndex(0);
    }

    public boolean isValid() {
        return this.getBuoyIndex() > 0 && this.getStyleIndex() > 0;
    }

    public void setLightColour() {
        super.setLightColour("W");
    }

    public void paintSign() {
        if (this.dlg.paintlock) {
            return;
        }
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        if (this.isValid()) {
            this.dlg.tfM01Name.setEnabled(true);
            this.dlg.tfM01Name.setText(this.getName());
            this.dlg.cM01TopMark.setEnabled(true);
            this.dlg.cM01TopMark.setVisible(true);
            this.dlg.cM01Radar.setVisible(true);
            this.dlg.cM01Racon.setVisible(true);
            this.dlg.cM01Fog.setVisible(true);
            this.dlg.cM01Fired.setVisible(true);
            this.dlg.cM01Fired.setEnabled(true);
            if (!this.isSectored()) {
                this.dlg.cbM01Colour.setVisible(false);
                this.dlg.lM01Colour.setVisible(false);
            }
            this.dlg.rbM01Fired1.setVisible(false);
            this.dlg.rbM01FiredN.setVisible(false);
            this.dlg.lM01Height.setVisible(false);
            this.dlg.tfM01Height.setVisible(false);
            this.dlg.lM01Range.setVisible(false);
            this.dlg.tfM01Range.setVisible(false);
            if (this.isFired()) {
                switch (this.getStyleIndex()) {
                    case 4: 
                    case 5: {
                        this.dlg.lM01Height.setVisible(true);
                        this.dlg.tfM01Height.setVisible(true);
                        this.dlg.lM01Range.setVisible(true);
                        this.dlg.tfM01Range.setVisible(true);
                        break;
                    }
                }
            }
            String image = "/images/Safe_Water";
            switch (this.getStyleIndex()) {
                case 1: {
                    image = image + "_Pillar";
                    break;
                }
                case 2: {
                    image = image + "_Spar";
                    break;
                }
                case 3: {
                    image = image + "_Sphere";
                    break;
                }
                case 4: {
                    image = image + "_Beacon";
                    break;
                }
                case 5: {
                    image = image + "_Float";
                    break;
                }
            }
            if (!image.equals("/images/Safe_Water")) {
                image = image + ".png";
                this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
                if (this.hasTopMark()) {
                    image = "";
                    switch (this.getStyleIndex()) {
                        case 1: 
                        case 2: {
                            image = "/images/Top_Sphere_Red_Buoy.png";
                            break;
                        }
                        case 3: {
                            image = "/images/Top_Sphere_Red_Buoy_Small.png";
                            break;
                        }
                        case 4: {
                            image = "/images/Top_Sphere_Red_Beacon.png";
                            break;
                        }
                        case 5: {
                            image = "/images/Top_Sphere_Red_Float.png";
                        }
                    }
                    if (!image.isEmpty()) {
                        this.dlg.lM06Icon.setIcon(new ImageIcon(this.getClass().getResource(image)));
                    }
                }
            } else {
                this.dlg.lM01Icon.setIcon(null);
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getStyleIndex()) {
            case 1: {
                super.saveSign("buoy_safe_water");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:shape", "pillar"));
                break;
            }
            case 2: {
                super.saveSign("buoy_safe_water");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:shape", "spar"));
                break;
            }
            case 3: {
                super.saveSign("buoy_safe_water");
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:shape", "spherical"));
                break;
            }
            case 4: {
                super.saveSign("beacon_safe_water");
                break;
            }
            case 5: {
                super.saveSign("light_float");
                break;
            }
        }
        switch (this.getStyleIndex()) {
            case 1: 
            case 2: 
            case 3: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:colour_pattern", "vertical stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:buoy_safe_water:colour", "red;white"));
                break;
            }
            case 4: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_safe_water:colour_pattern", "vertical stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:beacon_safe_water:colour", "red;white"));
                break;
            }
            case 5: {
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour_pattern", "vertical stripes"));
                Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:light_float:colour", "red;white"));
                break;
            }
        }
        this.saveTopMarkData("sphere", "red");
        this.saveLightData();
        this.saveRadarFogData();
    }
}

