/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PasteTagsAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.fastdraw.DrawnPolyLine;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.plugins.fastdraw.FastDrawConfigDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

class FastDrawingMode
extends MapMode
implements MapViewPaintable,
AWTEventListener {
    private static final String SIMPLIFYMODE_MESSAGE = I18n.tr((String)"Press Enter to simplify or save, Ctrl-Enter to save with tags, Up/Down to tune simplification");
    private static final String DRAWINGMODE_MESSAGE = I18n.tr((String)"Click or Click&drag to continue, Ctrl-Click to add fixed node, Shift-Click to delete, Enter to simplify or save, Ctrl-Shift-Click to start new line");
    private FDSettings settings;
    private DrawnPolyLine line = new DrawnPolyLine();
    private MapView mv;
    private String statusText;
    private boolean drawing;
    private boolean ctrl;
    private boolean shift;
    private boolean oldCtrl;
    private boolean oldShift;
    private double eps;
    private final Stroke strokeForSimplified;
    private final Stroke strokeForOriginal = new BasicStroke();
    private final Cursor cursorDraw;
    private final Cursor cursorCtrl;
    private final Cursor cursorShift;
    private final Cursor cursorReady;
    private final Cursor cursorNode;
    private boolean nearpoint;
    private LatLon highlighted;
    private int nearestIdx;
    private Stroke strokeForDelete = new BasicStroke(3.0f);
    private int dragNode = -1;

    FastDrawingMode(MapFrame mapFrame) {
        super(I18n.tr((String)"FastDrawing"), "turbopen.png", I18n.tr((String)"Fast drawing mode"), Shortcut.registerShortcut((String)"mapmode/building", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Fast drawing mode")}), (int)84, (int)3), mapFrame, Cursor.getPredefinedCursor(0));
        this.strokeForSimplified = new BasicStroke(1.0f, 1, 2, 5.0f, new float[]{5.0f, 5.0f}, 0.0f);
        this.cursorDraw = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorCtrl = ImageProvider.getCursor((String)"crosshair", (String)"fixed");
        this.cursorShift = ImageProvider.getCursor((String)"crosshair", (String)"new");
        this.cursorReady = ImageProvider.getCursor((String)"crosshair", (String)"ready");
        this.cursorNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.settings = new FDSettings();
        this.settings.loadPrefs();
        this.settings.savePrefs();
        this.eps = this.settings.startingEps;
        this.mv = Main.map.mapView;
        this.line.setMv(this.mv);
        if (FastDrawingMode.getCurrentDataSet() == null) {
            return;
        }
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        Main.map.mapView.setCursor(this.cursorDraw);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.settings.savePrefs();
        Main.map.mapView.setCursor(this.cursorDraw);
        this.repaint();
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(FastDrawingMode.getEditLayer() != null);
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        LinkedList<LatLon> pts = this.line.getPoints();
        if (pts.isEmpty()) {
            return;
        }
        if (this.line.wasSimplified()) {
            g.setStroke(this.strokeForSimplified);
        } else {
            g.setStroke(this.strokeForOriginal);
        }
        Point p1 = this.line.getPoint(pts.get(0));
        g.setColor(this.settings.COLOR_FIXED);
        g.fillOval(p1.x - 3, p1.y - 3, 7, 7);
        Color lineColor = this.settings.COLOR_NORMAL;
        if (pts.size() > 1) {
            ListIterator<LatLon> it1 = pts.listIterator(0);
            ListIterator<LatLon> it2 = pts.listIterator(1);
            for (int i = 0; i < pts.size() - 1; ++i) {
                LatLon pp1 = (LatLon)it1.next();
                p1 = this.line.getPoint(pp1);
                LatLon pp2 = (LatLon)it2.next();
                Point p2 = this.line.getPoint(pp2);
                if (this.shift && this.highlighted == pp1 && this.nearestIdx < 0) {
                    lineColor = this.settings.COLOR_SELECTEDFRAGMENT;
                }
                if (!this.shift && this.line.isLastPoint(i)) {
                    lineColor = this.settings.COLOR_EDITEDFRAGMENT;
                }
                g.setColor(lineColor);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                if (this.line.isFixed(pp2)) {
                    lineColor = this.settings.COLOR_NORMAL;
                    g.setColor(this.settings.COLOR_FIXED);
                    g.fillOval(p2.x - 3, p2.y - 3, 7, 7);
                } else {
                    g.fillRect(p2.x - 1, p2.y - 1, 3, 3);
                }
                if (this.drawing) continue;
                if (this.shift && !this.line.wasSimplified() && this.nearestIdx == i + 1) {
                    g.setStroke(this.strokeForDelete);
                    g.setColor(this.settings.COLOR_DELETE);
                    g.drawLine(p2.x - 5, p2.y - 5, p2.x + 5, p2.y + 5);
                    g.drawLine(p2.x - 5, p2.y + 5, p2.x + 5, p2.y - 5);
                    g.setStroke(this.strokeForOriginal);
                }
                if (!this.ctrl || this.line.wasSimplified() || this.nearestIdx != i + 1) continue;
                g.setStroke(this.strokeForDelete);
                g.setColor(this.line.isFixed(pp2) ? this.settings.COLOR_NORMAL : this.settings.COLOR_FIXED);
                g.drawOval(p2.x - 5, p2.y - 5, 11, 11);
                g.setStroke(this.strokeForOriginal);
            }
        }
    }

    public void eventDispatched(AWTEvent event) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)event);
        if (event.getID() == 401) {
            this.doKeyEvent((KeyEvent)event);
        }
        this.updateCursor();
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        int idx = this.line.findClosestPoint(e.getPoint(), this.settings.maxDist);
        if (idx == 0 && !this.line.isClosed()) {
            this.line.closeLine();
            this.drawing = false;
            this.dragNode = 0;
            this.updateCursor();
            return;
        }
        if (this.ctrl && this.shift) {
            this.newDrawing();
            this.repaint();
            return;
        }
        if (!this.ctrl && this.shift) {
            if (idx >= 0) {
                this.line.deleteNode(idx);
                this.nearestIdx = -1;
            } else {
                this.line.tryToDeleteSegment(e.getPoint());
            }
            return;
        }
        if (idx >= 0) {
            if (this.ctrl) {
                this.line.toggleFixed(idx);
            }
            this.dragNode = idx;
            return;
        }
        this.drawing = true;
        LatLon p = this.getLatLon(e);
        Node nd1 = this.getNearestNode(e.getPoint(), this.settings.maxDist);
        if (nd1 != null) {
            p = nd1.getCoor();
            this.line.fixPoint(p);
        }
        this.line.addLast(p);
        if (this.ctrl) {
            this.line.fixPoint(p);
        }
        this.line.clearSimplifiedVersion();
        this.setStatusLine(I18n.tr((String)"Please move the mouse to draw new way"));
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.dragNode = -1;
        this.drawing = false;
        this.highlighted = null;
        if (!this.line.isClosed()) {
            this.setStatusLine(DRAWINGMODE_MESSAGE);
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        boolean nearpoint2;
        if (!this.isEnabled()) {
            return;
        }
        Node nd1 = this.getNearestNode(e.getPoint(), this.settings.maxDist);
        boolean bl = nearpoint2 = nd1 != null;
        if (this.nearpoint != nearpoint2) {
            this.nearpoint = nearpoint2;
            this.updateCursor();
        }
        this.nearestIdx = this.line.findClosestPoint(e.getPoint(), this.settings.maxDist);
        if (!this.drawing) {
            LatLon h2;
            if (this.dragNode >= 0) {
                this.line.moveNode(this.dragNode, this.getLatLon(e));
                this.repaint();
                return;
            }
            if (this.shift && this.highlighted != (h2 = this.line.findBigSegment(e.getPoint()))) {
                this.highlighted = h2;
                this.repaint();
            }
            return;
        }
        if (this.line.isClosed()) {
            this.setStatusLine(SIMPLIFYMODE_MESSAGE);
        }
        if (this.nearestIdx >= 0) {
            return;
        }
        Point lastP = this.line.getLastPoint();
        if (this.nearpoint) {
            if (Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > 0.01) {
                this.line.addFixed(nd1.getCoor());
                this.repaint();
            }
        } else if (Math.hypot(e.getX() - lastP.x, e.getY() - lastP.y) > this.settings.minPixelsBetweenPoints) {
            this.line.addLast(this.getLatLon(e));
            this.repaint();
        }
    }

    private void doKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            if (this.line.wasSimplified()) {
                this.line.clearSimplifiedVersion();
                this.repaint();
                this.eps = this.settings.startingEps;
            }
            this.back();
        }
        if (e.getKeyCode() == 10) {
            if (!this.line.wasSimplified()) {
                this.eps = this.line.autoSimplify(this.settings.startingEps, this.settings.epsilonMult, this.settings.maxPointsPerKm);
                this.repaint();
                this.showSimplifyHint();
            } else {
                this.saveAsWay();
            }
        }
        if (e.getKeyCode() == 40) {
            e.consume();
            this.changeEpsilon(this.settings.epsilonMult);
        }
        if (e.getKeyCode() == 38) {
            e.consume();
            this.changeEpsilon(1.0 / this.settings.epsilonMult);
        }
        if (e.getKeyCode() == 27) {
            e.consume();
            this.line.moveToTheEnd();
        }
        if (e.getKeyCode() == 81) {
            e.consume();
            try {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                new FastDrawConfigDialog(this.settings);
                this.eps = this.line.autoSimplify(this.settings.startingEps, this.settings.epsilonMult, this.settings.maxPointsPerKm);
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.repaint();
        }
    }

    private void updateKeyModifiers(InputEvent e) {
        this.oldCtrl = this.ctrl;
        this.oldShift = this.shift;
        this.ctrl = (e.getModifiers() & 2) != 0;
        this.shift = (e.getModifiers() & 1) != 0;
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.statusText);
        Main.map.statusLine.repaint();
    }

    public void newDrawing() {
        this.eps = this.settings.startingEps;
        this.line.clear();
    }

    private void saveAsWay() {
        LinkedList<LatLon> pts = this.line.getPoints();
        int n = pts.size();
        if (n == 0) {
            return;
        }
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        int i = 0;
        Way w = new Way();
        LatLon first = (LatLon)pts.get(0);
        Node firstNode = null;
        for (LatLon p : pts) {
            Node nd = null;
            if (this.line.isFixed(p)) {
                nd = Main.map.mapView.getNearestNode(this.line.getPoint(p), OsmPrimitive.isUsablePredicate);
            }
            if (nd == null) {
                if (i > 0 && p.equals((Object)first)) {
                    nd = firstNode;
                } else {
                    nd = new Node(p);
                    cmds.add(new AddCommand((OsmPrimitive)nd));
                }
            }
            if (nd.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot place node outside of the world."));
                return;
            }
            if (i == 0) {
                firstNode = nd;
            }
            w.addNode(nd);
            ++i;
        }
        if (this.ctrl) {
            HashSet<Way> ts = new HashSet<Way>();
            ts.add(w);
            PasteTagsAction.TagPaster tp = new PasteTagsAction.TagPaster((Collection)Main.pasteBuffer.getDirectlyAdded(), ts);
            List execute = tp.execute();
            HashMap tgs = new HashMap();
            for (Tag t : execute) {
                w.put(t.getKey(), t.getValue());
            }
        }
        cmds.add(new AddCommand((OsmPrimitive)w));
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Draw the way by mouse"), cmds);
        Main.main.undoRedo.add((Command)c);
        this.newDrawing();
        this.exitMode();
        FastDrawingMode.getCurrentDataSet().setSelected(new PrimitiveId[]{w});
        Main.map.selectSelectTool(false);
    }

    private void repaint() {
        Main.map.mapView.repaint();
    }

    public void back() {
        this.line.undo();
        this.repaint();
    }

    void changeEpsilon(double k) {
        this.eps *= k;
        this.line.simplify(this.eps);
        this.showSimplifyHint();
        this.repaint();
    }

    private void setStatusLine(String tr) {
        this.statusText = tr;
        this.updateStatusLine();
    }

    private void updateCursor() {
        if (this.shift) {
            Main.map.mapView.setCursor(this.cursorShift);
        } else if (this.line.isClosed()) {
            Main.map.mapView.setCursor(this.cursorReady);
        } else if (this.ctrl) {
            Main.map.mapView.setCursor(this.cursorCtrl);
        } else if (this.nearpoint) {
            Main.map.mapView.setCursor(this.cursorCtrl);
        } else {
            Main.map.mapView.setCursor(this.cursorDraw);
        }
    }

    private Node getNearestNode(Point point, double maxDist) {
        Node nd = Main.map.mapView.getNearestNode(point, OsmPrimitive.isUsablePredicate);
        if (nd != null && this.line.getPoint(nd.getCoor()).distance(point) <= maxDist) {
            return nd;
        }
        return null;
    }

    LatLon getLatLon(MouseEvent e) {
        return this.mv.getLatLon(e.getX(), e.getY());
    }

    private void showSimplifyHint() {
        this.setStatusLine(I18n.tr((String)"Eps={0}, {1} points, {2} p/km", (Object[])new Object[]{this.eps, this.line.getSimplePointsCount(), this.line.getNodesPerKm()}) + " " + SIMPLIFYMODE_MESSAGE);
    }
}

