/*
 * Decompiled with CFR 0.152.
 */
package utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import utilsplugin2.selection.NodeWayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjacentNodesAction
extends JosmAction {
    public static final boolean treeMode = false;
    private Set<Way> activeWays = new HashSet<Way>();

    public AdjacentNodesAction() {
        super(I18n.tr((String)"Adjacent nodes"), "adjnodes", I18n.tr((String)"Select adjacent nodes"), Shortcut.registerShortcut((String)"tools:adjnodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Adjacent nodes"}), (int)69, (int)3), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/AdjacentNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = AdjacentNodesAction.getCurrentDataSet().getSelected();
        LinkedHashSet selectedNodes = OsmPrimitive.getFilteredSet((Collection)selection, Node.class);
        LinkedHashSet selectedWays = OsmPrimitive.getFilteredSet((Collection)AdjacentNodesAction.getCurrentDataSet().getSelected(), Way.class);
        if (selectedNodes.isEmpty() && selectedWays.isEmpty()) {
            return;
        }
        if (selectedWays.isEmpty()) {
            if (selectedNodes.size() == 1) {
                this.activeWays.clear();
            }
        } else {
            this.activeWays = selectedWays;
        }
        if (selectedNodes.isEmpty()) {
            HashSet<Node> newNodes = new HashSet<Node>();
            NodeWayUtils.addNodesConnectedToWays(selectedWays, newNodes);
            this.activeWays.clear();
            AdjacentNodesAction.getCurrentDataSet().setSelected(newNodes);
            return;
        }
        if (this.activeWays.isEmpty()) {
            NodeWayUtils.addWaysConnectedToNodes(selectedNodes, this.activeWays);
        }
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node : selectedNodes) {
            for (Way w : this.activeWays) {
                NodeWayUtils.addNeighbours(w, node, newNodes);
            }
        }
        newNodes.removeAll(selectedNodes);
        if (newNodes.isEmpty()) {
            this.activeWays.clear();
        }
        AdjacentNodesAction.getCurrentDataSet().addSelected(newNodes);
        newNodes = null;
    }

    protected void updateEnabledState() {
        if (AdjacentNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(AdjacentNodesAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

