/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;
import relcontext.actions.SortAndFixAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemoveMemberAction
extends JosmAction
implements ChosenRelationListener {
    private static final String ACTION_NAME = "Add/remove member";
    private ChosenRelation rel;

    public AddRemoveMemberAction(ChosenRelation rel) {
        super(null, "relcontext/addremove", I18n.tr((String)"Add/remove members from the chosen relation"), Shortcut.registerShortcut((String)"reltoolbox:addremove", (String)I18n.tr((String)"Relation Toolbox: {0}", (Object[])new Object[]{I18n.tr((String)"Add/remove members from the chosen relation")}), (int)61, (int)3), true);
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent e) {
        Command roleFix;
        if (this.rel.get() == null) {
            return;
        }
        Relation r = new Relation(this.rel.get());
        ArrayList toAdd = new ArrayList(AddRemoveMemberAction.getCurrentDataSet().getSelected());
        toAdd.remove(this.rel.get());
        toAdd.removeAll(r.getMemberPrimitives());
        boolean isBroken = !toAdd.isEmpty() && SortAndFixAction.needsFixing(r);
        r.removeMembersFor(AddRemoveMemberAction.getCurrentDataSet().getSelected());
        for (OsmPrimitive p : toAdd) {
            int pos = -1;
            if (pos < 0) {
                r.addMember(new RelationMember("", p));
                continue;
            }
            r.addMember(pos, new RelationMember("", p));
        }
        Command command = roleFix = !isBroken && SortAndFixAction.needsFixing(r) ? SortAndFixAction.fixRelation(r) : null;
        if (roleFix != null) {
            roleFix.executeCommand();
        }
        if (!((Object)r.getMemberPrimitives()).equals(this.rel.get().getMemberPrimitives())) {
            Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)this.rel.get(), (OsmPrimitive)r));
        }
    }

    protected int findAdjacentMember(Way w, Relation r) {
        Node firstNode = w.firstNode();
        Node lastNode = w.lastNode();
        if (firstNode != null && !firstNode.equals((Object)lastNode)) {
            for (int i = 0; i < r.getMembersCount(); ++i) {
                if (!r.getMember(i).getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                Way rw = (Way)r.getMember(i).getMember();
                Node firstNodeR = rw.firstNode();
                Node lastNodeR = rw.lastNode();
                if (!firstNode.equals((Object)firstNodeR) && !firstNode.equals((Object)lastNodeR) && !lastNode.equals((Object)firstNodeR) && !lastNode.equals((Object)lastNodeR)) continue;
                return i + 1;
            }
        }
        return -1;
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        this.updateEnabledState(AddRemoveMemberAction.getCurrentDataSet() == null ? null : AddRemoveMemberAction.getCurrentDataSet().getSelected());
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateIcon();
        if (this.rel == null || this.rel.get() == null || selection == null || selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        if (selection.size() == 1 && selection.contains(this.rel.get())) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    protected void updateIcon() {
        int state = 0;
        if (AddRemoveMemberAction.getCurrentDataSet() == null || AddRemoveMemberAction.getCurrentDataSet().getSelected() == null || AddRemoveMemberAction.getCurrentDataSet().getSelected().isEmpty() || this.rel == null || this.rel.get() == null) {
            state = 0;
        } else {
            ArrayList toAdd = new ArrayList(AddRemoveMemberAction.getCurrentDataSet().getSelected());
            toAdd.remove(this.rel.get());
            int selectedSize = toAdd.size();
            if (selectedSize == 0) {
                state = 0;
            } else {
                toAdd.removeAll(this.rel.get().getMemberPrimitives());
                state = toAdd.isEmpty() ? 2 : (toAdd.size() < selectedSize ? 3 : 1);
            }
        }
        if (state == 0) {
            this.putValue("SmallIcon", ImageProvider.get((String)"relcontext", (String)"addremove"));
        } else {
            String iconName = state == 1 ? "add" : (state == 2 ? "remove" : "addremove");
            this.putValue("Name", null);
            this.putValue("SmallIcon", ImageProvider.get((String)"relcontext", (String)iconName));
        }
    }
}

