/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.events;

import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.media_player_length_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_pausable_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_position_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_seekable_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_snapshot_taken;
import uk.co.caprica.vlcj.binding.internal.media_player_time_changed;
import uk.co.caprica.vlcj.binding.internal.media_player_title_changed;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.events.AbstractMediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerBackwardEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerBufferingEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEncounteredErrorEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEndReachedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerForwardEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerLengthChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerMediaChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerNothingSpecialEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerOpeningEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPausableChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPausedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPlayingEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerPositionChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerSeekableChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerSnapshotTakenEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerStoppedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerTimeChangedEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerTitleChangedEvent;

public class MediaPlayerEventFactory {
    private final MediaPlayer mediaPlayer;

    public MediaPlayerEventFactory(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    public MediaPlayerEvent newMediaPlayerEvent(libvlc_event_t event) {
        AbstractMediaPlayerEvent result = null;
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaPlayerMediaChanged: {
                result = new MediaPlayerMediaChangedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerNothingSpecial: {
                result = new MediaPlayerNothingSpecialEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerOpening: {
                result = new MediaPlayerOpeningEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerBuffering: {
                result = new MediaPlayerBufferingEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerPlaying: {
                result = new MediaPlayerPlayingEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerPaused: {
                result = new MediaPlayerPausedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerStopped: {
                result = new MediaPlayerStoppedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerForward: {
                result = new MediaPlayerForwardEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerBackward: {
                result = new MediaPlayerBackwardEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerEndReached: {
                result = new MediaPlayerEndReachedEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerEncounteredError: {
                result = new MediaPlayerEncounteredErrorEvent(this.mediaPlayer);
                break;
            }
            case libvlc_MediaPlayerTimeChanged: {
                result = new MediaPlayerTimeChangedEvent(this.mediaPlayer, ((media_player_time_changed)event.u.getTypedValue(media_player_time_changed.class)).new_time);
                break;
            }
            case libvlc_MediaPlayerPositionChanged: {
                result = new MediaPlayerPositionChangedEvent(this.mediaPlayer, ((media_player_position_changed)event.u.getTypedValue(media_player_position_changed.class)).new_position);
                break;
            }
            case libvlc_MediaPlayerSeekableChanged: {
                result = new MediaPlayerSeekableChangedEvent(this.mediaPlayer, ((media_player_seekable_changed)event.u.getTypedValue(media_player_seekable_changed.class)).new_seekable);
                break;
            }
            case libvlc_MediaPlayerPausableChanged: {
                result = new MediaPlayerPausableChangedEvent(this.mediaPlayer, ((media_player_pausable_changed)event.u.getTypedValue(media_player_pausable_changed.class)).new_pausable);
                break;
            }
            case libvlc_MediaPlayerTitleChanged: {
                result = new MediaPlayerTitleChangedEvent(this.mediaPlayer, ((media_player_title_changed)event.u.getTypedValue(media_player_title_changed.class)).new_title);
                break;
            }
            case libvlc_MediaPlayerSnapshotTaken: {
                result = new MediaPlayerSnapshotTakenEvent(this.mediaPlayer, ((media_player_snapshot_taken)event.u.getTypedValue(media_player_snapshot_taken.class)).filename);
                break;
            }
            case libvlc_MediaPlayerLengthChanged: {
                result = new MediaPlayerLengthChangedEvent(this.mediaPlayer, ((media_player_length_changed)event.u.getTypedValue(media_player_length_changed.class)).new_length);
            }
        }
        return result;
    }
}

