/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.LibVlcFactory;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.log.Log;
import uk.co.caprica.vlcj.log.LogLevel;
import uk.co.caprica.vlcj.log.Logger;
import uk.co.caprica.vlcj.player.AudioOutput;
import uk.co.caprica.vlcj.player.direct.DirectMediaPlayer;
import uk.co.caprica.vlcj.player.direct.RenderCallback;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.linux.LinuxEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.mac.MacEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.windows.WindowsEmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.headless.HeadlessMediaPlayer;
import uk.co.caprica.vlcj.player.list.MediaList;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaPlayerFactory {
    private final LibVlc libvlc;
    private libvlc_instance_t instance;
    private boolean released;

    public MediaPlayerFactory() {
        this(new String[0]);
    }

    public MediaPlayerFactory(String[] libvlcArgs) {
        this(libvlcArgs, LibVlcFactory.factory().synchronise().log().create());
    }

    public MediaPlayerFactory(LibVlc libvlc) {
        this(new String[0], libvlc);
    }

    public MediaPlayerFactory(String[] libvlcArgs, LibVlc libvlc) {
        Logger.debug("MediaPlayerFactory(libvlcArgs={},libvlc={})", Arrays.toString(libvlcArgs), libvlc);
        Logger.debug("jna.library.path={}", System.getProperty("jna.library.path"));
        for (String libvlcArg : libvlcArgs) {
            if (!libvlcArg.startsWith("--plugin-path=")) continue;
            Logger.debug(libvlcArg, new Object[0]);
        }
        this.libvlc = libvlc;
        this.instance = libvlc.libvlc_new(libvlcArgs.length, libvlcArgs);
        Logger.debug("instance={}", this.instance);
        if (this.instance == null) {
            Logger.error("Failed to initialise libvlc", new Object[0]);
            throw new IllegalStateException("Unable to initialise libvlc, check your libvlc options and/or check the console for error messages");
        }
    }

    public void setUserAgent(String userAgent) {
        Logger.debug("setUserAgent(userAgent={})", userAgent);
        this.setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, String httpUserAgent) {
        Logger.debug("setUserAgent(userAgent={},httpUserAgent={})", userAgent, httpUserAgent);
        this.libvlc.libvlc_set_user_agent(this.instance, userAgent, userAgent);
    }

    public int getLogVerbosity() {
        Logger.debug("getLogVerbosity()", new Object[0]);
        return this.libvlc.libvlc_get_log_verbosity(this.instance);
    }

    public void setLogLevel(LogLevel level) {
        Logger.debug("setLogVerbosity(level={})", new Object[]{level});
        this.libvlc.libvlc_set_log_verbosity(this.instance, level.intValue());
    }

    public List<AudioOutput> getAudioOutputs() {
        Logger.debug("getAudioOutputs()", new Object[0]);
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutput = this.libvlc.libvlc_audio_output_list_get(this.instance);
        while (audioOutput != null) {
            result.add(new AudioOutput(audioOutput.psz_name, audioOutput.psz_description));
            audioOutput = audioOutput.p_next;
        }
        this.libvlc.libvlc_audio_output_list_release(audioOutput);
        return result;
    }

    public void release() {
        Logger.debug("release()", new Object[0]);
        if (!this.released) {
            if (this.instance != null) {
                this.libvlc.libvlc_release(this.instance);
            }
            this.released = true;
        }
    }

    public EmbeddedMediaPlayer newMediaPlayer(FullScreenStrategy fullScreenStrategy) {
        EmbeddedMediaPlayer mediaPlayer;
        Logger.debug("newMediaPlayer(fullScreenStrategy={})", fullScreenStrategy);
        if (RuntimeUtil.isNix()) {
            mediaPlayer = new LinuxEmbeddedMediaPlayer(this.instance, fullScreenStrategy);
        } else if (RuntimeUtil.isWindows()) {
            mediaPlayer = new WindowsEmbeddedMediaPlayer(this.instance, fullScreenStrategy);
        } else if (RuntimeUtil.isMac()) {
            mediaPlayer = new MacEmbeddedMediaPlayer(this.instance, fullScreenStrategy);
        } else {
            throw new RuntimeException("Unable to create a media player - failed to detect a supported operating system");
        }
        Logger.debug("mediaPlayer={}", mediaPlayer);
        return mediaPlayer;
    }

    public DirectMediaPlayer newMediaPlayer(int width, int height, RenderCallback renderCallback) {
        Logger.debug("newMediaPlayer(width={},height={},renderCallback={})", width, height, renderCallback);
        DirectMediaPlayer mediaPlayer = new DirectMediaPlayer(this.instance, width, height, renderCallback);
        return mediaPlayer;
    }

    public HeadlessMediaPlayer newMediaPlayer() {
        Logger.debug("newMediaPlayer()", new Object[0]);
        HeadlessMediaPlayer mediaPlayer = new HeadlessMediaPlayer(this.instance);
        return mediaPlayer;
    }

    public MediaListPlayer newMediaListPlayer() {
        Logger.debug("newMediaListPlayer()", new Object[0]);
        MediaListPlayer mediaListPlayer = new MediaListPlayer(this.instance);
        return mediaListPlayer;
    }

    public MediaList newMediaList() {
        Logger.debug("newMediaList()", new Object[0]);
        MediaList mediaList = new MediaList(this.instance);
        return mediaList;
    }

    public Log newLog() {
        Logger.debug("newLog()", new Object[0]);
        Log log = new Log(this.libvlc, this.instance);
        log.open();
        return log;
    }
}

