/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import uk.co.caprica.vlcj.log.Log;
import uk.co.caprica.vlcj.log.LogMessage;
import uk.co.caprica.vlcj.log.LogMessageHandler;
import uk.co.caprica.vlcj.log.Logger;

public class LogHandler {
    private final Log log;
    private final int period;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final List<LogMessageHandler> logMessageHandlers = new ArrayList<LogMessageHandler>();

    public LogHandler(Log log, int period) {
        Logger.debug("LogHandler(log={},period={})", log, period);
        this.log = log;
        this.period = period;
    }

    public LogHandler addLogMessageHandler(LogMessageHandler logMessageHandler) {
        Logger.debug("addLogMessageHandler(logMessageHandler={})", logMessageHandler);
        this.logMessageHandlers.add(logMessageHandler);
        return this;
    }

    public void removeLogMessageHandler(LogMessageHandler logMessageHandler) {
        Logger.debug("removeLogMessageHandler(logMessageHandler={})", logMessageHandler);
        this.logMessageHandlers.remove(logMessageHandler);
    }

    public void start() {
        Logger.debug("start()", new Object[0]);
        this.executor.scheduleAtFixedRate(new LogProcessor(), this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public void release() {
        Logger.debug("release()", new Object[0]);
        this.executor.shutdownNow();
    }

    private final class LogProcessor
    implements Runnable {
        private LogProcessor() {
        }

        public void run() {
            Logger.trace("run()", new Object[0]);
            int count = LogHandler.this.log.count();
            Logger.trace("count={}", count);
            if (count > 0 && !LogHandler.this.logMessageHandlers.isEmpty()) {
                List<LogMessage> logMessages = LogHandler.this.log.messages();
                for (LogMessageHandler logMessageHandler : LogHandler.this.logMessageHandlers) {
                    logMessageHandler.messages(logMessages);
                }
            }
        }
    }
}

