/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.CacheFileLambert4ZoneFilter;
import cadastre_fr.CacheFileLambert9ZoneFilter;
import cadastre_fr.CacheFileUTM20NFilter;
import cadastre_fr.CadastrePlugin;
import cadastre_fr.WMSLayer;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.UTM_France_DOM;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionLoadFromCache
extends JosmAction {
    private static final long serialVersionUID = 1L;
    public static String name = "Load layer from cache";

    public MenuActionLoadFromCache() {
        super(I18n.tr((String)name), "cadastre_small", I18n.tr((String)"Load location from cache (only if cache is enabled)"), null, false);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = MenuActionLoadFromCache.createAndOpenFileChooser();
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        int layoutZone = this.getCurrentProjZone();
        block2: for (File file : files) {
            String location;
            String ext;
            String filename;
            block11: {
                if (!file.exists()) continue;
                filename = file.getName();
                String string = ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
                if (ext.length() == 3 && ext.substring(0, "CC".length()).equals("CC") && !(Main.getProjection() instanceof LambertCC9Zones) || ext.length() == 4 && ext.substring(0, "UTM".length()).equals("UTM") && !(Main.getProjection() instanceof UTM_France_DOM) || ext.length() == 1 && !(Main.getProjection() instanceof Lambert)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"{0} not allowed with the current projection", (Object[])new Object[]{filename}), I18n.tr((String)"Error"), 0);
                    continue;
                }
                location = filename.substring(0, filename.lastIndexOf("."));
                if (ext.length() == 3 && ext.substring(0, "CC".length()).equals("CC")) {
                    ext = ext.substring(2);
                } else if (ext.length() == 4 && ext.substring(0, "UTM".length()).equals("UTM")) {
                    ext = ext.substring(3);
                }
                try {
                    int cacheZone = Integer.parseInt(ext) - 1;
                    if (cacheZone < 0 || cacheZone > 9) break block11;
                    if (cacheZone != layoutZone) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Cannot load cache {0} which is not compatible with current projection zone", (Object[])new Object[]{filename}), I18n.tr((String)"Error"), 0);
                        continue;
                    }
                    System.out.println("Load cache " + filename);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Selected file {0} is not a cache file from this plugin (invalid extension)", (Object[])new Object[]{filename}), I18n.tr((String)"Error"), 0);
                    continue;
                }
            }
            if (Main.map != null) {
                for (Layer l : Main.map.mapView.getAllLayers()) {
                    if (!(l instanceof WMSLayer) || !l.getName().equals(location)) continue;
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The location {0} is already on screen. Cache not loaded.", (Object[])new Object[]{filename}), I18n.tr((String)"Error"), 0);
                    continue block2;
                }
            }
            WMSLayer wmsLayer = new WMSLayer("", "", Integer.parseInt(ext) - 1);
            if (!wmsLayer.grabThread.getCacheControl().loadCache(file, layoutZone)) continue;
            CadastrePlugin.addWMSLayer(wmsLayer);
        }
    }

    protected static JFileChooser createAndOpenFileChooser() {
        JFileChooser fc = new JFileChooser(new File(CadastrePlugin.cacheDir));
        fc.setMultiSelectionEnabled(true);
        int layoutZone = new MenuActionLoadFromCache().getCurrentProjZone();
        if (layoutZone != -1) {
            if (Main.getProjection() instanceof Lambert) {
                fc.addChoosableFileFilter(CacheFileLambert4ZoneFilter.filters[layoutZone]);
            } else if (Main.getProjection() instanceof LambertCC9Zones) {
                fc.addChoosableFileFilter(CacheFileLambert9ZoneFilter.filters[layoutZone]);
            } else if (Main.getProjection() instanceof UTM_France_DOM) {
                fc.addChoosableFileFilter(CacheFileUTM20NFilter.filters[layoutZone]);
            }
        }
        fc.setAcceptAllFileFilterUsed(false);
        int answer = fc.showOpenDialog(Main.parent);
        if (answer != 0) {
            return null;
        }
        return fc;
    }

    private int getCurrentProjZone() {
        int zone = -1;
        if (Main.getProjection() instanceof LambertCC9Zones) {
            zone = ((LambertCC9Zones)Main.getProjection()).getLayoutZone();
        } else if (Main.getProjection() instanceof Lambert) {
            zone = ((Lambert)Main.getProjection()).getLayoutZone();
        } else if (Main.getProjection() instanceof UTM_France_DOM) {
            zone = ((UTM_France_DOM)Main.getProjection()).getCurrentGeodesic();
        }
        return zone;
    }
}

