/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jsyntaxpane.DefaultSyntaxKit;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.plugins.scripting.ui.console.IScriptLog;
import org.openstreetmap.josm.plugins.scripting.ui.console.JOSMScriptContext;
import org.openstreetmap.josm.plugins.scripting.ui.console.MimeTypeToSyntaxKitMap;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptEditor;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptEditorModel;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptLogPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScriptingConsolePanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ScriptingConsolePanel.class.getName());
    private JSplitPane spConsole;
    private ScriptLogPanel log;
    private ScriptEditor editor;

    protected JPanel buildControlPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1, 0, 0));
        pnl.setBorder(null);
        pnl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        SideButton btn = new SideButton((Action)new RunScriptAction(this.editor.getModel()));
        pnl.add((Component)btn);
        return pnl;
    }

    protected JPanel buildInputPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.editor = new ScriptEditor();
        pnl.add((Component)this.editor, "Center");
        pnl.add((Component)this.buildControlPanel(), "South");
        return pnl;
    }

    protected JSplitPane buildSplitPane() {
        final JSplitPane sp = new JSplitPane(0);
        sp.setDividerSize(5);
        sp.setTopComponent(this.buildInputPanel());
        this.log = new ScriptLogPanel();
        sp.setBottomComponent(this.log);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sp.setDividerLocation(0.7);
            }
        });
        return sp;
    }

    protected void build() {
        DefaultSyntaxKit.initKit();
        this.spConsole = this.buildSplitPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.spConsole, "Center");
        this.editor.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals(ScriptEditorModel.PROP_SCRIPT_ENGINE_FACTORY)) {
                    return;
                }
                ScriptEngineFactory sef = (ScriptEngineFactory)evt.getNewValue();
                ScriptingConsolePanel.this.updateScriptContentType(sef);
            }
        });
        this.updateScriptContentType(this.editor.getModel().getScriptEngineFactory());
    }

    protected void warnMissingSyntaxKit(ScriptEngineFactory factory) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(I18n.tr((String)"Didn''t find a suitable syntax kit for the script engine <strong>{0}</strong>.", (Object[])new Object[]{factory.getEngineName()}));
        sb.append("<p>");
        sb.append(I18n.tr((String)"No syntax kit is configured for either of the following content types:"));
        sb.append("<ul>");
        for (String mt : factory.getMimeTypes()) {
            sb.append("<li><tt>").append(mt).append("</tt></li>");
        }
        sb.append("</ul>");
        sb.append(I18n.tr((String)"Syntax highlighting is going to be disabled."));
        sb.append("<p>");
        sb.append(I18n.tr((String)"Refer to the online help for information on how to configure syntax kits for specific content types."));
        sb.append("</html>");
        HelpAwareOptionPane.ButtonSpec[] btns = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"OK"), (Icon)ImageProvider.get((String)"ok"), "", null)};
        HelpAwareOptionPane.showOptionDialog((Component)this, (Object)sb.toString(), (String)I18n.tr((String)"No syntax kit"), (int)2, null, (HelpAwareOptionPane.ButtonSpec[])btns, (HelpAwareOptionPane.ButtonSpec)btns[0], null);
    }

    protected void updateScriptContentType(ScriptEngineFactory factory) {
        if (factory == null) {
            this.editor.changeContentType("text/plain");
        } else {
            List<String> mimeTypes = factory.getMimeTypes();
            for (String mt : mimeTypes) {
                if (!MimeTypeToSyntaxKitMap.getInstance().isSupported(mt)) continue;
                this.editor.changeContentType(mt);
                return;
            }
            this.editor.changeContentType("text/plain");
            this.warnMissingSyntaxKit(factory);
        }
    }

    public ScriptingConsolePanel() {
        this.build();
    }

    public void open(File file) {
        this.editor.open(file);
    }

    public void save(File file) {
        this.editor.save(file);
    }

    public void save() {
        File f = this.editor.getModel().getScriptFile();
        if (f == null) {
            return;
        }
        this.editor.save(f);
    }

    public ScriptEditorModel getScriptEditorModel() {
        return this.editor.getModel();
    }

    public IScriptLog getScriptLog() {
        return this.log;
    }

    class RunScriptAction
    extends AbstractAction
    implements PropertyChangeListener {
        private ScriptEditorModel model;

        public RunScriptAction(ScriptEditorModel model) {
            this.model = model;
            this.putValue("SmallIcon", ImageProvider.get((String)"media-playback-start"));
            this.putValue("ShortDescription", I18n.tr((String)"Execute the script"));
            this.putValue("Name", I18n.tr((String)"Run"));
            model.addPropertyChangeListener(this);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String source = ScriptingConsolePanel.this.editor.getScript();
            ScriptEngine engine = this.model.getScriptEngineFactory().getScriptEngine();
            try {
                engine.eval(source, (ScriptContext)new JOSMScriptContext(ScriptingConsolePanel.this.log.getLogWriter()));
            }
            catch (ScriptException ex) {
                ScriptingConsolePanel.this.log.dumpException(ex);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.getScriptEngineFactory() != null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(ScriptEditorModel.PROP_SCRIPT_ENGINE_FACTORY)) {
                return;
            }
            this.updateEnabledState();
        }
    }
}

