/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.plugins.scripting.ui.console.DocumentWriter;
import org.openstreetmap.josm.plugins.scripting.ui.console.IScriptLog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScriptLogPanel
extends JPanel
implements IScriptLog {
    private static final Logger logger = Logger.getLogger(ScriptLogPanel.class.getName());
    private JTextPane epOutput;
    private Action actClear;
    private JPopupMenu popupMenu;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.epOutput = new JTextPane();
        this.epOutput.setEditable(false);
        JScrollPane editorScrollPane = new JScrollPane(this.epOutput);
        editorScrollPane.setVerticalScrollBarPolicy(20);
        editorScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)editorScrollPane, "Center");
        this.popupMenu = this.buildPopupMenu();
        this.epOutput.addMouseListener(new PopupMenuLauncher());
    }

    protected JPopupMenu buildPopupMenu() {
        JPopupMenu mnu = new JPopupMenu();
        mnu.add(this.getClearAction());
        return mnu;
    }

    public ScriptLogPanel() {
        this.build();
    }

    public void dumpException(Throwable t) {
        if (t == null) {
            return;
        }
        StringWriter w = new StringWriter();
        t.printStackTrace(new PrintWriter(w));
        Document doc = this.epOutput.getDocument();
        try {
            SimpleAttributeSet set = new SimpleAttributeSet();
            StyleConstants.setForeground(set, Color.RED);
            doc.insertString(doc.getLength(), w.getBuffer().toString(), set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Writer getLogWriter() {
        return new DocumentWriter(this.epOutput.getDocument());
    }

    @Override
    public Action getClearAction() {
        if (this.actClear == null) {
            this.actClear = new ClearAction();
        }
        return this.actClear;
    }

    private class PopupMenuLauncher
    extends MouseAdapter {
        private PopupMenuLauncher() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            ScriptLogPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            ScriptLogPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            this.putValue("Name", I18n.tr((String)"Clear log"));
            this.putValue("ShortDescription", I18n.tr((String)"Clear the log content"));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs/delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ScriptLogPanel.this.epOutput.getDocument().remove(0, ScriptLogPanel.this.epOutput.getDocument().getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

