/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.plugins.scripting.preferences.GridBagConstraintBuilder;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptEditorModel;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptingEningeInfoPanel;
import org.openstreetmap.josm.plugins.scripting.util.Assert;
import org.openstreetmap.josm.plugins.scripting.util.IOUtil;
import org.openstreetmap.josm.tools.I18n;

public class ScriptEditor
extends JPanel
implements PropertyChangeListener {
    private JEditorPane editor;
    private ScriptingEningeInfoPanel infoPanel;
    private ScriptEditorModel model;
    private JLabel lblScriptFile;
    private JPanel pnlScriptFile;

    protected JPanel buildNorthPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        ScriptingEningeInfoPanel p = new ScriptingEningeInfoPanel(this.model);
        pnl.add((Component)p, GridBagConstraintBuilder.gbc().cell(0, 0).weight(1.0, 0.0).constraints());
        this.pnlScriptFile = new JPanel(new GridBagLayout());
        this.pnlScriptFile.add((Component)new JLabel(I18n.tr((String)"Current file:") + " "), GridBagConstraintBuilder.gbc().cell(0, 0).weight(0.0, 1.0).constraints());
        this.lblScriptFile = new JLabel("");
        this.pnlScriptFile.add((Component)this.lblScriptFile, GridBagConstraintBuilder.gbc().cell(1, 0).weight(1.0, 1.0).constraints());
        this.lblScriptFile.setFont(Font.decode("DialogInput-PLAIN"));
        pnl.add((Component)this.pnlScriptFile, GridBagConstraintBuilder.gbc().cell(0, 1).weight(1.0, 0.0).constraints());
        return pnl;
    }

    protected void build() {
        this.model = new ScriptEditorModel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildNorthPanel(), "North");
        this.editor = new JEditorPane();
        JScrollPane editorScrollPane = new JScrollPane(this.editor);
        editorScrollPane.setVerticalScrollBarPolicy(20);
        editorScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)editorScrollPane, "Center");
        this.editor.setContentType("text/plain");
    }

    public void changeContentType(String mimeType) {
        String text = this.editor.getText();
        this.editor.setContentType(mimeType);
        this.editor.setText(text);
    }

    protected void refreshScriptFile() {
        File f = this.model.getScriptFile();
        this.lblScriptFile.setText(f == null ? "" : f.getAbsolutePath());
        this.pnlScriptFile.setVisible(f != null);
    }

    public ScriptEditor() {
        this.build();
        this.model.addPropertyChangeListener(this);
        this.refreshScriptFile();
    }

    public Document getDocument() {
        return this.editor.getDocument();
    }

    public String getScript() {
        return this.editor.getText();
    }

    public ScriptEditorModel getModel() {
        return this.model;
    }

    protected void alertIOExceptionWhenLoading(File file, IOException e) {
        HelpAwareOptionPane.showOptionDialog((Component)this, (Object)I18n.tr((String)"Failed to load file ''{0}''.", (Object[])new Object[]{file}), (String)I18n.tr((String)"IO exception"), (int)0, null);
    }

    protected void alertIOExceptionWhenSaving(File file, IOException e) {
        HelpAwareOptionPane.showOptionDialog((Component)this, (Object)I18n.tr((String)"Failed to save file ''{0}''.", (Object[])new Object[]{file}), (String)I18n.tr((String)"IO exception"), (int)0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void open(File file) {
        block8: {
            Document doc = this.editor.getDocument();
            BufferedReader reader = null;
            try {
                doc.remove(doc.getStartPosition().getOffset(), doc.getLength());
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    doc.insertString(doc.getLength(), line, null);
                    doc.insertString(doc.getLength(), "\n", null);
                }
                IOUtil.close(reader);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                this.alertIOExceptionWhenLoading(file, e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(reader);
            }
        }
        this.model.setScriptFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        Assert.assertArgNotNull(file, "file");
        String script = this.editor.getText();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            writer.print(script);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                this.alertIOExceptionWhenSaving(file, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close(writer);
        }
        IOUtil.close(writer);
        this.model.setScriptFile(file);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ScriptEditorModel.PROP_SCRIPT_FILE)) {
            this.refreshScriptFile();
        }
    }
}

