/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.plugins.scripting.ui.console.SaveAsAction;
import org.openstreetmap.josm.plugins.scripting.ui.console.ScriptingConsole;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SaveAction
extends AbstractAction
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SaveAsAction.class.getName());

    public SaveAction() {
        this.putValue("Name", I18n.tr((String)"Save"));
        this.putValue("ShortDescription", I18n.tr((String)"Save script to current file"));
        this.putValue("SmallIcon", ImageProvider.get((String)"save"));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScriptingConsole.getScriptingConsole().save();
    }

    protected void updateEnabledState() {
        ScriptingConsole console = ScriptingConsole.getScriptingConsole();
        if (console == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(console.getScriptEditorModel().getScriptFile() != null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnabledState();
    }
}

