/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.scripting.ui.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jsyntaxpane.DefaultSyntaxKit;
import org.openstreetmap.josm.plugins.scripting.ScriptingPlugin;
import org.openstreetmap.josm.plugins.scripting.util.IOUtil;
import org.openstreetmap.josm.tools.I18n;

public class MimeTypeToSyntaxKitMap {
    private static MimeTypeToSyntaxKitMap instance = null;
    private Map<String, String> map = new HashMap<String, String>();

    public static MimeTypeToSyntaxKitMap getInstance() {
        if (instance == null) {
            instance = new MimeTypeToSyntaxKitMap();
            instance.loadFromResourceFiles();
        }
        return instance;
    }

    protected boolean isClassAvailable(String mimeType, String className) {
        try {
            Class<?> c = Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            System.out.println(I18n.tr((String)"Warning: syntax kit ''{0}'' can''t be loaded. Ignoring mapping for mime type ''{1}''.", (Object[])new Object[]{className, mimeType}));
            return false;
        }
    }

    public boolean isSupported(String mimeType) {
        return this.map.containsKey(mimeType);
    }

    protected void loadMappings(BufferedReader br) {
        try {
            String line;
            Pattern p = Pattern.compile("^\\s*(\\S+)\\s+(\\S+)");
            while ((line = br.readLine()) != null) {
                String className;
                String mimeType;
                Matcher m;
                if (line.matches("^\\s*#") || !(m = p.matcher(line)).matches() || !this.isClassAvailable(mimeType = m.group(1), className = m.group(2))) continue;
                this.map.put(mimeType, className);
            }
        }
        catch (IOException e) {
            System.out.println(I18n.tr((String)"Error: failed to read map from mime-type to syntax kits"));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDefaultMappings() {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/resources/syntax-kit-map.default");
            if (in == null) {
                System.out.println(I18n.tr((String)"Warning: failed to open resource file ''{0}''", (Object[])new Object[]{"/resources/syntax-kit-map.default"}));
            }
            System.out.println(I18n.tr((String)"Loading default map from mime-types to syntax kits from resource ''{0}''", (Object[])new Object[]{"/resources/syntax-kit-map.default"}));
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.loadMappings(br);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLocalMappings() {
        FileInputStream in = null;
        ScriptingPlugin plugin = ScriptingPlugin.getInstance();
        if (plugin == null) {
            return;
        }
        String dir = plugin.getPluginDir();
        if (dir == null) {
            return;
        }
        File f = new File(dir, "syntax-kit-map");
        if (!(f.exists() && f.isFile() && f.canRead())) {
            return;
        }
        try {
            in = new FileInputStream(f);
            System.out.println(I18n.tr((String)"Loading local map from mime-types to syntax kits from resource ''{0}''", (Object[])new Object[]{f.toString()}));
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            this.loadMappings(br);
        }
        catch (IOException e) {
            try {
                System.out.println(I18n.tr((String)"Error: failed to load local map from mime-types to syntax kits"));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close(in);
        }
        IOUtil.close(in);
    }

    protected void configureDefaultSyntaxKit() {
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            String mt = e.getKey();
            String c = e.getValue();
            DefaultSyntaxKit.registerContentType(mt, c);
        }
    }

    public void loadFromResourceFiles() {
        this.map.clear();
        this.loadDefaultMappings();
        this.loadLocalMappings();
        this.configureDefaultSyntaxKit();
    }
}

