/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class ToggleCommentsAction
extends TextAction
implements SyntaxAction {
    protected String lineCommentStart = "// ";
    protected Pattern lineCommentPattern = null;

    public ToggleCommentsAction() {
        super("TOGGLE");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null && target.getDocument() instanceof SyntaxDocument) {
            String[] lines = ActionUtils.getSelectedLines(target);
            StringBuffer toggled = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                Matcher m = this.lineCommentPattern.matcher(lines[i]);
                if (m.find()) {
                    toggled.append(m.replaceFirst("$2"));
                } else {
                    toggled.append(this.lineCommentStart);
                    toggled.append(lines[i]);
                }
                toggled.append('\n');
            }
            target.replaceSelection(toggled.toString());
        }
    }

    @Override
    public void config(Configuration config, String prefix, String name) {
        this.lineCommentStart = config.getPrefixProperty(prefix, name + ".LineComments", "// ").replace("\"", "");
        this.lineCommentPattern = Pattern.compile("(^" + this.lineCommentStart + ")(.*)");
    }

    @Override
    public TextAction getAction(String key) {
        return this;
    }
}

