/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class JUnindentAction
extends TextAction
implements SyntaxAction {
    public JUnindentAction() {
        super("JUNINDENT");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null) {
            SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
            int pos = target.getCaretPosition();
            int start = sDoc.getParagraphElement(pos).getStartOffset();
            String line = ActionUtils.getLine(target);
            if (ActionUtils.isEmptyOrBlanks(line)) {
                try {
                    sDoc.insertString(pos, "}", null);
                    Token t = sDoc.getPairFor(sDoc.getTokenAt(pos));
                    if (null != t) {
                        String pairLine = ActionUtils.getLineAt(target, t.start);
                        String indent = ActionUtils.getIndent(pairLine);
                        sDoc.replace(start, line.length() + 1, indent + "}", null);
                    }
                }
                catch (BadLocationException ble) {
                    target.replaceSelection("}");
                }
            } else {
                target.replaceSelection("}");
            }
        }
    }

    @Override
    public void config(Configuration config, String prefix, String name) {
    }

    @Override
    public TextAction getAction(String key) {
        return this;
    }
}

