/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.ReplaceDialog;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class FindReplaceActions
implements SyntaxAction {
    private Pattern pattern = null;
    private boolean wrap = true;
    private final FindDialogAction findDialogAction = new FindDialogAction();
    private final FindNextAction findNextAction = new FindNextAction();
    private ReplaceDialog dlg;

    public TextAction getFindDialogAction() {
        return this.findDialogAction;
    }

    public TextAction getFindNextAction() {
        return this.findNextAction;
    }

    @Override
    public void config(Configuration config, String prefix, String name) {
    }

    @Override
    public TextAction getAction(String key) {
        if (key.equals("FIND")) {
            return this.findDialogAction;
        }
        if (key.equals("REPLACE")) {
            return this.findDialogAction;
        }
        if (key.equals("FIND_NEXT")) {
            return this.findNextAction;
        }
        throw new IllegalArgumentException("Bad Action: " + key);
    }

    public void msgNotFound() {
        JOptionPane.showMessageDialog(null, "Search String " + this.pattern + " not found", "Find", 1);
    }

    private void showDialog(JTextComponent target) {
        if (this.dlg == null) {
            this.dlg = new ReplaceDialog(target, this);
        }
        this.dlg.setVisible(true);
    }

    public void doFindNext(JTextComponent target) {
        Matcher matcher;
        if (target == null || this.pattern == null) {
            return;
        }
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (sDoc == null) {
            return;
        }
        int start = target.getCaretPosition() + 1;
        if (start >= sDoc.getLength()) {
            start = 0;
        }
        if ((matcher = sDoc.getMatcher(this.pattern, start)) != null && matcher.find()) {
            target.select(matcher.start() + start, matcher.end() + start);
        } else if (this.isWrap()) {
            matcher = sDoc.getMatcher(this.pattern);
            if (matcher != null && matcher.find()) {
                target.select(matcher.start(), matcher.end());
            } else {
                this.msgNotFound();
            }
        } else {
            this.msgNotFound();
        }
    }

    public void replaceAll(JTextComponent target, String replacement) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(target);
        if (this.pattern == null || sDoc == null) {
            return;
        }
        Matcher matcher = sDoc.getMatcher(this.pattern);
        String newText = matcher.replaceAll(replacement);
        target.setText(newText);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    class FindNextAction
    extends TextAction {
        public FindNextAction() {
            super("FIND_NEXT");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindReplaceActions.this.pattern == null) {
                return;
            }
            JTextComponent target = this.getTextComponent(e);
            FindReplaceActions.this.doFindNext(target);
        }
    }

    class FindDialogAction
    extends TextAction {
        public FindDialogAction() {
            super("FIND_ACTION");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                FindReplaceActions.this.showDialog(target);
            }
        }
    }
}

