/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.GenericCommand;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.Turn;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Road {
    private final ModelContainer container;
    private final Route route;
    private final End fromEnd;
    private final End toEnd;

    private static Pair<Relation, Relation> getLengthRelations(Way w, Node n) {
        ArrayList<Relation> left = new ArrayList<Relation>();
        ArrayList<Relation> right = new ArrayList<Relation>();
        for (OsmPrimitive p : w.getReferrers()) {
            Relation r;
            if (p.getType() != OsmPrimitiveType.RELATION || !"turnlanes:lengths".equals((r = (Relation)p).get("type")) || !Road.isRightDirection(r, w, n)) continue;
            if (r.get("lengths:left") != null) {
                left.add(r);
            }
            if (r.get("lengths:right") == null) continue;
            right.add(r);
        }
        if (left.size() > 1) {
            throw new IllegalArgumentException("Way is in " + left.size() + " lengths relations for given direction, both specifying left lane lengths.");
        }
        if (right.size() > 1) {
            throw new IllegalArgumentException("Way is in " + right.size() + " lengths relations for given direction, both specifying right lane lengths.");
        }
        return new Pair((Object)(left.isEmpty() ? null : (Relation)left.get(0)), right.isEmpty() ? null : (Relation)right.get(0));
    }

    private static boolean isRightDirection(Relation r, Way w, Node n) {
        for (Route.Segment s : Route.load(r).getSegments()) {
            if (!w.equals((Object)s.getWay())) continue;
            return n.equals((Object)s.getEnd());
        }
        return false;
    }

    Road(ModelContainer container, Way w, Junction j) {
        Node n = j.getNode();
        if (!w.isFirstLastNode(n)) {
            throw new IllegalArgumentException("Way must start or end in given node.");
        }
        Pair<Relation, Relation> lengthsRelations = Road.getLengthRelations(w, n);
        this.container = container;
        this.route = lengthsRelations.a == null && lengthsRelations.b == null ? Route.create(Arrays.asList(w), n) : Route.load((Relation)lengthsRelations.a, (Relation)lengthsRelations.b, w);
        this.fromEnd = new End(true, container.getOrCreateJunction(this.route.getFirstSegment().getStart()));
        this.toEnd = new End(false, j, (Relation)lengthsRelations.a, (Relation)lengthsRelations.b);
    }

    Road(ModelContainer container, Route route) {
        this.container = container;
        this.route = route;
        this.fromEnd = new End(true, container.getJunction(route.getStart()));
        this.toEnd = new End(false, container.getJunction(route.getEnd()));
    }

    public End getFromEnd() {
        return this.fromEnd;
    }

    public End getToEnd() {
        return this.toEnd;
    }

    public Route getRoute() {
        return this.route;
    }

    public double getLength() {
        return this.route.getLength();
    }

    private static String join(List<Double> list) {
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(list.size() * (4 + ";".length()));
        for (double e : list) {
            builder.append(Road.toLengthString(e)).append(";");
        }
        builder.setLength(builder.length() - ";".length());
        return builder.toString();
    }

    private static String toLengthString(double length) {
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
        dfs.setDecimalSeparator('.');
        DecimalFormat nf = new DecimalFormat("0.0", dfs);
        nf.setRoundingMode(RoundingMode.HALF_UP);
        return nf.format(length);
    }

    public ModelContainer getContainer() {
        return this.container;
    }

    public boolean isPrimary() {
        return this.getContainer().isPrimary(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class End {
        private final boolean from;
        private final Junction junction;
        private final Relation lengthsLeft;
        private final Relation lengthsRight;
        private final double extraLengthLeft;
        private final double extraLengthRight;
        private final List<Lane> lanes;

        private End(boolean from, Junction junction, Relation lengthsLeft, Relation lengthsRight) {
            this.from = from;
            this.junction = junction;
            this.lengthsLeft = lengthsLeft;
            this.lengthsRight = lengthsRight;
            this.extraLengthLeft = lengthsLeft == null ? 0.0 : Route.load(lengthsLeft).getLengthFrom(this.getWay());
            this.extraLengthRight = lengthsRight == null ? 0.0 : Route.load(lengthsRight).getLengthFrom(this.getWay());
            this.lanes = Lane.load(this);
            junction.addRoad(this.getWay());
        }

        private End(boolean from, Junction junction) {
            this.from = from;
            this.junction = junction;
            this.lengthsLeft = null;
            this.lengthsRight = null;
            this.extraLengthLeft = 0.0;
            this.extraLengthRight = 0.0;
            this.lanes = Lane.load(this);
            junction.addRoad(this.getWay());
        }

        public Road getRoad() {
            return Road.this;
        }

        public Way getWay() {
            return this.isFromEnd() ? Road.this.getRoute().getFirstSegment().getWay() : Road.this.getRoute().getLastSegment().getWay();
        }

        public Junction getJunction() {
            return this.junction;
        }

        public boolean isFromEnd() {
            return this.from;
        }

        public boolean isToEnd() {
            return !this.isFromEnd();
        }

        public End getOppositeEnd() {
            return this.isFromEnd() ? Road.this.toEnd : Road.this.fromEnd;
        }

        public Set<Turn> getTurns() {
            return Turn.load(Road.this.getContainer(), "to", (OsmPrimitive)this.getWay());
        }

        public void addLane(Lane.Kind kind) {
            if (kind == Lane.Kind.REGULAR) {
                throw new IllegalArgumentException("Only extra lanes can be added.");
            }
            double length = Double.POSITIVE_INFINITY;
            for (Lane l : this.lanes) {
                if (l.getKind() != kind) continue;
                length = Math.max(0.0, Math.min(length, l.getLength() - 1.0));
            }
            if (Double.isInfinite(length)) {
                length = Math.min(20.0, 3.0 * Road.this.getLength() / 4.0);
            }
            this.addLane(kind, length);
        }

        private void addLane(Lane.Kind kind, double length) {
            assert (kind == Lane.Kind.EXTRA_LEFT || kind == Lane.Kind.EXTRA_RIGHT);
            GenericCommand cmd = new GenericCommand(this.getJunction().getNode().getDataSet(), "Add lane");
            boolean left = kind == Lane.Kind.EXTRA_LEFT;
            Relation rel = left ? this.lengthsLeft : this.lengthsRight;
            Relation other = left ? this.lengthsRight : this.lengthsLeft;
            Node n = this.getJunction().getNode();
            String lengthStr = Road.toLengthString(length);
            Relation target = rel == null ? (other == null || !Utils.getMemberNode(other, "end").equals((Object)n) ? this.createLengthsRelation() : other) : rel;
            String key = left ? "lengths:left" : "lengths:right";
            String old = target.get(key);
            if (old == null) {
                cmd.backup((OsmPrimitive)target).put(key, lengthStr);
            } else {
                cmd.backup((OsmPrimitive)target).put(key, old + ";" + lengthStr);
            }
            Main.main.undoRedo.add((Command)cmd);
        }

        private Relation createLengthsRelation() {
            Node n = this.getJunction().getNode();
            Relation r = new Relation();
            r.put("type", "turnlanes:lengths");
            r.addMember(new RelationMember("end", (OsmPrimitive)n));
            for (Route.Segment s : this.isFromEnd() ? Road.this.route.getSegments() : CollectionUtils.reverse(Road.this.route.getSegments())) {
                r.addMember(new RelationMember("ways", (OsmPrimitive)s.getWay()));
            }
            n.getDataSet().addPrimitive((OsmPrimitive)r);
            return r;
        }

        void updateLengths() {
            GenericCommand cmd = new GenericCommand(this.getJunction().getNode().getDataSet(), "Change lane length");
            for (boolean left : Arrays.asList(true, false)) {
                double extra;
                Lane.Kind kind = left ? Lane.Kind.EXTRA_LEFT : Lane.Kind.EXTRA_RIGHT;
                Relation r = left ? this.lengthsLeft : this.lengthsRight;
                double d = extra = left ? this.extraLengthLeft : this.extraLengthRight;
                if (r == null) continue;
                StringBuilder lengths = new StringBuilder(32);
                for (Lane l : left ? CollectionUtils.reverse(this.lanes) : this.lanes) {
                    if (l.getKind() != kind) continue;
                    lengths.append(Road.toLengthString(extra + l.getLength())).append(";");
                }
                lengths.setLength(lengths.length() - ";".length());
                cmd.backup((OsmPrimitive)r).put(left ? "lengths:left" : "lengths:right", lengths.toString());
            }
            Main.main.undoRedo.add((Command)cmd);
        }

        public List<Lane> getLanes() {
            return this.lanes;
        }

        public Lane getLane(Lane.Kind kind, int index) {
            for (Lane l : this.lanes) {
                if (l.getKind() != kind || l.getIndex() != index) continue;
                return l;
            }
            throw new IllegalArgumentException("No such lane.");
        }

        public Lane getExtraLane(int index) {
            return index < 0 ? this.getLane(Lane.Kind.EXTRA_LEFT, index) : this.getLane(Lane.Kind.EXTRA_RIGHT, index);
        }

        public boolean isExtendable() {
            End o = this.getOppositeEnd();
            return this.lengthsLeft == null && this.lengthsRight == null && (o.lengthsLeft != null || o.lengthsRight != null);
        }

        public void extend(Way way) {
            if (!this.isExtendable()) {
                throw new IllegalStateException();
            }
            End o = this.getOppositeEnd();
            if (o.lengthsLeft != null) {
                o.lengthsLeft.addMember(new RelationMember("ways", (OsmPrimitive)way));
            }
            if (o.lengthsRight != null) {
                o.lengthsRight.addMember(new RelationMember("ways", (OsmPrimitive)way));
            }
        }

        public List<Double> getLengths(Lane.Kind kind) {
            switch (kind) {
                case EXTRA_LEFT: {
                    return Lane.loadLengths(this.lengthsLeft, "lengths:left", this.extraLengthLeft);
                }
                case EXTRA_RIGHT: {
                    return Lane.loadLengths(this.lengthsRight, "lengths:right", this.extraLengthRight);
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)kind));
        }

        void removeLane(GenericCommand cmd, Lane lane) {
            assert (lane.getKind() == Lane.Kind.EXTRA_LEFT || lane.getKind() == Lane.Kind.EXTRA_RIGHT);
            boolean left = lane.getKind() == Lane.Kind.EXTRA_LEFT;
            Relation rel = left ? this.lengthsLeft : this.lengthsRight;
            for (Turn t : Turn.load(Road.this.getContainer(), "from", (OsmPrimitive)this.getWay())) {
                t.fixReferences(cmd, left, lane.getIndex());
            }
            double extraLength = left ? this.extraLengthLeft : this.extraLengthRight;
            ArrayList<Double> newLengths = new ArrayList<Double>();
            int i = Math.abs(lane.getIndex());
            String key = left ? "lengths:left" : "lengths:right";
            for (double l : Lane.loadLengths(rel, key, 0.0)) {
                if (l < extraLength) {
                    newLengths.add(l);
                    continue;
                }
                if (--i == 0) continue;
                newLengths.add(l);
            }
            AbstractPrimitive bRel = cmd.backup((OsmPrimitive)rel);
            bRel.put(key, Road.join(newLengths));
            if (bRel.get("lengths:left") == null && bRel.get("lengths:right") == null) {
                bRel.setDeleted(true);
            }
        }
    }
}

