/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelContainer {
    private final Map<Node, Junction> junctions = new HashMap<Node, Junction>();
    private final Map<Way, Road> roads = new HashMap<Way, Road>();
    private final Set<Node> primaryNodes;
    private final Set<Way> primaryWays;

    public static ModelContainer create(Iterable<Node> primaryNodes, Iterable<Way> primaryWays) {
        HashSet<Node> closedNodes = new HashSet<Node>(CollectionUtils.toList(primaryNodes));
        HashSet<Way> closedWays = new HashSet<Way>(CollectionUtils.toList(primaryWays));
        ModelContainer.close(closedNodes, closedWays);
        return new ModelContainer(closedNodes, closedWays);
    }

    private static void close(Set<Node> closedNodes, Set<Way> closedWays) {
        boolean closed = false;
        while (!closed) {
            closed = true;
            for (Node n : new ArrayList<Node>(closedNodes)) {
                for (Way w : Utils.filterRoads(n.getReferrers())) {
                    if (!w.isFirstLastNode(n)) continue;
                    closed &= ModelContainer.close(closedNodes, closedWays, w, "from");
                    closed &= ModelContainer.close(closedNodes, closedWays, w, "to");
                }
                for (Way w : new ArrayList<Way>(closedWays)) {
                    closed &= ModelContainer.close(closedNodes, closedWays, w, "via");
                }
            }
        }
    }

    private static boolean close(Set<Node> closedNodes, Set<Way> closedWays, Way w, String role) {
        boolean closed = true;
        for (Relation r : OsmPrimitive.getFilteredList((Collection)w.getReferrers(), Relation.class)) {
            if (!r.get("type").equals("turnlanes:turns")) continue;
            for (RelationMember m : r.getMembers()) {
                if (!m.getRole().equals(role) || !m.getMember().equals((Object)w)) continue;
                closed &= ModelContainer.close(closedNodes, closedWays, r);
            }
        }
        return closed;
    }

    private static boolean close(Set<Node> closedNodes, Set<Way> closedWays, Relation r) {
        boolean closed = true;
        ArrayList<Way> via = new ArrayList<Way>();
        for (RelationMember m : Utils.getMembers(r, "via")) {
            if (m.isWay()) {
                closed &= !closedWays.add(m.getWay());
                via.add(m.getWay());
                continue;
            }
            if (!m.isNode()) continue;
            closed &= !closedNodes.add(m.getNode());
        }
        if (!via.isEmpty()) {
            Way from = Utils.getMemberWay(r, "from");
            Way to = Utils.getMemberWay(r, "to");
            closed &= !closedNodes.add(Utils.lineUp(from, (Way)via.get(0)));
            closed &= !closedNodes.add(Utils.lineUp((Way)via.get(via.size() - 1), to));
        }
        return closed;
    }

    private ModelContainer(Set<Node> primaryNodes, Set<Way> primaryWays) {
        this.primaryNodes = Collections.unmodifiableSet(new HashSet<Node>(primaryNodes));
        this.primaryWays = Collections.unmodifiableSet(new HashSet<Way>(primaryWays));
        HashSet<Pair> ws = new HashSet<Pair>();
        for (Node n : primaryNodes) {
            Junction j = this.getOrCreateJunction(n);
            for (Way w : Utils.filterRoads(n.getReferrers())) {
                if (!w.isFirstLastNode(n)) continue;
                ws.add(new Pair((Object)w, (Object)j));
            }
        }
        List<Route> rs = Utils.orderWays(primaryWays, primaryNodes);
        for (Route r : rs) {
            this.addRoad(new Road(this, r));
        }
        for (Pair w : ws) {
            if (primaryWays.contains(w.a)) continue;
            this.addRoad(new Road(this, (Way)w.a, (Junction)w.b));
        }
    }

    Junction getOrCreateJunction(Node n) {
        Junction existing = this.junctions.get(n);
        if (existing != null) {
            return existing;
        }
        return new Junction(this, n);
    }

    public Junction getJunction(Node n) {
        Junction j = this.junctions.get(n);
        if (j == null) {
            throw new IllegalArgumentException();
        }
        return j;
    }

    Road getRoad(Way w) {
        Road r = this.roads.get(w);
        if (r == null) {
            throw new IllegalArgumentException("There is no road containing the given way.");
        }
        return r;
    }

    private void addRoad(Road newRoad, Road mergedA, Road mergedB) {
        assert (mergedA == null == (mergedB == null));
        for (Route.Segment s : newRoad.getRoute().getSegments()) {
            Road oldRoad = this.roads.put(s.getWay(), newRoad);
            if (oldRoad == null) continue;
            if (mergedA == null) {
                Road mergedRoad = this.mergeRoads(oldRoad, newRoad);
                this.addRoad(mergedRoad, oldRoad, newRoad);
                continue;
            }
            if (oldRoad.equals(mergedA) || oldRoad.equals(mergedB)) continue;
            throw new RuntimeException("A road can't be connected to more than two junctions.");
        }
    }

    private void addRoad(Road newRoad) {
        this.addRoad(newRoad, null, null);
    }

    private Road mergeRoads(Road a, Road b) {
        String ERR_ILLEGAL_ARGS = "The given roads can not be merged into one.";
        ArrayList<Way> ws = new ArrayList<Way>(CollectionUtils.toList(CollectionUtils.reverse(a.getRoute().getWays())));
        List<Way> bws = b.getRoute().getWays();
        int i = -1;
        for (Way w : ws) {
            if (w.equals((Object)bws.get(i + 1))) {
                ++i;
                continue;
            }
            if (i < 0) continue;
            throw new IllegalArgumentException("The given roads can not be merged into one.");
        }
        if (i < 0) {
            throw new IllegalArgumentException("The given roads can not be merged into one.");
        }
        ws.addAll(bws.subList(i + 1, bws.size()));
        Route mergedRoute = Route.create(ws, a.getRoute().getLastSegment().getEnd());
        return new Road(this, mergedRoute);
    }

    void register(Junction j) {
        if (this.junctions.put(j.getNode(), j) != null) {
            throw new IllegalStateException();
        }
    }

    public Set<Junction> getPrimaryJunctions() {
        HashSet<Junction> pjs = new HashSet<Junction>();
        for (Node n : this.primaryNodes) {
            pjs.add(this.getOrCreateJunction(n));
        }
        return pjs;
    }

    public Set<Road> getPrimaryRoads() {
        HashSet<Road> prs = new HashSet<Road>();
        for (Way w : this.primaryWays) {
            prs.add(this.roads.get(w));
        }
        return prs;
    }

    public ModelContainer recalculate() {
        return new ModelContainer(this.primaryNodes, this.primaryWays);
    }

    public boolean isPrimary(Junction j) {
        return this.primaryNodes.contains(j.getNode());
    }

    public boolean isPrimary(Road r) {
        return this.primaryWays.contains(r.getRoute().getFirstSegment().getWay());
    }
}

