/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionPane;
import org.openstreetmap.josm.plugins.turnlanes.gui.ValidationPanel;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.UnexpectedDataException;
import org.openstreetmap.josm.tools.I18n;

public class TurnLanesDialog
extends ToggleDialog {
    private final DataSetListener dataSetListener = new DataSetListener(){

        public void wayNodesChanged(WayNodesChangedEvent event) {
            this.refresh();
        }

        public void tagsChanged(TagsChangedEvent event) {
            this.refresh();
        }

        public void relationMembersChanged(RelationMembersChangedEvent event) {
            this.refresh();
        }

        public void primtivesRemoved(PrimitivesRemovedEvent event) {
            this.refresh();
        }

        public void primtivesAdded(PrimitivesAddedEvent event) {
            this.refresh();
        }

        public void otherDatasetChange(AbstractDatasetChangedEvent event) {
            this.refresh();
        }

        public void nodeMoved(NodeMovedEvent event) {
            this.refresh();
        }

        public void dataChanged(DataChangedEvent event) {
            this.refresh();
        }

        private void refresh() {
            if (TurnLanesDialog.this.editing) {
                TurnLanesDialog.this.junctionPane.refresh();
            }
        }
    };
    private final Action editAction = new EditAction();
    private final Action validateAction = new ValidateAction();
    private static final long serialVersionUID = -1998375221636611358L;
    private static final String CARD_EDIT = "EDIT";
    private static final String CARD_VALIDATE = "VALIDATE";
    private static final String CARD_ERROR = "ERROR";
    private final JPanel body = new JPanel();
    private final JunctionPane junctionPane = new JunctionPane(null);
    private final JLabel error = new JLabel();
    private final JToggleButton editButton = new JToggleButton(this.editAction);
    private final JToggleButton validateButton = new JToggleButton(this.validateAction);
    private final Set<OsmPrimitive> selected = new HashSet<OsmPrimitive>();
    private boolean editing = true;

    public TurnLanesDialog() {
        super(I18n.tr((String)"Turn Lanes"), "turnlanes.png", I18n.tr((String)"Edit turn lanes"), null, 200);
        MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)new MapView.EditLayerChangeListener(){

            public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
                if (oldLayer != null) {
                    oldLayer.data.removeDataSetListener(TurnLanesDialog.this.dataSetListener);
                }
                if (newLayer != null) {
                    newLayer.data.addDataSetListener(TurnLanesDialog.this.dataSetListener);
                }
            }
        });
        DataSet.addSelectionListener((SelectionChangedListener)new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                if (((Object)TurnLanesDialog.this.selected).equals(new HashSet<OsmPrimitive>(newSelection))) {
                    return;
                }
                TurnLanesDialog.this.selected.clear();
                TurnLanesDialog.this.selected.addAll(newSelection);
                Collection<? extends OsmPrimitive> s = Collections.unmodifiableCollection(newSelection);
                List nodes = OsmPrimitive.getFilteredList(s, Node.class);
                List ways = OsmPrimitive.getFilteredList(s, Way.class);
                if (nodes.isEmpty()) {
                    TurnLanesDialog.this.setJunction(null);
                    return;
                }
                try {
                    TurnLanesDialog.this.setJunction(ModelContainer.create(nodes, ways));
                }
                catch (UnexpectedDataException e) {
                    TurnLanesDialog.this.displayError(e);
                    return;
                }
                catch (RuntimeException e) {
                    TurnLanesDialog.this.displayError(e);
                    return;
                }
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        ButtonGroup group = new ButtonGroup();
        group.add(this.editButton);
        group.add(this.validateButton);
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.validateButton);
        this.body.setLayout(new CardLayout(4, 4));
        this.add(buttonPanel, "South");
        this.add(this.body, "Center");
        this.body.add((Component)this.junctionPane, CARD_EDIT);
        this.body.add((Component)new ValidationPanel(), CARD_VALIDATE);
        this.body.add((Component)this.error, CARD_ERROR);
        this.editButton.doClick();
    }

    void displayError(UnexpectedDataException e) {
        if (this.editing) {
            if (e.getKind() == UnexpectedDataException.Kind.MISSING_TAG && UnexpectedDataException.Kind.MISSING_TAG.format("lanes").equals(e.getMessage())) {
                this.error.setText("<html>The number of lanes is not specified for one or more roads; please add missing lanes tags.</html>");
            } else {
                this.displayError((RuntimeException)e);
            }
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_ERROR);
        }
    }

    void displayError(RuntimeException e) {
        if (this.editing) {
            e.printStackTrace();
            this.error.setText("<html>An error occured while constructing the model. Please run the validator to make sure the data is consistent.<br><br>Error: " + e.getMessage() + "</html>");
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_ERROR);
        }
    }

    void setJunction(ModelContainer mc) {
        if (mc != null && this.editing) {
            this.junctionPane.setJunction(new GuiContainer(mc));
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_EDIT);
        }
    }

    private class ValidateAction
    extends JosmAction {
        private static final long serialVersionUID = 7510740945725851427L;

        public ValidateAction() {
            super(I18n.tr((String)"Validate"), "dialogs/validator", I18n.tr((String)"Validate turn- and lane-length-relations for consistency."), null, false);
            this.putValue("toolbar", "turnlanes/validate");
            Main.toolbar.register((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_VALIDATE);
            TurnLanesDialog.this.editing = false;
            TurnLanesDialog.this.validateButton.setSelected(true);
        }
    }

    private class EditAction
    extends JosmAction {
        private static final long serialVersionUID = 4114119073563457706L;

        public EditAction() {
            super(I18n.tr((String)"Edit"), "dialogs/edit", I18n.tr((String)"Edit turn relations and lane lengths for selected node."), null, false);
            this.putValue("toolbar", "turnlanes/edit");
            Main.toolbar.register((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_EDIT);
            TurnLanesDialog.this.editing = true;
            TurnLanesDialog.this.editButton.setSelected(true);
        }
    }
}

