/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMergerUtility {
    private List<InputStream> sources;
    private String destinationFileName;
    private OutputStream destinationStream;
    private boolean ignoreAcroFormErrors = false;
    Map<Object, COSBase> clonedVersion = new HashMap<Object, COSBase>();
    private int nextFieldNum = 1;

    public PDFMergerUtility() {
        this.sources = new ArrayList<InputStream>();
    }

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destination) {
        this.destinationFileName = destination;
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    public void setDestinationStream(OutputStream destinationStream) {
        this.destinationStream = destinationStream;
    }

    public void addSource(String source) {
        try {
            this.sources.add(new FileInputStream(new File(source)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(File source) {
        try {
            this.sources.add(new FileInputStream(source));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(InputStream source) {
        this.sources.add(source);
    }

    public void addSources(List<InputStream> sources) {
        this.sources.addAll(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDocuments() throws IOException, COSVisitorException {
        PDDocument destination = null;
        if (this.sources != null && this.sources.size() > 0) {
            Vector<PDDocument> tobeclosed = new Vector<PDDocument>();
            try {
                Iterator<InputStream> sit = this.sources.iterator();
                InputStream sourceFile = sit.next();
                destination = PDDocument.load(sourceFile);
                while (sit.hasNext()) {
                    sourceFile = sit.next();
                    PDDocument source = PDDocument.load(sourceFile);
                    tobeclosed.add(source);
                    this.appendDocument(destination, source);
                }
                if (this.destinationStream == null) {
                    destination.save(this.destinationFileName);
                } else {
                    destination.save(this.destinationStream);
                }
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
                for (PDDocument doc : tobeclosed) {
                    doc.close();
                }
            }
        }
    }

    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        PDDocumentCatalog srcCatalog;
        PDDocumentCatalog destCatalog;
        block25: {
            if (destination.isEncrypted()) {
                throw new IOException("Error: destination PDF is encrypted, can't append encrypted PDF documents.");
            }
            if (source.isEncrypted()) {
                throw new IOException("Error: source PDF is encrypted, can't append encrypted PDF documents.");
            }
            PDDocumentInformation destInfo = destination.getDocumentInformation();
            PDDocumentInformation srcInfo = source.getDocumentInformation();
            destInfo.getDictionary().mergeInto(srcInfo.getDictionary());
            destCatalog = destination.getDocumentCatalog();
            srcCatalog = source.getDocumentCatalog();
            if (destCatalog.getOpenAction() == null) {
                destCatalog.setOpenAction(srcCatalog.getOpenAction());
            }
            try {
                PDAcroForm destAcroForm = destCatalog.getAcroForm();
                PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
                if (destAcroForm == null) {
                    this.cloneForNewDocument(destination, srcAcroForm);
                    destCatalog.setAcroForm(srcAcroForm);
                } else if (srcAcroForm != null) {
                    this.mergeAcroForm(destination, destAcroForm, srcAcroForm);
                }
            }
            catch (Exception e) {
                if (this.ignoreAcroFormErrors) break block25;
                throw (IOException)e;
            }
        }
        COSArray destThreads = (COSArray)destCatalog.getCOSDictionary().getDictionaryObject(COSName.THREADS);
        COSArray srcThreads = (COSArray)this.cloneForNewDocument(destination, destCatalog.getCOSDictionary().getDictionaryObject(COSName.THREADS));
        if (destThreads == null) {
            destCatalog.getCOSDictionary().setItem(COSName.THREADS, (COSBase)srcThreads);
        } else {
            destThreads.addAll(srcThreads);
        }
        PDDocumentNameDictionary destNames = destCatalog.getNames();
        PDDocumentNameDictionary srcNames = srcCatalog.getNames();
        if (srcNames != null) {
            if (destNames == null) {
                destCatalog.getCOSDictionary().setItem(COSName.NAMES, this.cloneForNewDocument(destination, srcNames));
            } else {
                this.cloneMerge(destination, srcNames, destNames);
            }
        }
        PDDocumentOutline destOutline = destCatalog.getDocumentOutline();
        PDDocumentOutline srcOutline = srcCatalog.getDocumentOutline();
        if (srcOutline != null) {
            if (destOutline == null) {
                PDDocumentOutline cloned = new PDDocumentOutline((COSDictionary)this.cloneForNewDocument(destination, srcOutline));
                destCatalog.setDocumentOutline(cloned);
            } else {
                PDOutlineItem first = srcOutline.getFirstChild();
                if (first != null) {
                    PDOutlineItem clonedFirst = new PDOutlineItem((COSDictionary)this.cloneForNewDocument(destination, first));
                    destOutline.appendChild(clonedFirst);
                }
            }
        }
        String destPageMode = destCatalog.getPageMode();
        String srcPageMode = srcCatalog.getPageMode();
        if (destPageMode == null) {
            destCatalog.setPageMode(srcPageMode);
        }
        COSDictionary destLabels = (COSDictionary)destCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGE_LABELS);
        COSDictionary srcLabels = (COSDictionary)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGE_LABELS);
        if (srcLabels != null) {
            int destPageCount = destination.getNumberOfPages();
            COSArray destNums = null;
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.NUMS, (COSBase)destNums);
                destCatalog.getCOSDictionary().setItem(COSName.PAGE_LABELS, (COSBase)destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.NUMS);
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.NUMS);
            if (srcNums != null) {
                for (int i = 0; i < srcNums.size(); i += 2) {
                    COSNumber labelIndex = (COSNumber)srcNums.getObject(i);
                    long labelIndexValue = labelIndex.intValue();
                    destNums.add(COSInteger.get(labelIndexValue + (long)destPageCount));
                    destNums.add(this.cloneForNewDocument(destination, srcNums.getObject(i + 1)));
                }
            }
        }
        COSStream destMetadata = (COSStream)destCatalog.getCOSDictionary().getDictionaryObject(COSName.METADATA);
        COSStream srcMetadata = (COSStream)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.METADATA);
        if (destMetadata == null && srcMetadata != null) {
            PDStream newStream = new PDStream(destination, srcMetadata.getUnfilteredStream(), false);
            newStream.getStream().mergeInto(srcMetadata);
            newStream.addCompression();
            destCatalog.getCOSDictionary().setItem(COSName.METADATA, (COSObjectable)newStream);
        }
        List pages = source.getDocumentCatalog().getAllPages();
        for (PDPage page : pages) {
            PDPage newPage = new PDPage((COSDictionary)this.cloneForNewDocument(destination, page.getCOSDictionary()));
            newPage.setCropBox(page.findCropBox());
            newPage.setMediaBox(page.findMediaBox());
            newPage.setRotation(page.findRotation());
            destination.addPage(newPage);
        }
    }

    private COSBase cloneForNewDocument(PDDocument destination, Object base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval == null) {
            if (base instanceof List) {
                COSArray array = new COSArray();
                List list = (List)base;
                for (int i = 0; i < list.size(); ++i) {
                    array.add(this.cloneForNewDocument(destination, list.get(i)));
                }
                retval = array;
            } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
                retval = this.cloneForNewDocument(destination, ((COSObjectable)base).getCOSObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSObject) {
                COSObject object = (COSObject)base;
                retval = this.cloneForNewDocument(destination, object.getObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSArray) {
                COSArray newArray = new COSArray();
                COSArray array = (COSArray)base;
                for (int i = 0; i < array.size(); ++i) {
                    newArray.add(this.cloneForNewDocument(destination, array.get(i)));
                }
                retval = newArray;
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSStream) {
                COSStream originalStream = (COSStream)base;
                PDStream stream = new PDStream(destination, originalStream.getFilteredStream(), true);
                this.clonedVersion.put(base, stream.getStream());
                for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                    stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(destination, entry.getValue()));
                }
                retval = stream.getStream();
            } else if (base instanceof COSDictionary) {
                COSDictionary dic = (COSDictionary)base;
                retval = new COSDictionary();
                this.clonedVersion.put(base, retval);
                for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                    ((COSDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(destination, entry.getValue()));
                }
            } else {
                retval = (COSBase)base;
            }
        }
        this.clonedVersion.put(base, retval);
        return retval;
    }

    private void cloneMerge(PDDocument destination, COSObjectable base, COSObjectable target) throws IOException {
        if (base == null) {
            return;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (base instanceof List) {
            COSArray array = new COSArray();
            List list = (List)((Object)base);
            for (int i = 0; i < list.size(); ++i) {
                array.add(this.cloneForNewDocument(destination, list.get(i)));
            }
            ((List)((Object)target)).add(array);
        } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            this.cloneMerge(destination, base.getCOSObject(), target.getCOSObject());
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSObject) {
            if (target instanceof COSObject) {
                this.cloneMerge(destination, ((COSObject)base).getObject(), ((COSObject)target).getObject());
            } else if (target instanceof COSDictionary) {
                this.cloneMerge(destination, ((COSObject)base).getObject(), (COSDictionary)target);
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSArray) {
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                ((COSArray)target).add(this.cloneForNewDocument(destination, array.get(i)));
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            PDStream stream = new PDStream(destination, originalStream.getFilteredStream(), true);
            this.clonedVersion.put(base, stream.getStream());
            for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(destination, entry.getValue()));
            }
            retval = stream.getStream();
            target = retval;
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            this.clonedVersion.put(base, retval);
            for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                COSName key = entry.getKey();
                COSBase value = entry.getValue();
                if (((COSDictionary)target).getItem(key) != null) {
                    this.cloneMerge(destination, value, ((COSDictionary)target).getItem(key));
                    continue;
                }
                ((COSDictionary)target).setItem(key, this.cloneForNewDocument(destination, value));
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
    }

    private void mergeAcroForm(PDDocument destination, PDAcroForm destAcroForm, PDAcroForm srcAcroForm) throws IOException {
        List destFields = destAcroForm.getFields();
        List srcFields = srcAcroForm.getFields();
        if (srcFields != null) {
            if (destFields == null) {
                destFields = new COSArrayList();
                destAcroForm.setFields(destFields);
            }
            for (PDField srcField : srcFields) {
                PDField destField = PDFieldFactory.createField(destAcroForm, (COSDictionary)this.cloneForNewDocument(destination, srcField.getDictionary()));
                if (destAcroForm.getField(destField.getFullyQualifiedName()) != null) {
                    destField.setPartialName("dummyFieldName" + this.nextFieldNum++);
                }
                destFields.add(destField);
            }
        }
    }

    public boolean isIgnoreAcroFormErrors() {
        return this.ignoreAcroFormErrors;
    }

    public void setIgnoreAcroFormErrors(boolean ignoreAcroFormErrors) {
        this.ignoreAcroFormErrors = ignoreAcroFormErrors;
    }
}

