/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerPlugin;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JunctionChecker;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionSearchTask
extends PleaseWaitRunnable {
    private final JunctionChecker jc;
    private final JunctionCheckerPlugin plugin;
    private final int n;
    private final HashSet<Channel> subset;
    private final boolean produceRelation;
    private boolean canceled;

    public JunctionSearchTask(JunctionCheckerPlugin plugin, int n, HashSet<Channel> subset, boolean produceRelation) {
        super("JunctionSearch", false);
        this.plugin = plugin;
        this.n = n;
        this.subset = subset;
        this.produceRelation = produceRelation;
        this.jc = new JunctionChecker(plugin.getChannelDigraph(), n);
    }

    protected void cancel() {
        this.canceled = true;
        this.progressMonitor.cancel();
    }

    protected void finish() {
        this.progressMonitor.finishTask();
        if (this.canceled) {
            return;
        }
        ArrayList<HashSet<Channel>> junctions = this.jc.getJunctions();
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Number of {0]-ways junctions found: ", (Object[])new Object[]{this.n}) + junctions.size());
        if (this.produceRelation) {
            for (int i = 0; i < junctions.size(); ++i) {
                this.plugin.getRelationProducer().produceRelation(junctions.get(i), this.n);
            }
        }
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.jc.junctionSearch(new ArrayList<Channel>(this.subset), this.getProgressMonitor());
    }
}

