/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.access.Implication;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.util.TagCondition;
import org.openstreetmap.josm.plugins.graphview.core.util.TagConditionLogic;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicationXMLReader {
    private final List<Implication> implications = new LinkedList<Implication>();
    private State state = State.BEFORE_IMPLICATION;
    private ConditionReader currentConditionReader;
    private TagCondition currentCondition;
    private Collection<Tag> currentImpliedTags;
    boolean tagOpen = false;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        switch (this.state) {
            case BEFORE_IMPLICATION: {
                if (!"implication".equals(name)) break;
                this.state = State.BEFORE_CONDITION;
                return;
            }
            case BEFORE_CONDITION: {
                if (!"condition".equals(name)) break;
                this.currentConditionReader = new ConditionReader();
                this.state = State.CONDITION;
                return;
            }
            case CONDITION: {
                this.currentConditionReader.startElement(uri, localName, name, attributes);
                return;
            }
            case BEFORE_IMPLIES: {
                if (!"implies".equals(name)) break;
                this.currentImpliedTags = new LinkedList<Tag>();
                this.state = State.IMPLIES;
                return;
            }
            case IMPLIES: {
                if (!"tag".equals(name)) break;
                if (this.tagOpen) {
                    throw new SAXException(I18n.tr((String)"Tag element inside other tag element"));
                }
                this.currentImpliedTags.add(ImplicationXMLReader.readTag(attributes));
                this.tagOpen = true;
                return;
            }
        }
        throw new SAXException(I18n.tr((String)"Invalid opening xml tag <{0}> in state {1}", (Object[])new Object[]{name, this.state}));
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        switch (this.state) {
            case CONDITION: {
                if (name.equals("condition")) {
                    if (!this.currentConditionReader.isFinished()) {
                        throw new SAXException(I18n.tr((String)"Condition isn't finished at </condition> tag"));
                    }
                    this.currentCondition = this.currentConditionReader.getCondition();
                    this.currentConditionReader = null;
                    this.state = State.BEFORE_IMPLIES;
                    return;
                }
                this.currentConditionReader.endElement(uri, localName, name);
                return;
            }
            case IMPLIES: {
                if (name.equals("implies")) {
                    this.state = State.AFTER_IMPLIES;
                    return;
                }
                if (!name.equals("tag")) break;
                if (!this.tagOpen) {
                    throw new SAXException(I18n.tr((String)"Closing tag element that was not open"));
                }
                this.tagOpen = false;
                return;
            }
            case AFTER_IMPLIES: {
                if (!name.equals("implication")) break;
                this.implications.add(new Implication(this.currentCondition, this.currentImpliedTags));
                this.currentCondition = null;
                this.currentImpliedTags = null;
                this.state = State.BEFORE_IMPLICATION;
                return;
            }
        }
        throw new SAXException(I18n.tr((String)"Invalid closing xml tag </{0}> in state {1}", (Object[])new Object[]{name, this.state}));
    }

    public List<Implication> getImplications() throws SAXException {
        if (this.state != State.BEFORE_IMPLICATION) {
            throw new SAXException(I18n.tr((String)"Some tags not been closed; now in state {0}", (Object[])new Object[]{this.state}));
        }
        return new ArrayList<Implication>(this.implications);
    }

    private static Tag readTag(Attributes attributes) throws SAXException {
        String key = attributes.getValue("k");
        String value = attributes.getValue("v");
        if (key == null) {
            throw new SAXException(I18n.tr((String)"Tag without key"));
        }
        if (value == null) {
            throw new SAXException(I18n.tr((String)"Tag without value (key is {0})", (Object[])new Object[]{key}));
        }
        return new Tag(key, value);
    }

    private static String readKey(Attributes attributes) throws SAXException {
        String key = attributes.getValue("k");
        if (key == null) {
            throw new SAXException(I18n.tr((String)"Key element without attribute k"));
        }
        return key;
    }

    private static class ConditionReader {
        String openingName;
        TagCondition condition;
        boolean finished;
        private final List<ConditionReader> childReaders = new LinkedList<ConditionReader>();
        private ConditionReader currentChildReader = null;

        private ConditionReader() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.finished) {
                throw new SAXException(I18n.tr((String)"Condition is already finished at <{0}>", (Object[])new Object[]{name}));
            }
            if (this.currentChildReader != null) {
                this.currentChildReader.startElement(uri, localName, name, attributes);
                return;
            }
            if (this.openingName == null) {
                this.openingName = name;
                if ("tag".equals(name)) {
                    this.condition = TagConditionLogic.tag(ImplicationXMLReader.readTag(attributes));
                } else if ("key".equals(name)) {
                    this.condition = TagConditionLogic.key(ImplicationXMLReader.readKey(attributes));
                } else if (!("or".equals(name) || "and".equals(name) || "not".equals(name))) {
                    throw new SAXException(I18n.tr((String)"Unknown tag for condition: {0}", (Object[])new Object[]{name}));
                }
            } else {
                if ("tag".equals(this.openingName) || "key".equals(this.openingName)) {
                    throw new SAXException(I18n.tr((String)"Element must not have childs: {0}", (Object[])new Object[]{this.openingName}));
                }
                this.currentChildReader = new ConditionReader();
                this.currentChildReader.startElement(uri, localName, name, attributes);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.finished) {
                throw new SAXException(I18n.tr((String)"Condition is already finished at </{0}>", (Object[])new Object[]{name}));
            }
            if (this.currentChildReader != null) {
                this.currentChildReader.endElement(uri, localName, name);
                if (!this.currentChildReader.isFinished()) return;
                this.childReaders.add(this.currentChildReader);
                this.currentChildReader = null;
                return;
            } else {
                if (!this.openingName.equals(name)) throw new SAXException(I18n.tr((String)"Wrong closing tag {0} (</{1}> expected)", (Object[])new Object[]{name, this.openingName}));
                ArrayList<TagCondition> childConditions = new ArrayList<TagCondition>();
                for (ConditionReader childReader : this.childReaders) {
                    childConditions.add(childReader.getCondition());
                }
                if ("and".equals(this.openingName)) {
                    if (childConditions.size() <= 0) throw new SAXException(I18n.tr((String)"<and> needs at least one child"));
                    this.condition = TagConditionLogic.and(childConditions);
                } else if ("or".equals(this.openingName)) {
                    if (childConditions.size() <= 0) throw new SAXException(I18n.tr((String)"<or> needs at least one child"));
                    this.condition = TagConditionLogic.or(childConditions);
                } else if ("not".equals(this.openingName)) {
                    if (childConditions.size() != 1) throw new SAXException(I18n.tr((String)"<not> needs at least one child"));
                    this.condition = TagConditionLogic.not((TagCondition)childConditions.get(0));
                }
                this.finished = true;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public TagCondition getCondition() {
            if (!this.finished) {
                throw new IllegalStateException(I18n.tr((String)"Condition {0} not yet finished", (Object[])new Object[]{this.openingName}));
            }
            assert (this.condition != null);
            return this.condition;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BEFORE_IMPLICATION,
        BEFORE_CONDITION,
        CONDITION,
        BEFORE_IMPLIES,
        IMPLIES,
        AFTER_IMPLIES;

    }
}

