/*
 * Decompiled with CFR 0.152.
 */
package wmsturbochallenge;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import wmsturbochallenge.GameWindow;

public class WMSRacer
extends Plugin
implements MapView.LayerChangeListener {
    protected DriveAction driveAction = new DriveAction();

    public WMSRacer(PluginInformation info) {
        super(info);
        this.driveAction.updateEnabledState();
        JMenu toolsMenu = Main.main.menu.toolsMenu;
        toolsMenu.addSeparator();
        toolsMenu.add(new JMenuItem((Action)((Object)this.driveAction)));
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null) {
            MapView cfr_ignored_0 = oldFrame.mapView;
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
        }
        this.driveAction.frame = newFrame;
        this.driveAction.updateEnabledState();
        if (newFrame != null) {
            MapView cfr_ignored_1 = newFrame.mapView;
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.driveAction.currentLayer = newLayer;
        this.driveAction.updateEnabledState();
    }

    public void layerAdded(Layer newLayer) {
        this.driveAction.updateEnabledState();
    }

    public void layerRemoved(Layer oldLayer) {
        this.driveAction.updateEnabledState();
    }

    protected class DriveAction
    extends JosmAction {
        public MapFrame frame;
        public Layer currentLayer;
        protected Layer groundLayer;

        public DriveAction() {
            super(I18n.tr((String)"Go driving"), "wmsracer", I18n.tr((String)"Drive a race car on this layer"), null, true);
            this.frame = null;
            this.currentLayer = null;
            this.groundLayer = null;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.groundLayer == null || !this.groundLayer.isBackgroundLayer()) {
                return;
            }
            new GameWindow(this.groundLayer);
        }

        public void updateEnabledState() {
            if (this.frame == null) {
                this.groundLayer = null;
                this.setEnabled(false);
                return;
            }
            if (this.currentLayer != null && this.currentLayer.isBackgroundLayer()) {
                this.groundLayer = this.currentLayer;
                this.setEnabled(true);
                return;
            }
            for (Layer l : this.frame.mapView.getAllLayers()) {
                if (!l.isBackgroundLayer()) continue;
                this.groundLayer = l;
                this.setEnabled(true);
                return;
            }
            this.groundLayer = null;
            this.setEnabled(false);
        }
    }
}

