/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImportImagePlugin;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LayerPropertiesDialog;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.tools.I18n;

public class ImageLayer
extends Layer {
    private Logger logger = Logger.getLogger(ImageLayer.class);
    private File imageFile;
    private BufferedImage image = null;
    private EastNorth upperLeft;
    private double angle = 0.0;
    private Envelope2D bbox;
    private Icon layericon = null;
    private CoordinateReferenceSystem sourceRefSys;

    public ImageLayer(File file) throws IOException {
        super(file.getName());
        this.imageFile = file;
        this.image = (BufferedImage)this.createImage();
        this.layericon = new ImageIcon(ImportImagePlugin.pluginClassLoader.getResource("images/layericon.png"));
    }

    private Image createImage() throws IOException {
        GridCoverage2D coverage = null;
        try {
            coverage = PluginOperations.createGridFromFile(this.imageFile, null);
            this.sourceRefSys = coverage.getCoordinateReferenceSystem();
            coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)Main.proj.toCode()));
        }
        catch (FactoryException e) {
            this.logger.error("Error while creating GridCoverage:", e);
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            if (e.getMessage().contains("No projection file found")) {
                int useDefaultCRS = JOptionPane.showConfirmDialog(Main.parent, "<html>No projection file (.prj) found.<br>Use the default Coordinate Reference System instead?</html>", "Missing projection", 0);
                if (useDefaultCRS == 0) {
                    try {
                        coverage = PluginOperations.createGridFromFile(this.imageFile, PluginOperations.defaultSourceCRS);
                        this.sourceRefSys = coverage.getCoordinateReferenceSystem();
                        coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)Main.proj.toCode()));
                    }
                    catch (Exception e1) {
                        this.logger.error("Error while creating GridCoverage:", e1);
                        throw new IOException(e1);
                    }
                }
                this.logger.debug("Layer creation cancled by user due to missing projection information.");
                throw new LayerCreationCancledException();
            }
            this.logger.error("Error while creating GridCoverage:", e);
            throw new IOException(e);
        }
        this.logger.debug("Coverage created: " + coverage);
        this.upperLeft = new EastNorth(coverage.getEnvelope2D().y, coverage.getEnvelope2D().x + coverage.getEnvelope2D().width);
        this.angle = 0.0;
        this.bbox = coverage.getEnvelope2D();
        ImageWorker worker = new ImageWorker(coverage.getRenderedImage());
        return worker.getBufferedImage();
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bounds) {
        if (this.image != null && g2 != null) {
            EastNorth center = Main.map.mapView.getCenter();
            EastNorth leftop = Main.map.mapView.getEastNorth(0, 0);
            double pixel_per_lon_degree = (double)Main.map.mapView.getWidth() / 2.0 / (center.east() - leftop.east());
            double pixel_per_lat_degree = (double)Main.map.mapView.getHeight() / 2.0 / (leftop.north() - center.north());
            double pic_offset_x = (this.upperLeft.east() - leftop.east()) * pixel_per_lon_degree;
            double pic_offset_y = (leftop.north() - this.upperLeft.north()) * pixel_per_lat_degree;
            Graphics2D g = (Graphics2D)g2.create();
            g.translate(pic_offset_x, pic_offset_y);
            g.rotate(this.angle * Math.PI / 180.0);
            ProjectionBounds projbounds = Main.map.mapView.getProjectionBounds();
            double width = projbounds.maxEast - projbounds.minEast;
            double height = projbounds.maxNorth - projbounds.minNorth;
            double ratio_x = (this.bbox.getMaxY() - this.bbox.getMinY()) / width;
            double ratio_y = (this.bbox.getMaxX() - this.bbox.getMinX()) / height;
            double pixels4bbox_width = ratio_x * (double)Main.map.mapView.getWidth();
            double pixels4bbox_height = ratio_y * (double)Main.map.mapView.getHeight();
            double scalex = pixels4bbox_width / (double)this.image.getWidth();
            double scaley = pixels4bbox_height / (double)this.image.getHeight();
            g.scale(scalex, scaley);
            g.drawImage((Image)this.image, 0, 0, null);
        } else {
            this.logger.error("Error while dawing image: image == null or Graphics == null");
        }
    }

    public Envelope2D getBbox() {
        return this.bbox;
    }

    public Icon getIcon() {
        return this.layericon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction((Layer)this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), new LayerPropertiesAction(this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    public String getToolTipText() {
        return this.getName();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    void resample(CoordinateReferenceSystem refSys) throws IOException, NoSuchAuthorityCodeException, FactoryException {
        GridCoverage2D coverage = PluginOperations.createGridFromFile(this.imageFile, refSys);
        coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)Main.proj.toCode()));
        this.bbox = coverage.getEnvelope2D();
        this.image = ((PlanarImage)coverage.getRenderedImage()).getAsBufferedImage();
        this.upperLeft = new EastNorth(coverage.getEnvelope2D().y, coverage.getEnvelope2D().x + coverage.getEnvelope2D().width);
        this.angle = 0.0;
        Main.map.mapView.repaint();
        LatLon min = new LatLon(this.bbox.getMinX(), this.bbox.getMinY());
        LatLon max = new LatLon(this.bbox.getMaxX(), this.bbox.getMaxY());
        Main.map.mapView.zoomTo(new Bounds(min, max));
    }

    public CoordinateReferenceSystem getSourceRefSys() {
        return this.sourceRefSys;
    }

    public void setSourceRefSys(CoordinateReferenceSystem sourceRefSys) {
        this.sourceRefSys = sourceRefSys;
    }

    class LayerCreationCancledException
    extends IOException {
        LayerCreationCancledException() {
        }
    }

    public class LayerPropertiesAction
    extends AbstractAction {
        public ImageLayer imageLayer;

        public LayerPropertiesAction(ImageLayer imageLayer2) {
            super(I18n.tr((String)"Layer Properties"));
            this.imageLayer = imageLayer2;
        }

        public void actionPerformed(ActionEvent arg0) {
            LayerPropertiesDialog layerProps = new LayerPropertiesDialog(this.imageLayer, PluginOperations.crsDescriptions);
            layerProps.setLocation(Main.parent.getWidth() / 4, Main.parent.getHeight() / 4);
            layerProps.setVisible(true);
        }
    }
}

