/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class TCEAProjection
extends Projection {
    private double rk0;

    public TCEAProjection() {
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = this.rk0 * Math.cos(d2) * Math.sin(d);
        projCoordinate.y = this.scaleFactor * (Math.atan2(Math.tan(d2), Math.cos(d)) - this.projectionLatitude);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = d2 * this.rk0 + this.projectionLatitude;
        projCoordinate.x *= this.scaleFactor;
        double d3 = Math.sqrt(1.0 - d * d);
        projCoordinate.y = Math.asin(d3 * Math.sin(d2));
        projCoordinate.x = Math.atan2(d, d3 * Math.cos(d2));
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.rk0 = 1.0 / this.scaleFactor;
    }

    @Override
    public boolean isRectilinear() {
        return false;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Transverse Cylindrical Equal Area";
    }
}

