/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class NellHProjection
extends Projection {
    private static final int NITER = 9;
    private static final double EPS = 1.0E-7;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = 0.5 * d * (1.0 + Math.cos(d2));
        projCoordinate.y = 2.0 * (d2 - Math.tan(0.5 * d2));
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = 0.5 * d2;
        for (n = 9; n > 0; --n) {
            double d4 = Math.cos(0.5 * d2);
            double d5 = (d2 - Math.tan(d2 / 2.0) - d3) / (1.0 - 0.5 / (d4 * d4));
            projCoordinate.y -= d5;
            if (Math.abs(d5) < 1.0E-7) break;
        }
        if (n == 0) {
            projCoordinate.y = d3 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            projCoordinate.x = 2.0 * d;
        } else {
            projCoordinate.x = 2.0 * d / (1.0 + Math.cos(d2));
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Nell-Hammer";
    }
}

